# coding: utf-8
# Modified Work: Copyright (c) 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# Original Work: Copyright (c) 2018 Character Encoding Detector contributors.  https://github.com/chardet

#!/usr/bin/env python
# -*- coding: utf-8 -*-

from ..chardet.sbcharsetprober import SingleByteCharSetModel


# 3: Positive
# 2: Likely
# 1: Unlikely
# 0: Negative

BULGARIAN_LANG_MODEL = {
    63: {  # 'e'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 0,  # 'а'
        18: 1,  # 'б'
        9: 1,  # 'в'
        20: 1,  # 'г'
        11: 1,  # 'д'
        3: 1,  # 'е'
        23: 1,  # 'ж'
        15: 1,  # 'з'
        2: 0,  # 'и'
        26: 1,  # 'й'
        12: 1,  # 'к'
        10: 1,  # 'л'
        14: 1,  # 'м'
        6: 1,  # 'н'
        4: 1,  # 'о'
        13: 1,  # 'п'
        7: 1,  # 'р'
        8: 1,  # 'с'
        5: 1,  # 'т'
        19: 0,  # 'у'
        29: 1,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 1,  # 'ч'
        27: 1,  # 'ш'
        24: 1,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    45: {  # '\xad'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 0,  # 'Г'
        37: 1,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 0,  # 'Л'
        38: 1,  # 'М'
        36: 0,  # 'Н'
        41: 1,  # 'О'
        30: 1,  # 'П'
        39: 1,  # 'Р'
        28: 1,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 1,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 0,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 0,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 0,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 0,  # 'о'
        13: 0,  # 'п'
        7: 0,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 0,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    31: {  # 'А'
        63: 0,  # 'e'
        45: 1,  # '\xad'
        31: 1,  # 'А'
        32: 1,  # 'Б'
        35: 2,  # 'В'
        43: 1,  # 'Г'
        37: 2,  # 'Д'
        44: 2,  # 'Е'
        55: 1,  # 'Ж'
        47: 2,  # 'З'
        40: 1,  # 'И'
        59: 1,  # 'Й'
        33: 1,  # 'К'
        46: 2,  # 'Л'
        38: 1,  # 'М'
        36: 2,  # 'Н'
        41: 1,  # 'О'
        30: 2,  # 'П'
        39: 2,  # 'Р'
        28: 2,  # 'С'
        34: 2,  # 'Т'
        51: 1,  # 'У'
        48: 2,  # 'Ф'
        49: 1,  # 'Х'
        53: 1,  # 'Ц'
        50: 1,  # 'Ч'
        54: 1,  # 'Ш'
        57: 2,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 1,  # 'Я'
        1: 1,  # 'а'
        18: 2,  # 'б'
        9: 2,  # 'в'
        20: 2,  # 'г'
        11: 2,  # 'д'
        3: 1,  # 'е'
        23: 1,  # 'ж'
        15: 2,  # 'з'
        2: 0,  # 'и'
        26: 2,  # 'й'
        12: 2,  # 'к'
        10: 3,  # 'л'
        14: 2,  # 'м'
        6: 3,  # 'н'
        4: 0,  # 'о'
        13: 2,  # 'п'
        7: 2,  # 'р'
        8: 2,  # 'с'
        5: 2,  # 'т'
        19: 1,  # 'у'
        29: 2,  # 'ф'
        25: 1,  # 'х'
        22: 1,  # 'ц'
        21: 1,  # 'ч'
        27: 1,  # 'ш'
        24: 0,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    32: {  # 'Б'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 2,  # 'Б'
        35: 1,  # 'В'
        43: 1,  # 'Г'
        37: 2,  # 'Д'
        44: 1,  # 'Е'
        55: 1,  # 'Ж'
        47: 2,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 2,  # 'Н'
        41: 2,  # 'О'
        30: 1,  # 'П'
        39: 1,  # 'Р'
        28: 2,  # 'С'
        34: 2,  # 'Т'
        51: 1,  # 'У'
        48: 2,  # 'Ф'
        49: 1,  # 'Х'
        53: 1,  # 'Ц'
        50: 1,  # 'Ч'
        54: 0,  # 'Ш'
        57: 1,  # 'Щ'
        61: 2,  # 'Ъ'
        60: 1,  # 'Ю'
        56: 1,  # 'Я'
        1: 3,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 1,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 2,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 2,  # 'р'
        8: 1,  # 'с'
        5: 0,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 3,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 2,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    35: {  # 'В'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 0,  # 'Г'
        37: 1,  # 'Д'
        44: 2,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 1,  # 'О'
        30: 1,  # 'П'
        39: 2,  # 'Р'
        28: 2,  # 'С'
        34: 1,  # 'Т'
        51: 1,  # 'У'
        48: 2,  # 'Ф'
        49: 0,  # 'Х'
        53: 1,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 1,  # 'Ю'
        56: 2,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 1,  # 'д'
        3: 3,  # 'е'
        23: 1,  # 'ж'
        15: 2,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 2,  # 'л'
        14: 1,  # 'м'
        6: 2,  # 'н'
        4: 2,  # 'о'
        13: 1,  # 'п'
        7: 2,  # 'р'
        8: 2,  # 'с'
        5: 2,  # 'т'
        19: 1,  # 'у'
        29: 0,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 2,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    43: {  # 'Г'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 1,  # 'Д'
        44: 2,  # 'Е'
        55: 0,  # 'Ж'
        47: 1,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 0,  # 'М'
        36: 1,  # 'Н'
        41: 1,  # 'О'
        30: 0,  # 'П'
        39: 1,  # 'Р'
        28: 1,  # 'С'
        34: 0,  # 'Т'
        51: 1,  # 'У'
        48: 1,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 1,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 2,  # 'а'
        18: 1,  # 'б'
        9: 1,  # 'в'
        20: 0,  # 'г'
        11: 1,  # 'д'
        3: 3,  # 'е'
        23: 1,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 2,  # 'л'
        14: 1,  # 'м'
        6: 1,  # 'н'
        4: 2,  # 'о'
        13: 0,  # 'п'
        7: 2,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 1,  # 'щ'
        17: 2,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    37: {  # 'Д'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 2,  # 'В'
        43: 1,  # 'Г'
        37: 2,  # 'Д'
        44: 2,  # 'Е'
        55: 2,  # 'Ж'
        47: 1,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 2,  # 'О'
        30: 2,  # 'П'
        39: 1,  # 'Р'
        28: 2,  # 'С'
        34: 1,  # 'Т'
        51: 1,  # 'У'
        48: 1,  # 'Ф'
        49: 0,  # 'Х'
        53: 1,  # 'Ц'
        50: 1,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 1,  # 'Ю'
        56: 1,  # 'Я'
        1: 3,  # 'а'
        18: 0,  # 'б'
        9: 2,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 3,  # 'е'
        23: 3,  # 'ж'
        15: 1,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 1,  # 'л'
        14: 1,  # 'м'
        6: 2,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 2,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 1,  # 'ь'
        42: 2,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    44: {  # 'Е'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 1,  # 'А'
        32: 1,  # 'Б'
        35: 2,  # 'В'
        43: 1,  # 'Г'
        37: 1,  # 'Д'
        44: 1,  # 'Е'
        55: 1,  # 'Ж'
        47: 1,  # 'З'
        40: 1,  # 'И'
        59: 1,  # 'Й'
        33: 2,  # 'К'
        46: 2,  # 'Л'
        38: 1,  # 'М'
        36: 2,  # 'Н'
        41: 2,  # 'О'
        30: 1,  # 'П'
        39: 2,  # 'Р'
        28: 2,  # 'С'
        34: 2,  # 'Т'
        51: 1,  # 'У'
        48: 2,  # 'Ф'
        49: 1,  # 'Х'
        53: 2,  # 'Ц'
        50: 1,  # 'Ч'
        54: 1,  # 'Ш'
        57: 1,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 1,  # 'Я'
        1: 0,  # 'а'
        18: 1,  # 'б'
        9: 2,  # 'в'
        20: 1,  # 'г'
        11: 2,  # 'д'
        3: 0,  # 'е'
        23: 1,  # 'ж'
        15: 1,  # 'з'
        2: 0,  # 'и'
        26: 1,  # 'й'
        12: 2,  # 'к'
        10: 2,  # 'л'
        14: 2,  # 'м'
        6: 2,  # 'н'
        4: 0,  # 'о'
        13: 1,  # 'п'
        7: 2,  # 'р'
        8: 2,  # 'с'
        5: 1,  # 'т'
        19: 1,  # 'у'
        29: 1,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 1,  # 'ч'
        27: 1,  # 'ш'
        24: 1,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    55: {  # 'Ж'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 1,  # 'А'
        32: 0,  # 'Б'
        35: 1,  # 'В'
        43: 0,  # 'Г'
        37: 1,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 1,  # 'Н'
        41: 1,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 1,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 2,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 1,  # 'д'
        3: 2,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 2,  # 'о'
        13: 1,  # 'п'
        7: 1,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 1,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    47: {  # 'З'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 1,  # 'Г'
        37: 1,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 1,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 2,  # 'Н'
        41: 1,  # 'О'
        30: 1,  # 'П'
        39: 1,  # 'Р'
        28: 1,  # 'С'
        34: 1,  # 'Т'
        51: 1,  # 'У'
        48: 0,  # 'Ф'
        49: 1,  # 'Х'
        53: 1,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 1,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 2,  # 'в'
        20: 1,  # 'г'
        11: 2,  # 'д'
        3: 2,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 1,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 2,  # 'л'
        14: 1,  # 'м'
        6: 1,  # 'н'
        4: 1,  # 'о'
        13: 0,  # 'п'
        7: 1,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 1,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    40: {  # 'И'
        63: 0,  # 'e'
        45: 1,  # '\xad'
        31: 1,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 1,  # 'Г'
        37: 1,  # 'Д'
        44: 2,  # 'Е'
        55: 1,  # 'Ж'
        47: 2,  # 'З'
        40: 1,  # 'И'
        59: 1,  # 'Й'
        33: 2,  # 'К'
        46: 2,  # 'Л'
        38: 2,  # 'М'
        36: 2,  # 'Н'
        41: 1,  # 'О'
        30: 1,  # 'П'
        39: 2,  # 'Р'
        28: 2,  # 'С'
        34: 2,  # 'Т'
        51: 0,  # 'У'
        48: 1,  # 'Ф'
        49: 1,  # 'Х'
        53: 1,  # 'Ц'
        50: 1,  # 'Ч'
        54: 1,  # 'Ш'
        57: 1,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 2,  # 'Я'
        1: 1,  # 'а'
        18: 1,  # 'б'
        9: 3,  # 'в'
        20: 2,  # 'г'
        11: 1,  # 'д'
        3: 1,  # 'е'
        23: 0,  # 'ж'
        15: 3,  # 'з'
        2: 0,  # 'и'
        26: 1,  # 'й'
        12: 1,  # 'к'
        10: 2,  # 'л'
        14: 2,  # 'м'
        6: 2,  # 'н'
        4: 0,  # 'о'
        13: 1,  # 'п'
        7: 2,  # 'р'
        8: 2,  # 'с'
        5: 2,  # 'т'
        19: 0,  # 'у'
        29: 1,  # 'ф'
        25: 1,  # 'х'
        22: 1,  # 'ц'
        21: 1,  # 'ч'
        27: 1,  # 'ш'
        24: 1,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    59: {  # 'Й'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 1,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 1,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 1,  # 'С'
        34: 1,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 1,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 1,  # 'Я'
        1: 0,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 1,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 0,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 2,  # 'о'
        13: 0,  # 'п'
        7: 0,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 0,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    33: {  # 'К'
        63: 0,  # 'e'
        45: 1,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 1,  # 'Г'
        37: 1,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 1,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 0,  # 'М'
        36: 2,  # 'Н'
        41: 2,  # 'О'
        30: 2,  # 'П'
        39: 1,  # 'Р'
        28: 2,  # 'С'
        34: 1,  # 'Т'
        51: 1,  # 'У'
        48: 1,  # 'Ф'
        49: 1,  # 'Х'
        53: 1,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 1,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 0,  # 'б'
        9: 1,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 2,  # 'е'
        23: 1,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 2,  # 'л'
        14: 1,  # 'м'
        6: 2,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 3,  # 'р'
        8: 1,  # 'с'
        5: 0,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 1,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 1,  # 'ь'
        42: 2,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    46: {  # 'Л'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 2,  # 'Г'
        37: 1,  # 'Д'
        44: 2,  # 'Е'
        55: 0,  # 'Ж'
        47: 1,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 0,  # 'М'
        36: 1,  # 'Н'
        41: 2,  # 'О'
        30: 1,  # 'П'
        39: 0,  # 'Р'
        28: 1,  # 'С'
        34: 1,  # 'Т'
        51: 1,  # 'У'
        48: 0,  # 'Ф'
        49: 1,  # 'Х'
        53: 1,  # 'Ц'
        50: 1,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 1,  # 'Ю'
        56: 1,  # 'Я'
        1: 2,  # 'а'
        18: 0,  # 'б'
        9: 1,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 2,  # 'о'
        13: 0,  # 'п'
        7: 0,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 1,  # 'ь'
        42: 2,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    38: {  # 'М'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 2,  # 'В'
        43: 0,  # 'Г'
        37: 1,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 1,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 2,  # 'О'
        30: 1,  # 'П'
        39: 1,  # 'Р'
        28: 2,  # 'С'
        34: 1,  # 'Т'
        51: 1,  # 'У'
        48: 1,  # 'Ф'
        49: 0,  # 'Х'
        53: 1,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 1,  # 'Я'
        1: 3,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 2,  # 'л'
        14: 0,  # 'м'
        6: 2,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 1,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 1,  # 'ь'
        42: 2,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    36: {  # 'Н'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 2,  # 'Б'
        35: 1,  # 'В'
        43: 1,  # 'Г'
        37: 2,  # 'Д'
        44: 2,  # 'Е'
        55: 1,  # 'Ж'
        47: 1,  # 'З'
        40: 2,  # 'И'
        59: 1,  # 'Й'
        33: 2,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 2,  # 'О'
        30: 1,  # 'П'
        39: 1,  # 'Р'
        28: 2,  # 'С'
        34: 2,  # 'Т'
        51: 1,  # 'У'
        48: 1,  # 'Ф'
        49: 1,  # 'Х'
        53: 1,  # 'Ц'
        50: 1,  # 'Ч'
        54: 1,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 1,  # 'Ю'
        56: 1,  # 'Я'
        1: 3,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 1,  # 'г'
        11: 0,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 0,  # 'р'
        8: 0,  # 'с'
        5: 1,  # 'т'
        19: 1,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 1,  # 'ш'
        24: 0,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 2,  # 'ю'
        16: 2,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    41: {  # 'О'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 1,  # 'А'
        32: 1,  # 'Б'
        35: 2,  # 'В'
        43: 1,  # 'Г'
        37: 2,  # 'Д'
        44: 1,  # 'Е'
        55: 1,  # 'Ж'
        47: 1,  # 'З'
        40: 1,  # 'И'
        59: 1,  # 'Й'
        33: 2,  # 'К'
        46: 2,  # 'Л'
        38: 2,  # 'М'
        36: 2,  # 'Н'
        41: 2,  # 'О'
        30: 1,  # 'П'
        39: 2,  # 'Р'
        28: 2,  # 'С'
        34: 2,  # 'Т'
        51: 1,  # 'У'
        48: 1,  # 'Ф'
        49: 1,  # 'Х'
        53: 0,  # 'Ц'
        50: 1,  # 'Ч'
        54: 1,  # 'Ш'
        57: 1,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 1,  # 'Я'
        1: 1,  # 'а'
        18: 2,  # 'б'
        9: 2,  # 'в'
        20: 2,  # 'г'
        11: 1,  # 'д'
        3: 1,  # 'е'
        23: 1,  # 'ж'
        15: 1,  # 'з'
        2: 0,  # 'и'
        26: 1,  # 'й'
        12: 2,  # 'к'
        10: 2,  # 'л'
        14: 1,  # 'м'
        6: 1,  # 'н'
        4: 0,  # 'о'
        13: 2,  # 'п'
        7: 2,  # 'р'
        8: 2,  # 'с'
        5: 3,  # 'т'
        19: 1,  # 'у'
        29: 1,  # 'ф'
        25: 1,  # 'х'
        22: 1,  # 'ц'
        21: 2,  # 'ч'
        27: 0,  # 'ш'
        24: 2,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    30: {  # 'П'
        63: 0,  # 'e'
        45: 1,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 1,  # 'Г'
        37: 1,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 1,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 2,  # 'О'
        30: 2,  # 'П'
        39: 2,  # 'Р'
        28: 2,  # 'С'
        34: 1,  # 'Т'
        51: 2,  # 'У'
        48: 1,  # 'Ф'
        49: 0,  # 'Х'
        53: 1,  # 'Ц'
        50: 1,  # 'Ч'
        54: 1,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 1,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 2,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 3,  # 'л'
        14: 0,  # 'м'
        6: 1,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 3,  # 'р'
        8: 1,  # 'с'
        5: 1,  # 'т'
        19: 2,  # 'у'
        29: 1,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 1,  # 'ч'
        27: 1,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    39: {  # 'Р'
        63: 0,  # 'e'
        45: 1,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 2,  # 'Г'
        37: 2,  # 'Д'
        44: 2,  # 'Е'
        55: 0,  # 'Ж'
        47: 1,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 0,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 2,  # 'О'
        30: 2,  # 'П'
        39: 1,  # 'Р'
        28: 1,  # 'С'
        34: 1,  # 'Т'
        51: 1,  # 'У'
        48: 1,  # 'Ф'
        49: 1,  # 'Х'
        53: 1,  # 'Ц'
        50: 1,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 1,  # 'Ю'
        56: 1,  # 'Я'
        1: 3,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 2,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 1,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 0,  # 'р'
        8: 1,  # 'с'
        5: 0,  # 'т'
        19: 3,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    28: {  # 'С'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 3,  # 'А'
        32: 2,  # 'Б'
        35: 2,  # 'В'
        43: 1,  # 'Г'
        37: 2,  # 'Д'
        44: 2,  # 'Е'
        55: 1,  # 'Ж'
        47: 1,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 2,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 2,  # 'О'
        30: 2,  # 'П'
        39: 1,  # 'Р'
        28: 2,  # 'С'
        34: 2,  # 'Т'
        51: 1,  # 'У'
        48: 1,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 1,  # 'Ю'
        56: 1,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 2,  # 'в'
        20: 1,  # 'г'
        11: 1,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 2,  # 'к'
        10: 3,  # 'л'
        14: 2,  # 'м'
        6: 1,  # 'н'
        4: 3,  # 'о'
        13: 3,  # 'п'
        7: 2,  # 'р'
        8: 0,  # 'с'
        5: 3,  # 'т'
        19: 2,  # 'у'
        29: 2,  # 'ф'
        25: 1,  # 'х'
        22: 1,  # 'ц'
        21: 1,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 3,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    34: {  # 'Т'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 2,  # 'Б'
        35: 1,  # 'В'
        43: 0,  # 'Г'
        37: 1,  # 'Д'
        44: 2,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 2,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 2,  # 'О'
        30: 1,  # 'П'
        39: 2,  # 'Р'
        28: 2,  # 'С'
        34: 1,  # 'Т'
        51: 1,  # 'У'
        48: 1,  # 'Ф'
        49: 0,  # 'Х'
        53: 1,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 1,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 1,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 1,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 1,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 3,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 2,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    51: {  # 'У'
        63: 0,  # 'e'
        45: 1,  # '\xad'
        31: 1,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 1,  # 'Г'
        37: 1,  # 'Д'
        44: 2,  # 'Е'
        55: 1,  # 'Ж'
        47: 1,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 0,  # 'О'
        30: 1,  # 'П'
        39: 1,  # 'Р'
        28: 1,  # 'С'
        34: 2,  # 'Т'
        51: 0,  # 'У'
        48: 1,  # 'Ф'
        49: 1,  # 'Х'
        53: 1,  # 'Ц'
        50: 1,  # 'Ч'
        54: 1,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 1,  # 'а'
        18: 1,  # 'б'
        9: 2,  # 'в'
        20: 1,  # 'г'
        11: 1,  # 'д'
        3: 2,  # 'е'
        23: 1,  # 'ж'
        15: 1,  # 'з'
        2: 2,  # 'и'
        26: 1,  # 'й'
        12: 2,  # 'к'
        10: 1,  # 'л'
        14: 1,  # 'м'
        6: 2,  # 'н'
        4: 2,  # 'о'
        13: 1,  # 'п'
        7: 1,  # 'р'
        8: 2,  # 'с'
        5: 1,  # 'т'
        19: 1,  # 'у'
        29: 0,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 2,  # 'ч'
        27: 1,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    48: {  # 'Ф'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 0,  # 'М'
        36: 1,  # 'Н'
        41: 1,  # 'О'
        30: 2,  # 'П'
        39: 1,  # 'Р'
        28: 2,  # 'С'
        34: 1,  # 'Т'
        51: 1,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 2,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 2,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 2,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 2,  # 'о'
        13: 0,  # 'п'
        7: 2,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 1,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    49: {  # 'Х'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 1,  # 'А'
        32: 0,  # 'Б'
        35: 1,  # 'В'
        43: 1,  # 'Г'
        37: 1,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 1,  # 'О'
        30: 1,  # 'П'
        39: 1,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 1,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 2,  # 'а'
        18: 0,  # 'б'
        9: 1,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 2,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 1,  # 'л'
        14: 1,  # 'м'
        6: 0,  # 'н'
        4: 2,  # 'о'
        13: 0,  # 'п'
        7: 2,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    53: {  # 'Ц'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 1,  # 'А'
        32: 0,  # 'Б'
        35: 1,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 2,  # 'И'
        59: 0,  # 'Й'
        33: 2,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 1,  # 'Р'
        28: 2,  # 'С'
        34: 0,  # 'Т'
        51: 1,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 2,  # 'а'
        18: 0,  # 'б'
        9: 2,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 2,  # 'е'
        23: 0,  # 'ж'
        15: 1,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 1,  # 'о'
        13: 0,  # 'п'
        7: 1,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 1,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    50: {  # 'Ч'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 2,  # 'А'
        32: 1,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 1,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 0,  # 'М'
        36: 1,  # 'Н'
        41: 1,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 1,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 2,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 3,  # 'е'
        23: 1,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 1,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 2,  # 'о'
        13: 0,  # 'п'
        7: 1,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 1,  # 'ь'
        42: 0,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    54: {  # 'Ш'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 1,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 1,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 1,  # 'Н'
        41: 1,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 1,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 2,  # 'а'
        18: 0,  # 'б'
        9: 2,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 2,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 2,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 1,  # 'л'
        14: 1,  # 'м'
        6: 1,  # 'н'
        4: 2,  # 'о'
        13: 1,  # 'п'
        7: 1,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 1,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 1,  # 'ь'
        42: 0,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    57: {  # 'Щ'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 1,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 1,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 2,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 2,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 1,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 1,  # 'о'
        13: 0,  # 'п'
        7: 1,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 1,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    61: {  # 'Ъ'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 0,  # 'Г'
        37: 1,  # 'Д'
        44: 0,  # 'Е'
        55: 1,  # 'Ж'
        47: 1,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 2,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 0,  # 'О'
        30: 1,  # 'П'
        39: 2,  # 'Р'
        28: 1,  # 'С'
        34: 1,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 1,  # 'Х'
        53: 1,  # 'Ц'
        50: 1,  # 'Ч'
        54: 1,  # 'Ш'
        57: 1,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 0,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 0,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 0,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 1,  # 'л'
        14: 0,  # 'м'
        6: 1,  # 'н'
        4: 0,  # 'о'
        13: 0,  # 'п'
        7: 1,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 0,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    60: {  # 'Ю'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 1,  # 'А'
        32: 1,  # 'Б'
        35: 0,  # 'В'
        43: 1,  # 'Г'
        37: 1,  # 'Д'
        44: 0,  # 'Е'
        55: 1,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 0,  # 'М'
        36: 1,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 1,  # 'Р'
        28: 1,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 0,  # 'а'
        18: 1,  # 'б'
        9: 1,  # 'в'
        20: 2,  # 'г'
        11: 1,  # 'д'
        3: 0,  # 'е'
        23: 2,  # 'ж'
        15: 1,  # 'з'
        2: 1,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 1,  # 'л'
        14: 1,  # 'м'
        6: 1,  # 'н'
        4: 0,  # 'о'
        13: 1,  # 'п'
        7: 1,  # 'р'
        8: 1,  # 'с'
        5: 1,  # 'т'
        19: 0,  # 'у'
        29: 0,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    56: {  # 'Я'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 1,  # 'Б'
        35: 1,  # 'В'
        43: 1,  # 'Г'
        37: 1,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 1,  # 'Л'
        38: 1,  # 'М'
        36: 1,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 1,  # 'С'
        34: 2,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 0,  # 'а'
        18: 1,  # 'б'
        9: 1,  # 'в'
        20: 1,  # 'г'
        11: 1,  # 'д'
        3: 0,  # 'е'
        23: 0,  # 'ж'
        15: 1,  # 'з'
        2: 1,  # 'и'
        26: 1,  # 'й'
        12: 1,  # 'к'
        10: 1,  # 'л'
        14: 2,  # 'м'
        6: 2,  # 'н'
        4: 0,  # 'о'
        13: 2,  # 'п'
        7: 1,  # 'р'
        8: 1,  # 'с'
        5: 1,  # 'т'
        19: 0,  # 'у'
        29: 0,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 1,  # 'ш'
        24: 0,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    1: {  # 'а'
        63: 1,  # 'e'
        45: 1,  # '\xad'
        31: 1,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 1,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 1,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 3,  # 'г'
        11: 3,  # 'д'
        3: 3,  # 'е'
        23: 3,  # 'ж'
        15: 3,  # 'з'
        2: 3,  # 'и'
        26: 3,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 2,  # 'о'
        13: 3,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 3,  # 'у'
        29: 3,  # 'ф'
        25: 3,  # 'х'
        22: 3,  # 'ц'
        21: 3,  # 'ч'
        27: 3,  # 'ш'
        24: 3,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    18: {  # 'б'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 0,  # 'б'
        9: 3,  # 'в'
        20: 1,  # 'г'
        11: 2,  # 'д'
        3: 3,  # 'е'
        23: 1,  # 'ж'
        15: 1,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 3,  # 'л'
        14: 2,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 1,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 0,  # 'т'
        19: 3,  # 'у'
        29: 0,  # 'ф'
        25: 2,  # 'х'
        22: 1,  # 'ц'
        21: 1,  # 'ч'
        27: 1,  # 'ш'
        24: 3,  # 'щ'
        17: 3,  # 'ъ'
        52: 1,  # 'ь'
        42: 2,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    9: {  # 'в'
        63: 1,  # 'e'
        45: 1,  # '\xad'
        31: 0,  # 'А'
        32: 1,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 1,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 0,  # 'в'
        20: 2,  # 'г'
        11: 3,  # 'д'
        3: 3,  # 'е'
        23: 1,  # 'ж'
        15: 3,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 2,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 2,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 2,  # 'х'
        22: 2,  # 'ц'
        21: 3,  # 'ч'
        27: 2,  # 'ш'
        24: 1,  # 'щ'
        17: 3,  # 'ъ'
        52: 1,  # 'ь'
        42: 2,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    20: {  # 'г'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 2,  # 'в'
        20: 1,  # 'г'
        11: 2,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 1,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 3,  # 'л'
        14: 1,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 1,  # 'п'
        7: 3,  # 'р'
        8: 2,  # 'с'
        5: 2,  # 'т'
        19: 3,  # 'у'
        29: 1,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 1,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 3,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    11: {  # 'д'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 2,  # 'б'
        9: 3,  # 'в'
        20: 2,  # 'г'
        11: 2,  # 'д'
        3: 3,  # 'е'
        23: 3,  # 'ж'
        15: 2,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 3,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 1,  # 'т'
        19: 3,  # 'у'
        29: 1,  # 'ф'
        25: 2,  # 'х'
        22: 2,  # 'ц'
        21: 2,  # 'ч'
        27: 1,  # 'ш'
        24: 1,  # 'щ'
        17: 3,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    3: {  # 'е'
        63: 0,  # 'e'
        45: 1,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 2,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 3,  # 'г'
        11: 3,  # 'д'
        3: 2,  # 'е'
        23: 3,  # 'ж'
        15: 3,  # 'з'
        2: 2,  # 'и'
        26: 3,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 3,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 2,  # 'у'
        29: 3,  # 'ф'
        25: 3,  # 'х'
        22: 3,  # 'ц'
        21: 3,  # 'ч'
        27: 3,  # 'ш'
        24: 3,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    23: {  # 'ж'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 3,  # 'б'
        9: 2,  # 'в'
        20: 1,  # 'г'
        11: 3,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 2,  # 'к'
        10: 1,  # 'л'
        14: 1,  # 'м'
        6: 3,  # 'н'
        4: 2,  # 'о'
        13: 1,  # 'п'
        7: 1,  # 'р'
        8: 1,  # 'с'
        5: 1,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 1,  # 'ц'
        21: 1,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    15: {  # 'з'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 3,  # 'г'
        11: 3,  # 'д'
        3: 3,  # 'е'
        23: 1,  # 'ж'
        15: 1,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 3,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 3,  # 'у'
        29: 1,  # 'ф'
        25: 2,  # 'х'
        22: 2,  # 'ц'
        21: 2,  # 'ч'
        27: 2,  # 'ш'
        24: 1,  # 'щ'
        17: 2,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 2,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    2: {  # 'и'
        63: 1,  # 'e'
        45: 1,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 1,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 1,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 1,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 1,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 3,  # 'г'
        11: 3,  # 'д'
        3: 3,  # 'е'
        23: 3,  # 'ж'
        15: 3,  # 'з'
        2: 3,  # 'и'
        26: 3,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 3,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 2,  # 'у'
        29: 3,  # 'ф'
        25: 3,  # 'х'
        22: 3,  # 'ц'
        21: 3,  # 'ч'
        27: 3,  # 'ш'
        24: 3,  # 'щ'
        17: 2,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    26: {  # 'й'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 1,  # 'а'
        18: 2,  # 'б'
        9: 2,  # 'в'
        20: 1,  # 'г'
        11: 2,  # 'д'
        3: 2,  # 'е'
        23: 0,  # 'ж'
        15: 2,  # 'з'
        2: 1,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 2,  # 'л'
        14: 2,  # 'м'
        6: 3,  # 'н'
        4: 2,  # 'о'
        13: 1,  # 'п'
        7: 2,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 1,  # 'у'
        29: 2,  # 'ф'
        25: 1,  # 'х'
        22: 2,  # 'ц'
        21: 2,  # 'ч'
        27: 1,  # 'ш'
        24: 1,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    12: {  # 'к'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 1,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 1,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 3,  # 'в'
        20: 2,  # 'г'
        11: 1,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 2,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 3,  # 'л'
        14: 2,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 1,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 3,  # 'у'
        29: 1,  # 'ф'
        25: 1,  # 'х'
        22: 3,  # 'ц'
        21: 2,  # 'ч'
        27: 1,  # 'ш'
        24: 0,  # 'щ'
        17: 3,  # 'ъ'
        52: 1,  # 'ь'
        42: 2,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    10: {  # 'л'
        63: 1,  # 'e'
        45: 1,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 1,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 3,  # 'г'
        11: 2,  # 'д'
        3: 3,  # 'е'
        23: 3,  # 'ж'
        15: 2,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 1,  # 'л'
        14: 2,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 2,  # 'п'
        7: 2,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 3,  # 'у'
        29: 2,  # 'ф'
        25: 2,  # 'х'
        22: 2,  # 'ц'
        21: 2,  # 'ч'
        27: 2,  # 'ш'
        24: 1,  # 'щ'
        17: 3,  # 'ъ'
        52: 2,  # 'ь'
        42: 3,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    14: {  # 'м'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 1,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 1,  # 'г'
        11: 1,  # 'д'
        3: 3,  # 'е'
        23: 1,  # 'ж'
        15: 1,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 2,  # 'к'
        10: 3,  # 'л'
        14: 1,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 3,  # 'п'
        7: 2,  # 'р'
        8: 2,  # 'с'
        5: 1,  # 'т'
        19: 3,  # 'у'
        29: 2,  # 'ф'
        25: 1,  # 'х'
        22: 2,  # 'ц'
        21: 2,  # 'ч'
        27: 2,  # 'ш'
        24: 1,  # 'щ'
        17: 3,  # 'ъ'
        52: 1,  # 'ь'
        42: 2,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    6: {  # 'н'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 1,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 2,  # 'б'
        9: 2,  # 'в'
        20: 3,  # 'г'
        11: 3,  # 'д'
        3: 3,  # 'е'
        23: 2,  # 'ж'
        15: 2,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 2,  # 'л'
        14: 1,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 1,  # 'п'
        7: 2,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 3,  # 'у'
        29: 3,  # 'ф'
        25: 2,  # 'х'
        22: 3,  # 'ц'
        21: 3,  # 'ч'
        27: 2,  # 'ш'
        24: 1,  # 'щ'
        17: 3,  # 'ъ'
        52: 2,  # 'ь'
        42: 2,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    4: {  # 'о'
        63: 0,  # 'e'
        45: 1,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 2,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 3,  # 'г'
        11: 3,  # 'д'
        3: 3,  # 'е'
        23: 3,  # 'ж'
        15: 3,  # 'з'
        2: 3,  # 'и'
        26: 3,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 2,  # 'о'
        13: 3,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 2,  # 'у'
        29: 3,  # 'ф'
        25: 3,  # 'х'
        22: 3,  # 'ц'
        21: 3,  # 'ч'
        27: 3,  # 'ш'
        24: 3,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    13: {  # 'п'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 2,  # 'в'
        20: 1,  # 'г'
        11: 1,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 1,  # 'з'
        2: 3,  # 'и'
        26: 1,  # 'й'
        12: 2,  # 'к'
        10: 3,  # 'л'
        14: 1,  # 'м'
        6: 2,  # 'н'
        4: 3,  # 'о'
        13: 1,  # 'п'
        7: 3,  # 'р'
        8: 2,  # 'с'
        5: 2,  # 'т'
        19: 3,  # 'у'
        29: 1,  # 'ф'
        25: 1,  # 'х'
        22: 2,  # 'ц'
        21: 2,  # 'ч'
        27: 1,  # 'ш'
        24: 1,  # 'щ'
        17: 3,  # 'ъ'
        52: 1,  # 'ь'
        42: 2,  # 'ю'
        16: 2,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    7: {  # 'р'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 3,  # 'г'
        11: 3,  # 'д'
        3: 3,  # 'е'
        23: 3,  # 'ж'
        15: 2,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 2,  # 'п'
        7: 1,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 3,  # 'у'
        29: 2,  # 'ф'
        25: 3,  # 'х'
        22: 3,  # 'ц'
        21: 2,  # 'ч'
        27: 3,  # 'ш'
        24: 1,  # 'щ'
        17: 3,  # 'ъ'
        52: 1,  # 'ь'
        42: 2,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    8: {  # 'с'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 2,  # 'б'
        9: 3,  # 'в'
        20: 2,  # 'г'
        11: 2,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 1,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 3,  # 'п'
        7: 3,  # 'р'
        8: 1,  # 'с'
        5: 3,  # 'т'
        19: 3,  # 'у'
        29: 2,  # 'ф'
        25: 2,  # 'х'
        22: 2,  # 'ц'
        21: 2,  # 'ч'
        27: 2,  # 'ш'
        24: 0,  # 'щ'
        17: 3,  # 'ъ'
        52: 2,  # 'ь'
        42: 2,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    5: {  # 'т'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 2,  # 'г'
        11: 2,  # 'д'
        3: 3,  # 'е'
        23: 1,  # 'ж'
        15: 1,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 2,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 2,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 3,  # 'у'
        29: 1,  # 'ф'
        25: 2,  # 'х'
        22: 2,  # 'ц'
        21: 2,  # 'ч'
        27: 1,  # 'ш'
        24: 1,  # 'щ'
        17: 3,  # 'ъ'
        52: 2,  # 'ь'
        42: 2,  # 'ю'
        16: 3,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    19: {  # 'у'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 3,  # 'г'
        11: 3,  # 'д'
        3: 2,  # 'е'
        23: 3,  # 'ж'
        15: 3,  # 'з'
        2: 2,  # 'и'
        26: 2,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 2,  # 'о'
        13: 3,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 1,  # 'у'
        29: 2,  # 'ф'
        25: 2,  # 'х'
        22: 2,  # 'ц'
        21: 3,  # 'ч'
        27: 3,  # 'ш'
        24: 2,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    29: {  # 'ф'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 1,  # 'в'
        20: 1,  # 'г'
        11: 0,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 2,  # 'к'
        10: 2,  # 'л'
        14: 1,  # 'м'
        6: 1,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 2,  # 'р'
        8: 2,  # 'с'
        5: 2,  # 'т'
        19: 2,  # 'у'
        29: 0,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 1,  # 'ч'
        27: 1,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 2,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    25: {  # 'х'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 3,  # 'в'
        20: 0,  # 'г'
        11: 1,  # 'д'
        3: 2,  # 'е'
        23: 0,  # 'ж'
        15: 1,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 2,  # 'л'
        14: 2,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 1,  # 'п'
        7: 3,  # 'р'
        8: 1,  # 'с'
        5: 2,  # 'т'
        19: 3,  # 'у'
        29: 0,  # 'ф'
        25: 1,  # 'х'
        22: 0,  # 'ц'
        21: 1,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    22: {  # 'ц'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 2,  # 'в'
        20: 1,  # 'г'
        11: 1,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 1,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 2,  # 'к'
        10: 1,  # 'л'
        14: 1,  # 'м'
        6: 1,  # 'н'
        4: 2,  # 'о'
        13: 1,  # 'п'
        7: 1,  # 'р'
        8: 1,  # 'с'
        5: 1,  # 'т'
        19: 2,  # 'у'
        29: 1,  # 'ф'
        25: 1,  # 'х'
        22: 1,  # 'ц'
        21: 1,  # 'ч'
        27: 1,  # 'ш'
        24: 1,  # 'щ'
        17: 2,  # 'ъ'
        52: 1,  # 'ь'
        42: 0,  # 'ю'
        16: 2,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    21: {  # 'ч'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 1,  # 'б'
        9: 3,  # 'в'
        20: 1,  # 'г'
        11: 0,  # 'д'
        3: 3,  # 'е'
        23: 1,  # 'ж'
        15: 0,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 2,  # 'л'
        14: 2,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 2,  # 'р'
        8: 0,  # 'с'
        5: 2,  # 'т'
        19: 3,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 1,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    27: {  # 'ш'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 0,  # 'б'
        9: 2,  # 'в'
        20: 0,  # 'г'
        11: 1,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 3,  # 'к'
        10: 2,  # 'л'
        14: 1,  # 'м'
        6: 3,  # 'н'
        4: 2,  # 'о'
        13: 2,  # 'п'
        7: 1,  # 'р'
        8: 0,  # 'с'
        5: 1,  # 'т'
        19: 2,  # 'у'
        29: 1,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 1,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 2,  # 'ъ'
        52: 1,  # 'ь'
        42: 1,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    24: {  # 'щ'
        63: 1,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 3,  # 'а'
        18: 0,  # 'б'
        9: 1,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 3,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 3,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 2,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 1,  # 'р'
        8: 0,  # 'с'
        5: 2,  # 'т'
        19: 3,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 1,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 2,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    17: {  # 'ъ'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 1,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 3,  # 'г'
        11: 3,  # 'д'
        3: 2,  # 'е'
        23: 3,  # 'ж'
        15: 3,  # 'з'
        2: 1,  # 'и'
        26: 2,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 3,  # 'о'
        13: 3,  # 'п'
        7: 3,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 1,  # 'у'
        29: 1,  # 'ф'
        25: 2,  # 'х'
        22: 2,  # 'ц'
        21: 3,  # 'ч'
        27: 2,  # 'ш'
        24: 3,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 2,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    52: {  # 'ь'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 0,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 1,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 0,  # 'и'
        26: 0,  # 'й'
        12: 1,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 1,  # 'н'
        4: 3,  # 'о'
        13: 0,  # 'п'
        7: 0,  # 'р'
        8: 0,  # 'с'
        5: 1,  # 'т'
        19: 0,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 1,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 1,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    42: {  # 'ю'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 1,  # 'а'
        18: 2,  # 'б'
        9: 1,  # 'в'
        20: 2,  # 'г'
        11: 2,  # 'д'
        3: 1,  # 'е'
        23: 2,  # 'ж'
        15: 2,  # 'з'
        2: 1,  # 'и'
        26: 1,  # 'й'
        12: 2,  # 'к'
        10: 2,  # 'л'
        14: 2,  # 'м'
        6: 2,  # 'н'
        4: 1,  # 'о'
        13: 1,  # 'п'
        7: 2,  # 'р'
        8: 2,  # 'с'
        5: 2,  # 'т'
        19: 1,  # 'у'
        29: 1,  # 'ф'
        25: 1,  # 'х'
        22: 2,  # 'ц'
        21: 3,  # 'ч'
        27: 1,  # 'ш'
        24: 1,  # 'щ'
        17: 1,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    16: {  # 'я'
        63: 0,  # 'e'
        45: 1,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 0,  # 'а'
        18: 3,  # 'б'
        9: 3,  # 'в'
        20: 2,  # 'г'
        11: 3,  # 'д'
        3: 2,  # 'е'
        23: 1,  # 'ж'
        15: 2,  # 'з'
        2: 1,  # 'и'
        26: 2,  # 'й'
        12: 3,  # 'к'
        10: 3,  # 'л'
        14: 3,  # 'м'
        6: 3,  # 'н'
        4: 1,  # 'о'
        13: 2,  # 'п'
        7: 2,  # 'р'
        8: 3,  # 'с'
        5: 3,  # 'т'
        19: 1,  # 'у'
        29: 1,  # 'ф'
        25: 3,  # 'х'
        22: 2,  # 'ц'
        21: 1,  # 'ч'
        27: 1,  # 'ш'
        24: 2,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 1,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    58: {  # 'є'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 0,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 0,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 0,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 0,  # 'о'
        13: 0,  # 'п'
        7: 0,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 0,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
    62: {  # '№'
        63: 0,  # 'e'
        45: 0,  # '\xad'
        31: 0,  # 'А'
        32: 0,  # 'Б'
        35: 0,  # 'В'
        43: 0,  # 'Г'
        37: 0,  # 'Д'
        44: 0,  # 'Е'
        55: 0,  # 'Ж'
        47: 0,  # 'З'
        40: 0,  # 'И'
        59: 0,  # 'Й'
        33: 0,  # 'К'
        46: 0,  # 'Л'
        38: 0,  # 'М'
        36: 0,  # 'Н'
        41: 0,  # 'О'
        30: 0,  # 'П'
        39: 0,  # 'Р'
        28: 0,  # 'С'
        34: 0,  # 'Т'
        51: 0,  # 'У'
        48: 0,  # 'Ф'
        49: 0,  # 'Х'
        53: 0,  # 'Ц'
        50: 0,  # 'Ч'
        54: 0,  # 'Ш'
        57: 0,  # 'Щ'
        61: 0,  # 'Ъ'
        60: 0,  # 'Ю'
        56: 0,  # 'Я'
        1: 0,  # 'а'
        18: 0,  # 'б'
        9: 0,  # 'в'
        20: 0,  # 'г'
        11: 0,  # 'д'
        3: 0,  # 'е'
        23: 0,  # 'ж'
        15: 0,  # 'з'
        2: 0,  # 'и'
        26: 0,  # 'й'
        12: 0,  # 'к'
        10: 0,  # 'л'
        14: 0,  # 'м'
        6: 0,  # 'н'
        4: 0,  # 'о'
        13: 0,  # 'п'
        7: 0,  # 'р'
        8: 0,  # 'с'
        5: 0,  # 'т'
        19: 0,  # 'у'
        29: 0,  # 'ф'
        25: 0,  # 'х'
        22: 0,  # 'ц'
        21: 0,  # 'ч'
        27: 0,  # 'ш'
        24: 0,  # 'щ'
        17: 0,  # 'ъ'
        52: 0,  # 'ь'
        42: 0,  # 'ю'
        16: 0,  # 'я'
        58: 0,  # 'є'
        62: 0,  # '№'
    },
}

# 255: Undefined characters that did not exist in training text
# 254: Carriage/Return
# 253: symbol (punctuation) that does not belong to word
# 252: 0 - 9
# 251: Control characters

# Character Mapping Table(s):
ISO_8859_5_BULGARIAN_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 77,  # 'A'
     66: 90,  # 'B'
     67: 99,  # 'C'
     68: 100,  # 'D'
     69: 72,  # 'E'
     70: 109,  # 'F'
     71: 107,  # 'G'
     72: 101,  # 'H'
     73: 79,  # 'I'
     74: 185,  # 'J'
     75: 81,  # 'K'
     76: 102,  # 'L'
     77: 76,  # 'M'
     78: 94,  # 'N'
     79: 82,  # 'O'
     80: 110,  # 'P'
     81: 186,  # 'Q'
     82: 108,  # 'R'
     83: 91,  # 'S'
     84: 74,  # 'T'
     85: 119,  # 'U'
     86: 84,  # 'V'
     87: 96,  # 'W'
     88: 111,  # 'X'
     89: 187,  # 'Y'
     90: 115,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 65,  # 'a'
     98: 69,  # 'b'
     99: 70,  # 'c'
     100: 66,  # 'd'
     101: 63,  # 'e'
     102: 68,  # 'f'
     103: 112,  # 'g'
     104: 103,  # 'h'
     105: 92,  # 'i'
     106: 194,  # 'j'
     107: 104,  # 'k'
     108: 95,  # 'l'
     109: 86,  # 'm'
     110: 87,  # 'n'
     111: 71,  # 'o'
     112: 116,  # 'p'
     113: 195,  # 'q'
     114: 85,  # 'r'
     115: 93,  # 's'
     116: 97,  # 't'
     117: 113,  # 'u'
     118: 196,  # 'v'
     119: 197,  # 'w'
     120: 198,  # 'x'
     121: 199,  # 'y'
     122: 200,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 194,  # '\x80'
     129: 195,  # '\x81'
     130: 196,  # '\x82'
     131: 197,  # '\x83'
     132: 198,  # '\x84'
     133: 199,  # '\x85'
     134: 200,  # '\x86'
     135: 201,  # '\x87'
     136: 202,  # '\x88'
     137: 203,  # '\x89'
     138: 204,  # '\x8a'
     139: 205,  # '\x8b'
     140: 206,  # '\x8c'
     141: 207,  # '\x8d'
     142: 208,  # '\x8e'
     143: 209,  # '\x8f'
     144: 210,  # '\x90'
     145: 211,  # '\x91'
     146: 212,  # '\x92'
     147: 213,  # '\x93'
     148: 214,  # '\x94'
     149: 215,  # '\x95'
     150: 216,  # '\x96'
     151: 217,  # '\x97'
     152: 218,  # '\x98'
     153: 219,  # '\x99'
     154: 220,  # '\x9a'
     155: 221,  # '\x9b'
     156: 222,  # '\x9c'
     157: 223,  # '\x9d'
     158: 224,  # '\x9e'
     159: 225,  # '\x9f'
     160: 81,  # '\xa0'
     161: 226,  # 'Ё'
     162: 227,  # 'Ђ'
     163: 228,  # 'Ѓ'
     164: 229,  # 'Є'
     165: 230,  # 'Ѕ'
     166: 105,  # 'І'
     167: 231,  # 'Ї'
     168: 232,  # 'Ј'
     169: 233,  # 'Љ'
     170: 234,  # 'Њ'
     171: 235,  # 'Ћ'
     172: 236,  # 'Ќ'
     173: 45,  # '\xad'
     174: 237,  # 'Ў'
     175: 238,  # 'Џ'
     176: 31,  # 'А'
     177: 32,  # 'Б'
     178: 35,  # 'В'
     179: 43,  # 'Г'
     180: 37,  # 'Д'
     181: 44,  # 'Е'
     182: 55,  # 'Ж'
     183: 47,  # 'З'
     184: 40,  # 'И'
     185: 59,  # 'Й'
     186: 33,  # 'К'
     187: 46,  # 'Л'
     188: 38,  # 'М'
     189: 36,  # 'Н'
     190: 41,  # 'О'
     191: 30,  # 'П'
     192: 39,  # 'Р'
     193: 28,  # 'С'
     194: 34,  # 'Т'
     195: 51,  # 'У'
     196: 48,  # 'Ф'
     197: 49,  # 'Х'
     198: 53,  # 'Ц'
     199: 50,  # 'Ч'
     200: 54,  # 'Ш'
     201: 57,  # 'Щ'
     202: 61,  # 'Ъ'
     203: 239,  # 'Ы'
     204: 67,  # 'Ь'
     205: 240,  # 'Э'
     206: 60,  # 'Ю'
     207: 56,  # 'Я'
     208: 1,  # 'а'
     209: 18,  # 'б'
     210: 9,  # 'в'
     211: 20,  # 'г'
     212: 11,  # 'д'
     213: 3,  # 'е'
     214: 23,  # 'ж'
     215: 15,  # 'з'
     216: 2,  # 'и'
     217: 26,  # 'й'
     218: 12,  # 'к'
     219: 10,  # 'л'
     220: 14,  # 'м'
     221: 6,  # 'н'
     222: 4,  # 'о'
     223: 13,  # 'п'
     224: 7,  # 'р'
     225: 8,  # 'с'
     226: 5,  # 'т'
     227: 19,  # 'у'
     228: 29,  # 'ф'
     229: 25,  # 'х'
     230: 22,  # 'ц'
     231: 21,  # 'ч'
     232: 27,  # 'ш'
     233: 24,  # 'щ'
     234: 17,  # 'ъ'
     235: 75,  # 'ы'
     236: 52,  # 'ь'
     237: 241,  # 'э'
     238: 42,  # 'ю'
     239: 16,  # 'я'
     240: 62,  # '№'
     241: 242,  # 'ё'
     242: 243,  # 'ђ'
     243: 244,  # 'ѓ'
     244: 58,  # 'є'
     245: 245,  # 'ѕ'
     246: 98,  # 'і'
     247: 246,  # 'ї'
     248: 247,  # 'ј'
     249: 248,  # 'љ'
     250: 249,  # 'њ'
     251: 250,  # 'ћ'
     252: 251,  # 'ќ'
     253: 91,  # '§'
     254: 252,  # 'ў'
     255: 253,  # 'џ'
}

ISO_8859_5_BULGARIAN_MODEL = SingleByteCharSetModel(charset_name='ISO-8859-5',
                                                    language='Bulgarian',
                                                    char_to_order_map=ISO_8859_5_BULGARIAN_CHAR_TO_ORDER,
                                                    language_model=BULGARIAN_LANG_MODEL,
                                                    typical_positive_ratio=0.969392,
                                                    keep_ascii_letters=False,
                                                    alphabet='АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЬЮЯабвгдежзийклмнопрстуфхцчшщъьюя')

WINDOWS_1251_BULGARIAN_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 77,  # 'A'
     66: 90,  # 'B'
     67: 99,  # 'C'
     68: 100,  # 'D'
     69: 72,  # 'E'
     70: 109,  # 'F'
     71: 107,  # 'G'
     72: 101,  # 'H'
     73: 79,  # 'I'
     74: 185,  # 'J'
     75: 81,  # 'K'
     76: 102,  # 'L'
     77: 76,  # 'M'
     78: 94,  # 'N'
     79: 82,  # 'O'
     80: 110,  # 'P'
     81: 186,  # 'Q'
     82: 108,  # 'R'
     83: 91,  # 'S'
     84: 74,  # 'T'
     85: 119,  # 'U'
     86: 84,  # 'V'
     87: 96,  # 'W'
     88: 111,  # 'X'
     89: 187,  # 'Y'
     90: 115,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 65,  # 'a'
     98: 69,  # 'b'
     99: 70,  # 'c'
     100: 66,  # 'd'
     101: 63,  # 'e'
     102: 68,  # 'f'
     103: 112,  # 'g'
     104: 103,  # 'h'
     105: 92,  # 'i'
     106: 194,  # 'j'
     107: 104,  # 'k'
     108: 95,  # 'l'
     109: 86,  # 'm'
     110: 87,  # 'n'
     111: 71,  # 'o'
     112: 116,  # 'p'
     113: 195,  # 'q'
     114: 85,  # 'r'
     115: 93,  # 's'
     116: 97,  # 't'
     117: 113,  # 'u'
     118: 196,  # 'v'
     119: 197,  # 'w'
     120: 198,  # 'x'
     121: 199,  # 'y'
     122: 200,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 206,  # 'Ђ'
     129: 207,  # 'Ѓ'
     130: 208,  # '‚'
     131: 209,  # 'ѓ'
     132: 210,  # '„'
     133: 211,  # '…'
     134: 212,  # '†'
     135: 213,  # '‡'
     136: 120,  # '€'
     137: 214,  # '‰'
     138: 215,  # 'Љ'
     139: 216,  # '‹'
     140: 217,  # 'Њ'
     141: 218,  # 'Ќ'
     142: 219,  # 'Ћ'
     143: 220,  # 'Џ'
     144: 221,  # 'ђ'
     145: 78,  # '‘'
     146: 64,  # '’'
     147: 83,  # '“'
     148: 121,  # '”'
     149: 98,  # '•'
     150: 117,  # '–'
     151: 105,  # '—'
     152: 222,  # None
     153: 223,  # '™'
     154: 224,  # 'љ'
     155: 225,  # '›'
     156: 226,  # 'њ'
     157: 227,  # 'ќ'
     158: 228,  # 'ћ'
     159: 229,  # 'џ'
     160: 88,  # '\xa0'
     161: 230,  # 'Ў'
     162: 231,  # 'ў'
     163: 232,  # 'Ј'
     164: 233,  # '¤'
     165: 122,  # 'Ґ'
     166: 89,  # '¦'
     167: 106,  # '§'
     168: 234,  # 'Ё'
     169: 235,  # '©'
     170: 236,  # 'Є'
     171: 237,  # '«'
     172: 238,  # '¬'
     173: 45,  # '\xad'
     174: 239,  # '®'
     175: 240,  # 'Ї'
     176: 73,  # '°'
     177: 80,  # '±'
     178: 118,  # 'І'
     179: 114,  # 'і'
     180: 241,  # 'ґ'
     181: 242,  # 'µ'
     182: 243,  # '¶'
     183: 244,  # '·'
     184: 245,  # 'ё'
     185: 62,  # '№'
     186: 58,  # 'є'
     187: 246,  # '»'
     188: 247,  # 'ј'
     189: 248,  # 'Ѕ'
     190: 249,  # 'ѕ'
     191: 250,  # 'ї'
     192: 31,  # 'А'
     193: 32,  # 'Б'
     194: 35,  # 'В'
     195: 43,  # 'Г'
     196: 37,  # 'Д'
     197: 44,  # 'Е'
     198: 55,  # 'Ж'
     199: 47,  # 'З'
     200: 40,  # 'И'
     201: 59,  # 'Й'
     202: 33,  # 'К'
     203: 46,  # 'Л'
     204: 38,  # 'М'
     205: 36,  # 'Н'
     206: 41,  # 'О'
     207: 30,  # 'П'
     208: 39,  # 'Р'
     209: 28,  # 'С'
     210: 34,  # 'Т'
     211: 51,  # 'У'
     212: 48,  # 'Ф'
     213: 49,  # 'Х'
     214: 53,  # 'Ц'
     215: 50,  # 'Ч'
     216: 54,  # 'Ш'
     217: 57,  # 'Щ'
     218: 61,  # 'Ъ'
     219: 251,  # 'Ы'
     220: 67,  # 'Ь'
     221: 252,  # 'Э'
     222: 60,  # 'Ю'
     223: 56,  # 'Я'
     224: 1,  # 'а'
     225: 18,  # 'б'
     226: 9,  # 'в'
     227: 20,  # 'г'
     228: 11,  # 'д'
     229: 3,  # 'е'
     230: 23,  # 'ж'
     231: 15,  # 'з'
     232: 2,  # 'и'
     233: 26,  # 'й'
     234: 12,  # 'к'
     235: 10,  # 'л'
     236: 14,  # 'м'
     237: 6,  # 'н'
     238: 4,  # 'о'
     239: 13,  # 'п'
     240: 7,  # 'р'
     241: 8,  # 'с'
     242: 5,  # 'т'
     243: 19,  # 'у'
     244: 29,  # 'ф'
     245: 25,  # 'х'
     246: 22,  # 'ц'
     247: 21,  # 'ч'
     248: 27,  # 'ш'
     249: 24,  # 'щ'
     250: 17,  # 'ъ'
     251: 75,  # 'ы'
     252: 52,  # 'ь'
     253: 253,  # 'э'
     254: 42,  # 'ю'
     255: 16,  # 'я'
}

WINDOWS_1251_BULGARIAN_MODEL = SingleByteCharSetModel(charset_name='windows-1251',
                                                      language='Bulgarian',
                                                      char_to_order_map=WINDOWS_1251_BULGARIAN_CHAR_TO_ORDER,
                                                      language_model=BULGARIAN_LANG_MODEL,
                                                      typical_positive_ratio=0.969392,
                                                      keep_ascii_letters=False,
                                                      alphabet='АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЬЮЯабвгдежзийклмнопрстуфхцчшщъьюя')

