# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421

from .verify_configuration import VerifyConfiguration
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JenkinsPipelineConfiguration(VerifyConfiguration):
    """
    Extends a Verify configuration with appropriate data to reach and use the build service provided by a Jenkins Pipeline.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JenkinsPipelineConfiguration object with values from keyword arguments. The default value of the :py:attr:`~oci.adm.models.JenkinsPipelineConfiguration.build_service_type` attribute
        of this class is ``JENKINS_PIPELINE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param build_service_type:
            The value to assign to the build_service_type property of this JenkinsPipelineConfiguration.
            Allowed values for this property are: "OCI_DEVOPS_BUILD", "GITLAB_PIPELINE", "GITHUB_ACTIONS", "JENKINS_PIPELINE", "NONE"
        :type build_service_type: str

        :param username:
            The value to assign to the username property of this JenkinsPipelineConfiguration.
        :type username: str

        :param pat_secret_id:
            The value to assign to the pat_secret_id property of this JenkinsPipelineConfiguration.
        :type pat_secret_id: str

        :param jenkins_url:
            The value to assign to the jenkins_url property of this JenkinsPipelineConfiguration.
        :type jenkins_url: str

        :param job_name:
            The value to assign to the job_name property of this JenkinsPipelineConfiguration.
        :type job_name: str

        :param additional_parameters:
            The value to assign to the additional_parameters property of this JenkinsPipelineConfiguration.
        :type additional_parameters: dict(str, str)

        """
        self.swagger_types = {
            'build_service_type': 'str',
            'username': 'str',
            'pat_secret_id': 'str',
            'jenkins_url': 'str',
            'job_name': 'str',
            'additional_parameters': 'dict(str, str)'
        }
        self.attribute_map = {
            'build_service_type': 'buildServiceType',
            'username': 'username',
            'pat_secret_id': 'patSecretId',
            'jenkins_url': 'jenkinsUrl',
            'job_name': 'jobName',
            'additional_parameters': 'additionalParameters'
        }
        self._build_service_type = None
        self._username = None
        self._pat_secret_id = None
        self._jenkins_url = None
        self._job_name = None
        self._additional_parameters = None
        self._build_service_type = 'JENKINS_PIPELINE'

    @property
    def username(self):
        """
        **[Required]** Gets the username of this JenkinsPipelineConfiguration.
        The username that will be used to authenticate with Jenkins.


        :return: The username of this JenkinsPipelineConfiguration.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this JenkinsPipelineConfiguration.
        The username that will be used to authenticate with Jenkins.


        :param username: The username of this JenkinsPipelineConfiguration.
        :type: str
        """
        self._username = username

    @property
    def pat_secret_id(self):
        """
        **[Required]** Gets the pat_secret_id of this JenkinsPipelineConfiguration.
        The Oracle Cloud Identifier (`OCID`__) of the Private Access Token (PAT) Secret.
        The PAT provides the credentials to access the Jenkins Pipeline.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The pat_secret_id of this JenkinsPipelineConfiguration.
        :rtype: str
        """
        return self._pat_secret_id

    @pat_secret_id.setter
    def pat_secret_id(self, pat_secret_id):
        """
        Sets the pat_secret_id of this JenkinsPipelineConfiguration.
        The Oracle Cloud Identifier (`OCID`__) of the Private Access Token (PAT) Secret.
        The PAT provides the credentials to access the Jenkins Pipeline.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param pat_secret_id: The pat_secret_id of this JenkinsPipelineConfiguration.
        :type: str
        """
        self._pat_secret_id = pat_secret_id

    @property
    def jenkins_url(self):
        """
        **[Required]** Gets the jenkins_url of this JenkinsPipelineConfiguration.
        The URL that locates the Jenkins pipeline.


        :return: The jenkins_url of this JenkinsPipelineConfiguration.
        :rtype: str
        """
        return self._jenkins_url

    @jenkins_url.setter
    def jenkins_url(self, jenkins_url):
        """
        Sets the jenkins_url of this JenkinsPipelineConfiguration.
        The URL that locates the Jenkins pipeline.


        :param jenkins_url: The jenkins_url of this JenkinsPipelineConfiguration.
        :type: str
        """
        self._jenkins_url = jenkins_url

    @property
    def job_name(self):
        """
        **[Required]** Gets the job_name of this JenkinsPipelineConfiguration.
        The name of the Jenkins pipeline job that identifies the build pipeline.


        :return: The job_name of this JenkinsPipelineConfiguration.
        :rtype: str
        """
        return self._job_name

    @job_name.setter
    def job_name(self, job_name):
        """
        Sets the job_name of this JenkinsPipelineConfiguration.
        The name of the Jenkins pipeline job that identifies the build pipeline.


        :param job_name: The job_name of this JenkinsPipelineConfiguration.
        :type: str
        """
        self._job_name = job_name

    @property
    def additional_parameters(self):
        """
        Gets the additional_parameters of this JenkinsPipelineConfiguration.
        Additional key-value pairs passed as parameters to the build service when running an experiment.


        :return: The additional_parameters of this JenkinsPipelineConfiguration.
        :rtype: dict(str, str)
        """
        return self._additional_parameters

    @additional_parameters.setter
    def additional_parameters(self, additional_parameters):
        """
        Sets the additional_parameters of this JenkinsPipelineConfiguration.
        Additional key-value pairs passed as parameters to the build service when running an experiment.


        :param additional_parameters: The additional_parameters of this JenkinsPipelineConfiguration.
        :type: dict(str, str)
        """
        self._additional_parameters = additional_parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
