# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VoiceSummary(object):
    """
    Details related to the voice available for the given language code and voice type.
    """

    #: A constant which can be used with the gender property of a VoiceSummary.
    #: This constant has a value of "MALE"
    GENDER_MALE = "MALE"

    #: A constant which can be used with the gender property of a VoiceSummary.
    #: This constant has a value of "FEMALE"
    GENDER_FEMALE = "FEMALE"

    def __init__(self, **kwargs):
        """
        Initializes a new VoiceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param voice_id:
            The value to assign to the voice_id property of this VoiceSummary.
        :type voice_id: str

        :param display_name:
            The value to assign to the display_name property of this VoiceSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this VoiceSummary.
        :type description: str

        :param gender:
            The value to assign to the gender property of this VoiceSummary.
            Allowed values for this property are: "MALE", "FEMALE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type gender: str

        :param supported_models:
            The value to assign to the supported_models property of this VoiceSummary.
        :type supported_models: list[str]

        :param language_code:
            The value to assign to the language_code property of this VoiceSummary.
        :type language_code: str

        :param language_description:
            The value to assign to the language_description property of this VoiceSummary.
        :type language_description: str

        :param sample_rate_in_hertz:
            The value to assign to the sample_rate_in_hertz property of this VoiceSummary.
        :type sample_rate_in_hertz: int

        :param words_per_minute:
            The value to assign to the words_per_minute property of this VoiceSummary.
        :type words_per_minute: int

        :param is_default_voice:
            The value to assign to the is_default_voice property of this VoiceSummary.
        :type is_default_voice: bool

        """
        self.swagger_types = {
            'voice_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'gender': 'str',
            'supported_models': 'list[str]',
            'language_code': 'str',
            'language_description': 'str',
            'sample_rate_in_hertz': 'int',
            'words_per_minute': 'int',
            'is_default_voice': 'bool'
        }
        self.attribute_map = {
            'voice_id': 'voiceId',
            'display_name': 'displayName',
            'description': 'description',
            'gender': 'gender',
            'supported_models': 'supportedModels',
            'language_code': 'languageCode',
            'language_description': 'languageDescription',
            'sample_rate_in_hertz': 'sampleRateInHertz',
            'words_per_minute': 'wordsPerMinute',
            'is_default_voice': 'isDefaultVoice'
        }
        self._voice_id = None
        self._display_name = None
        self._description = None
        self._gender = None
        self._supported_models = None
        self._language_code = None
        self._language_description = None
        self._sample_rate_in_hertz = None
        self._words_per_minute = None
        self._is_default_voice = None

    @property
    def voice_id(self):
        """
        **[Required]** Gets the voice_id of this VoiceSummary.
        Unique Id of the voice.


        :return: The voice_id of this VoiceSummary.
        :rtype: str
        """
        return self._voice_id

    @voice_id.setter
    def voice_id(self, voice_id):
        """
        Sets the voice_id of this VoiceSummary.
        Unique Id of the voice.


        :param voice_id: The voice_id of this VoiceSummary.
        :type: str
        """
        self._voice_id = voice_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this VoiceSummary.
        A user-friendly display name of the language for the user.


        :return: The display_name of this VoiceSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this VoiceSummary.
        A user-friendly display name of the language for the user.


        :param display_name: The display_name of this VoiceSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this VoiceSummary.
        A small description of the voice like its language and voice type.


        :return: The description of this VoiceSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VoiceSummary.
        A small description of the voice like its language and voice type.


        :param description: The description of this VoiceSummary.
        :type: str
        """
        self._description = description

    @property
    def gender(self):
        """
        **[Required]** Gets the gender of this VoiceSummary.
        Gender of the speaker.

        Allowed values for this property are: "MALE", "FEMALE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The gender of this VoiceSummary.
        :rtype: str
        """
        return self._gender

    @gender.setter
    def gender(self, gender):
        """
        Sets the gender of this VoiceSummary.
        Gender of the speaker.


        :param gender: The gender of this VoiceSummary.
        :type: str
        """
        allowed_values = ["MALE", "FEMALE"]
        if not value_allowed_none_or_none_sentinel(gender, allowed_values):
            gender = 'UNKNOWN_ENUM_VALUE'
        self._gender = gender

    @property
    def supported_models(self):
        """
        Gets the supported_models of this VoiceSummary.
        Models the particular speaker is aligned to.


        :return: The supported_models of this VoiceSummary.
        :rtype: list[str]
        """
        return self._supported_models

    @supported_models.setter
    def supported_models(self, supported_models):
        """
        Sets the supported_models of this VoiceSummary.
        Models the particular speaker is aligned to.


        :param supported_models: The supported_models of this VoiceSummary.
        :type: list[str]
        """
        self._supported_models = supported_models

    @property
    def language_code(self):
        """
        Gets the language_code of this VoiceSummary.
        An abbreviated notation of region to which the language and accent of the speaker belongs to.


        :return: The language_code of this VoiceSummary.
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code):
        """
        Sets the language_code of this VoiceSummary.
        An abbreviated notation of region to which the language and accent of the speaker belongs to.


        :param language_code: The language_code of this VoiceSummary.
        :type: str
        """
        self._language_code = language_code

    @property
    def language_description(self):
        """
        Gets the language_description of this VoiceSummary.
        A description of region to which the language and accent of the speaker belongs to.


        :return: The language_description of this VoiceSummary.
        :rtype: str
        """
        return self._language_description

    @language_description.setter
    def language_description(self, language_description):
        """
        Sets the language_description of this VoiceSummary.
        A description of region to which the language and accent of the speaker belongs to.


        :param language_description: The language_description of this VoiceSummary.
        :type: str
        """
        self._language_description = language_description

    @property
    def sample_rate_in_hertz(self):
        """
        **[Required]** Gets the sample_rate_in_hertz of this VoiceSummary.
        The sample rate of the speaker in Hertz.


        :return: The sample_rate_in_hertz of this VoiceSummary.
        :rtype: int
        """
        return self._sample_rate_in_hertz

    @sample_rate_in_hertz.setter
    def sample_rate_in_hertz(self, sample_rate_in_hertz):
        """
        Sets the sample_rate_in_hertz of this VoiceSummary.
        The sample rate of the speaker in Hertz.


        :param sample_rate_in_hertz: The sample_rate_in_hertz of this VoiceSummary.
        :type: int
        """
        self._sample_rate_in_hertz = sample_rate_in_hertz

    @property
    def words_per_minute(self):
        """
        **[Required]** Gets the words_per_minute of this VoiceSummary.
        The number of words the speaker can narrate per minute. It signifies the speed of the speech produced by the speaker.


        :return: The words_per_minute of this VoiceSummary.
        :rtype: int
        """
        return self._words_per_minute

    @words_per_minute.setter
    def words_per_minute(self, words_per_minute):
        """
        Sets the words_per_minute of this VoiceSummary.
        The number of words the speaker can narrate per minute. It signifies the speed of the speech produced by the speaker.


        :param words_per_minute: The words_per_minute of this VoiceSummary.
        :type: int
        """
        self._words_per_minute = words_per_minute

    @property
    def is_default_voice(self):
        """
        Gets the is_default_voice of this VoiceSummary.
        Whether this voice id is default voice used for inference.


        :return: The is_default_voice of this VoiceSummary.
        :rtype: bool
        """
        return self._is_default_voice

    @is_default_voice.setter
    def is_default_voice(self, is_default_voice):
        """
        Sets the is_default_voice of this VoiceSummary.
        Whether this voice id is default voice used for inference.


        :param is_default_voice: The is_default_voice of this VoiceSummary.
        :type: bool
        """
        self._is_default_voice = is_default_voice

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
