# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OccHandoverResourceBlockSummary(object):
    """
    Details about the association of capacity requests with the corresponding resources handed over by oracle.
    """

    #: A constant which can be used with the namespace property of a OccHandoverResourceBlockSummary.
    #: This constant has a value of "COMPUTE"
    NAMESPACE_COMPUTE = "COMPUTE"

    def __init__(self, **kwargs):
        """
        Initializes a new OccHandoverResourceBlockSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OccHandoverResourceBlockSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OccHandoverResourceBlockSummary.
        :type compartment_id: str

        :param namespace:
            The value to assign to the namespace property of this OccHandoverResourceBlockSummary.
            Allowed values for this property are: "COMPUTE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type namespace: str

        :param occ_customer_group_id:
            The value to assign to the occ_customer_group_id property of this OccHandoverResourceBlockSummary.
        :type occ_customer_group_id: str

        :param handover_date:
            The value to assign to the handover_date property of this OccHandoverResourceBlockSummary.
        :type handover_date: datetime

        :param handover_resource_name:
            The value to assign to the handover_resource_name property of this OccHandoverResourceBlockSummary.
        :type handover_resource_name: str

        :param total_handover_quantity:
            The value to assign to the total_handover_quantity property of this OccHandoverResourceBlockSummary.
        :type total_handover_quantity: int

        :param associated_capacity_requests:
            The value to assign to the associated_capacity_requests property of this OccHandoverResourceBlockSummary.
        :type associated_capacity_requests: list[oci.capacity_management.models.AssociatedCapacityRequestDetails]

        :param placement_details:
            The value to assign to the placement_details property of this OccHandoverResourceBlockSummary.
        :type placement_details: oci.capacity_management.models.PlacementDetails

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'namespace': 'str',
            'occ_customer_group_id': 'str',
            'handover_date': 'datetime',
            'handover_resource_name': 'str',
            'total_handover_quantity': 'int',
            'associated_capacity_requests': 'list[AssociatedCapacityRequestDetails]',
            'placement_details': 'PlacementDetails'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'namespace': 'namespace',
            'occ_customer_group_id': 'occCustomerGroupId',
            'handover_date': 'handoverDate',
            'handover_resource_name': 'handoverResourceName',
            'total_handover_quantity': 'totalHandoverQuantity',
            'associated_capacity_requests': 'associatedCapacityRequests',
            'placement_details': 'placementDetails'
        }
        self._id = None
        self._compartment_id = None
        self._namespace = None
        self._occ_customer_group_id = None
        self._handover_date = None
        self._handover_resource_name = None
        self._total_handover_quantity = None
        self._associated_capacity_requests = None
        self._placement_details = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OccHandoverResourceBlockSummary.
        The OCID of the resource block.


        :return: The id of this OccHandoverResourceBlockSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OccHandoverResourceBlockSummary.
        The OCID of the resource block.


        :param id: The id of this OccHandoverResourceBlockSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this OccHandoverResourceBlockSummary.
        The OCID of the compartment where the resource block's are placed.


        :return: The compartment_id of this OccHandoverResourceBlockSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OccHandoverResourceBlockSummary.
        The OCID of the compartment where the resource block's are placed.


        :param compartment_id: The compartment_id of this OccHandoverResourceBlockSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this OccHandoverResourceBlockSummary.
        The name of the OCI service in consideration.
        For example Compute, Exadata and so on.

        Allowed values for this property are: "COMPUTE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The namespace of this OccHandoverResourceBlockSummary.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this OccHandoverResourceBlockSummary.
        The name of the OCI service in consideration.
        For example Compute, Exadata and so on.


        :param namespace: The namespace of this OccHandoverResourceBlockSummary.
        :type: str
        """
        allowed_values = ["COMPUTE"]
        if not value_allowed_none_or_none_sentinel(namespace, allowed_values):
            namespace = 'UNKNOWN_ENUM_VALUE'
        self._namespace = namespace

    @property
    def occ_customer_group_id(self):
        """
        **[Required]** Gets the occ_customer_group_id of this OccHandoverResourceBlockSummary.
        The OCID of the customer group for which the resources were provisioned.


        :return: The occ_customer_group_id of this OccHandoverResourceBlockSummary.
        :rtype: str
        """
        return self._occ_customer_group_id

    @occ_customer_group_id.setter
    def occ_customer_group_id(self, occ_customer_group_id):
        """
        Sets the occ_customer_group_id of this OccHandoverResourceBlockSummary.
        The OCID of the customer group for which the resources were provisioned.


        :param occ_customer_group_id: The occ_customer_group_id of this OccHandoverResourceBlockSummary.
        :type: str
        """
        self._occ_customer_group_id = occ_customer_group_id

    @property
    def handover_date(self):
        """
        **[Required]** Gets the handover_date of this OccHandoverResourceBlockSummary.
        The date on which the resource was handed over to the customer.


        :return: The handover_date of this OccHandoverResourceBlockSummary.
        :rtype: datetime
        """
        return self._handover_date

    @handover_date.setter
    def handover_date(self, handover_date):
        """
        Sets the handover_date of this OccHandoverResourceBlockSummary.
        The date on which the resource was handed over to the customer.


        :param handover_date: The handover_date of this OccHandoverResourceBlockSummary.
        :type: datetime
        """
        self._handover_date = handover_date

    @property
    def handover_resource_name(self):
        """
        **[Required]** Gets the handover_resource_name of this OccHandoverResourceBlockSummary.
        The name of the resource handed over by oracle.
        For instance for compute namespace this will be the name of the bare metal hardware resource.


        :return: The handover_resource_name of this OccHandoverResourceBlockSummary.
        :rtype: str
        """
        return self._handover_resource_name

    @handover_resource_name.setter
    def handover_resource_name(self, handover_resource_name):
        """
        Sets the handover_resource_name of this OccHandoverResourceBlockSummary.
        The name of the resource handed over by oracle.
        For instance for compute namespace this will be the name of the bare metal hardware resource.


        :param handover_resource_name: The handover_resource_name of this OccHandoverResourceBlockSummary.
        :type: str
        """
        self._handover_resource_name = handover_resource_name

    @property
    def total_handover_quantity(self):
        """
        **[Required]** Gets the total_handover_quantity of this OccHandoverResourceBlockSummary.
        The total quantity of the resource that was made available to the customer by Oracle.


        :return: The total_handover_quantity of this OccHandoverResourceBlockSummary.
        :rtype: int
        """
        return self._total_handover_quantity

    @total_handover_quantity.setter
    def total_handover_quantity(self, total_handover_quantity):
        """
        Sets the total_handover_quantity of this OccHandoverResourceBlockSummary.
        The total quantity of the resource that was made available to the customer by Oracle.


        :param total_handover_quantity: The total_handover_quantity of this OccHandoverResourceBlockSummary.
        :type: int
        """
        self._total_handover_quantity = total_handover_quantity

    @property
    def associated_capacity_requests(self):
        """
        **[Required]** Gets the associated_capacity_requests of this OccHandoverResourceBlockSummary.
        A list containing details about the capacity requests against which the resources were provisioned by oracle.


        :return: The associated_capacity_requests of this OccHandoverResourceBlockSummary.
        :rtype: list[oci.capacity_management.models.AssociatedCapacityRequestDetails]
        """
        return self._associated_capacity_requests

    @associated_capacity_requests.setter
    def associated_capacity_requests(self, associated_capacity_requests):
        """
        Sets the associated_capacity_requests of this OccHandoverResourceBlockSummary.
        A list containing details about the capacity requests against which the resources were provisioned by oracle.


        :param associated_capacity_requests: The associated_capacity_requests of this OccHandoverResourceBlockSummary.
        :type: list[oci.capacity_management.models.AssociatedCapacityRequestDetails]
        """
        self._associated_capacity_requests = associated_capacity_requests

    @property
    def placement_details(self):
        """
        **[Required]** Gets the placement_details of this OccHandoverResourceBlockSummary.

        :return: The placement_details of this OccHandoverResourceBlockSummary.
        :rtype: oci.capacity_management.models.PlacementDetails
        """
        return self._placement_details

    @placement_details.setter
    def placement_details(self, placement_details):
        """
        Sets the placement_details of this OccHandoverResourceBlockSummary.

        :param placement_details: The placement_details of this OccHandoverResourceBlockSummary.
        :type: oci.capacity_management.models.PlacementDetails
        """
        self._placement_details = placement_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
