# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181231

from __future__ import absolute_import

from oci._vendor import requests  # noqa: F401
from oci._vendor import six

from oci import retry, circuit_breaker  # noqa: F401
from oci.base_client import BaseClient
from oci.config import get_config_value_or_default, validate_config
from oci.signer import Signer
from oci.util import Sentinel, get_signer_from_authentication_type, AUTHENTICATION_TYPE_FIELD_NAME
from oci.util import back_up_body_calculate_stream_content_length, is_content_length_calculable_by_req_util
from oci.exceptions import InvalidAlloyConfig
from oci.alloy import OCI_SDK_ENABLED_SERVICES_SET
from .models import cims_type_mapping
missing = Sentinel("Missing")


class IncidentClient(object):
    """
    Use the Support Management API to manage support requests.
    For more information, see [Getting Help and Contacting Support](/iaas/Content/GSG/Tasks/contactingsupport.htm).
    **Note**: Before you can create service requests with this API,
    complete user registration at My Oracle Cloud Support
    and then ask your tenancy administrator to provide you authorization for the related user groups.
    """

    def __init__(self, config, **kwargs):
        """
        Creates a new service client

        :param dict config:
            Configuration keys and values as per `SDK and Tool Configuration <https://docs.cloud.oracle.com/Content/API/Concepts/sdkconfig.htm>`__.
            The :py:meth:`~oci.config.from_file` method can be used to load configuration from a file. Alternatively, a ``dict`` can be passed. You can validate_config
            the dict using :py:meth:`~oci.config.validate_config`

        :param str service_endpoint: (optional)
            The endpoint of the service to call using this client. For example ``https://iaas.us-ashburn-1.oraclecloud.com``. If this keyword argument is
            not provided then it will be derived using the region in the config parameter. You should only provide this keyword argument if you have an explicit
            need to specify a service endpoint.

        :param timeout: (optional)
            The connection and read timeouts for the client. The default values are connection timeout 10 seconds and read timeout 60 seconds. This keyword argument can be provided
            as a single float, in which case the value provided is used for both the read and connection timeouts, or as a tuple of two floats. If
            a tuple is provided then the first value is used as the connection timeout and the second value as the read timeout.
        :type timeout: float or tuple(float, float)

        :param signer: (optional)
            The signer to use when signing requests made by the service client. The default is to use a :py:class:`~oci.signer.Signer` based on the values
            provided in the config parameter.

            One use case for this parameter is for `Instance Principals authentication <https://docs.cloud.oracle.com/Content/Identity/Tasks/callingservicesfrominstances.htm>`__
            by passing an instance of :py:class:`~oci.auth.signers.InstancePrincipalsSecurityTokenSigner` as the value for this keyword argument
        :type signer: :py:class:`~oci.signer.AbstractBaseSigner`

        :param obj retry_strategy: (optional)
            A retry strategy to apply to all calls made by this service client (i.e. at the client level). There is no retry strategy applied by default.
            Retry strategies can also be applied at the operation level by passing a ``retry_strategy`` keyword argument as part of calling the operation.
            Any value provided at the operation level will override whatever is specified at the client level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. A convenience :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY`
            is also available. The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

        :param obj circuit_breaker_strategy: (optional)
            A circuit breaker strategy to apply to all calls made by this service client (i.e. at the client level).
            This client uses :py:data:`~oci.circuit_breaker.DEFAULT_CIRCUIT_BREAKER_STRATEGY` as default if no circuit breaker strategy is provided.
            The specifics of circuit breaker strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/circuit_breakers.html>`__.

        :param function circuit_breaker_callback: (optional)
            Callback function to receive any exceptions triggerred by the circuit breaker.

        :param bool client_level_realm_specific_endpoint_template_enabled: (optional)
            A boolean flag to indicate whether or not this client should be created with realm specific endpoint template enabled or disable. By default, this will be set as None.

        :param allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this client should allow control characters in the response object. By default, the client will not
            allow control characters to be in the response object.
        """
        if not OCI_SDK_ENABLED_SERVICES_SET.is_service_enabled("cims"):
            raise InvalidAlloyConfig("The Alloy configuration has disabled this service, this behavior is controlled by OCI_SDK_ENABLED_SERVICES_SET variable. Please check if your local alloy-config file configured the service you're targeting or contact the cloud provider on the availability of this service")

        validate_config(config, signer=kwargs.get('signer'))
        if 'signer' in kwargs:
            signer = kwargs['signer']

        elif AUTHENTICATION_TYPE_FIELD_NAME in config:
            signer = get_signer_from_authentication_type(config)

        else:
            signer = Signer(
                tenancy=config["tenancy"],
                user=config["user"],
                fingerprint=config["fingerprint"],
                private_key_file_location=config.get("key_file"),
                pass_phrase=get_config_value_or_default(config, "pass_phrase"),
                private_key_content=config.get("key_content")
            )

        base_client_init_kwargs = {
            'regional_client': True,
            'service_endpoint': kwargs.get('service_endpoint'),
            'base_path': '/20181231',
            'service_endpoint_template': 'https://incidentmanagement.{region}.oci.{secondLevelDomain}',
            'service_endpoint_template_per_realm': {  },  # noqa: E201 E202
            'service_uses_dualstack_endpoints_by_default': False,
            'skip_deserialization': kwargs.get('skip_deserialization', False),
            'circuit_breaker_strategy': kwargs.get('circuit_breaker_strategy', circuit_breaker.GLOBAL_CIRCUIT_BREAKER_STRATEGY),
            'client_level_realm_specific_endpoint_template_enabled': kwargs.get('client_level_realm_specific_endpoint_template_enabled'),
            'client_level_dualstack_endpoints_enabled': kwargs.get('client_level_dualstack_endpoints_enabled')
        }
        if 'timeout' in kwargs:
            base_client_init_kwargs['timeout'] = kwargs.get('timeout')
        if base_client_init_kwargs.get('circuit_breaker_strategy') is None:
            base_client_init_kwargs['circuit_breaker_strategy'] = circuit_breaker.DEFAULT_CIRCUIT_BREAKER_STRATEGY
        if 'allow_control_chars' in kwargs:
            base_client_init_kwargs['allow_control_chars'] = kwargs.get('allow_control_chars')
        self.base_client = BaseClient("incident", config, signer, cims_type_mapping, **base_client_init_kwargs)
        self.retry_strategy = kwargs.get('retry_strategy')
        self.circuit_breaker_callback = kwargs.get('circuit_breaker_callback')

    def create_incident(self, create_incident_details, **kwargs):
        """
        Creates a support request in the specified tenancy.
        For more information, see `Creating Support Requests`__.

        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/create-incident.htm


        :param oci.cims.models.CreateIncident create_incident_details: (required)
            Incident information

        :param str opc_request_id: (optional)
            Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.

        :param str ocid: (optional)
            User OCID for Oracle Identity Cloud Service (IDCS) users who also have a federated Oracle Cloud Infrastructure account.
            User OCID is mandatory for OCI Users and optional for Multicloud users.

        :param str homeregion: (optional)
            The region of the tenancy.

        :param str bearertokentype: (optional)
            Token type that determine which cloud provider the request come from.

        :param str bearertoken: (optional)
            Token that provided by multi cloud provider, which help to validate the email.

        :param str idtoken: (optional)
            IdToken that provided by multi cloud provider, which help to validate the email.

        :param str domainid: (optional)
            The OCID of identity domain.
            DomainID is mandatory if the user is part of Non Default Identity domain.

        :param obj retry_strategy: (optional)
            A retry strategy to apply to this specific operation/call. This will override any retry strategy set at the client-level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. This operation will not retry by default, users can also use the convenient :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY` provided by the SDK to enable retries for it.
            The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

            To have this operation explicitly not perform any retries, pass an instance of :py:class:`~oci.retry.NoneRetryStrategy`.

        :param bool allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this request should allow control characters in the response object.
            By default, the response will not allow control characters in strings

        :return: A :class:`~oci.response.Response` object with data of type :class:`~oci.cims.models.Incident`
        :rtype: :class:`~oci.response.Response`

        :example:
        Click `here <https://docs.cloud.oracle.com/en-us/iaas/tools/python-sdk-examples/2.164.0/cims/create_incident.py.html>`__ to see an example of how to use create_incident API.
        """
        # Required path and query arguments. These are in camelCase to replace values in service endpoints.
        required_arguments = []
        resource_path = "/v2/incidents"
        method = "POST"
        operation_name = "create_incident"
        api_reference_link = "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/Incident/CreateIncident"

        # Don't accept unknown kwargs
        expected_kwargs = [
            "allow_control_chars",
            "retry_strategy",
            "opc_request_id",
            "ocid",
            "homeregion",
            "bearertokentype",
            "bearertoken",
            "idtoken",
            "domainid"
        ]
        extra_kwargs = [_key for _key in six.iterkeys(kwargs) if _key not in expected_kwargs]
        if extra_kwargs:
            raise ValueError(
                f"create_incident got unknown kwargs: {extra_kwargs!r}")

        header_params = {
            "accept": "application/json",
            "content-type": "application/json",
            "opc-request-id": kwargs.get("opc_request_id", missing),
            "ocid": kwargs.get("ocid", missing),
            "homeregion": kwargs.get("homeregion", missing),
            "bearertokentype": kwargs.get("bearertokentype", missing),
            "bearertoken": kwargs.get("bearertoken", missing),
            "idtoken": kwargs.get("idtoken", missing),
            "domainid": kwargs.get("domainid", missing)
        }
        header_params = {k: v for (k, v) in six.iteritems(header_params) if v is not missing and v is not None}

        retry_strategy = self.base_client.get_preferred_retry_strategy(
            operation_retry_strategy=kwargs.get('retry_strategy'),
            client_retry_strategy=self.retry_strategy
        )

        if retry_strategy:
            if not isinstance(retry_strategy, retry.NoneRetryStrategy):
                self.base_client.add_opc_client_retries_header(header_params)
                retry_strategy.add_circuit_breaker_callback(self.circuit_breaker_callback)
            return retry_strategy.make_retrying_call(
                self.base_client.call_api,
                resource_path=resource_path,
                method=method,
                header_params=header_params,
                body=create_incident_details,
                response_type="Incident",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
        else:
            return self.base_client.call_api(
                resource_path=resource_path,
                method=method,
                header_params=header_params,
                body=create_incident_details,
                response_type="Incident",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)

    def get_incident(self, incident_key, compartment_id, **kwargs):
        """
        Gets the specified support request.
        For more information, see `Getting Details for a Support Request`__.

        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/get-incident.htm


        :param str incident_key: (required)
            Unique identifier for the support request.

        :param str compartment_id: (required)
            The OCID of the tenancy.

        :param str opc_request_id: (optional)
            Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.

        :param str csi: (optional)
            The Customer Support Identifier (CSI) number associated with the support account.
            The CSI is optional for all support request types.

        :param str ocid: (optional)
            User OCID for Oracle Identity Cloud Service (IDCS) users who also have a federated Oracle Cloud Infrastructure account.
            User OCID is mandatory for OCI Users and optional for Multicloud users.

        :param str homeregion: (optional)
            The region of the tenancy.

        :param str problemtype: (optional)
            The kind of support request.

        :param str bearertokentype: (optional)
            Token type that determine which cloud provider the request come from.

        :param str bearertoken: (optional)
            Token that provided by multi cloud provider, which help to validate the email.

        :param str idtoken: (optional)
            IdToken that provided by multi cloud provider, which help to validate the email.

        :param str domainid: (optional)
            The OCID of identity domain.
            DomainID is mandatory if the user is part of Non Default Identity domain.

        :param obj retry_strategy: (optional)
            A retry strategy to apply to this specific operation/call. This will override any retry strategy set at the client-level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. This operation will not retry by default, users can also use the convenient :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY` provided by the SDK to enable retries for it.
            The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

            To have this operation explicitly not perform any retries, pass an instance of :py:class:`~oci.retry.NoneRetryStrategy`.

        :param bool allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this request should allow control characters in the response object.
            By default, the response will not allow control characters in strings

        :return: A :class:`~oci.response.Response` object with data of type :class:`~oci.cims.models.Incident`
        :rtype: :class:`~oci.response.Response`

        :example:
        Click `here <https://docs.cloud.oracle.com/en-us/iaas/tools/python-sdk-examples/2.164.0/cims/get_incident.py.html>`__ to see an example of how to use get_incident API.
        """
        # Required path and query arguments. These are in camelCase to replace values in service endpoints.
        required_arguments = ['incidentKey', 'compartmentId']
        resource_path = "/v2/incidents/{incidentKey}"
        method = "GET"
        operation_name = "get_incident"
        api_reference_link = "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/Incident/GetIncident"

        # Don't accept unknown kwargs
        expected_kwargs = [
            "allow_control_chars",
            "retry_strategy",
            "opc_request_id",
            "csi",
            "ocid",
            "homeregion",
            "problemtype",
            "bearertokentype",
            "bearertoken",
            "idtoken",
            "domainid"
        ]
        extra_kwargs = [_key for _key in six.iterkeys(kwargs) if _key not in expected_kwargs]
        if extra_kwargs:
            raise ValueError(
                f"get_incident got unknown kwargs: {extra_kwargs!r}")

        path_params = {
            "incidentKey": incident_key
        }

        path_params = {k: v for (k, v) in six.iteritems(path_params) if v is not missing}

        for (k, v) in six.iteritems(path_params):
            if v is None or (isinstance(v, six.string_types) and len(v.strip()) == 0):
                raise ValueError(f'Parameter {k} cannot be None, whitespace or empty string')

        query_params = {
            "compartmentId": compartment_id
        }
        query_params = {k: v for (k, v) in six.iteritems(query_params) if v is not missing and v is not None}

        header_params = {
            "accept": "application/json",
            "content-type": "application/json",
            "opc-request-id": kwargs.get("opc_request_id", missing),
            "csi": kwargs.get("csi", missing),
            "ocid": kwargs.get("ocid", missing),
            "homeregion": kwargs.get("homeregion", missing),
            "problemtype": kwargs.get("problemtype", missing),
            "bearertokentype": kwargs.get("bearertokentype", missing),
            "bearertoken": kwargs.get("bearertoken", missing),
            "idtoken": kwargs.get("idtoken", missing),
            "domainid": kwargs.get("domainid", missing)
        }
        header_params = {k: v for (k, v) in six.iteritems(header_params) if v is not missing and v is not None}

        retry_strategy = self.base_client.get_preferred_retry_strategy(
            operation_retry_strategy=kwargs.get('retry_strategy'),
            client_retry_strategy=self.retry_strategy
        )

        if retry_strategy:
            if not isinstance(retry_strategy, retry.NoneRetryStrategy):
                self.base_client.add_opc_client_retries_header(header_params)
                retry_strategy.add_circuit_breaker_callback(self.circuit_breaker_callback)
            return retry_strategy.make_retrying_call(
                self.base_client.call_api,
                resource_path=resource_path,
                method=method,
                path_params=path_params,
                query_params=query_params,
                header_params=header_params,
                response_type="Incident",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
        else:
            return self.base_client.call_api(
                resource_path=resource_path,
                method=method,
                path_params=path_params,
                query_params=query_params,
                header_params=header_params,
                response_type="Incident",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)

    def list_incident_resource_types(self, problem_type, compartment_id, **kwargs):
        """
        Depending on the selected `productType`, either
        lists available products (service groups, services, service categories, and subcategories) for technical support requests or
        lists limits and current usage for limit increase tickets.
        This operation is called during creation of technical support and limit increase tickets.
        For more information about listing products, see
        `Listing Products for Support Requests`__.
        For more information about listing limits, see
        `Listing Limits for Service Limit Increase Requests`__.

        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/list-incident-resource-types-taxonomy.htm
        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/list-incident-resource-types-limit.htm


        :param str problem_type: (required)
            The kind of support request.

        :param str compartment_id: (required)
            The OCID of the tenancy.

        :param str opc_request_id: (optional)
            Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.

        :param int limit: (optional)
            For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see `List Pagination`__.

            __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine

        :param str page: (optional)
            For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see `List Pagination`__.

            __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine

        :param str sort_by: (optional)
            The key to use to sort the returned items.

            Allowed values are: "dateUpdated", "severity"

        :param str sort_order: (optional)
            The order to sort the results in.

            Allowed values are: "ASC", "DESC"

        :param str name: (optional)
            The user-friendly name of the support request type.

        :param str csi: (optional)
            The Customer Support Identifier (CSI) number associated with the support account.
            The CSI is optional for all support request types.

        :param str ocid: (optional)
            User OCID for Oracle Identity Cloud Service (IDCS) users who also have a federated Oracle Cloud Infrastructure account.
            User OCID is mandatory for OCI Users and optional for Multicloud users.

        :param str homeregion: (optional)
            The region of the tenancy.

        :param str domainid: (optional)
            The OCID of identity domain.
            DomainID is mandatory if the user is part of Non Default Identity domain.

        :param obj retry_strategy: (optional)
            A retry strategy to apply to this specific operation/call. This will override any retry strategy set at the client-level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. This operation will not retry by default, users can also use the convenient :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY` provided by the SDK to enable retries for it.
            The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

            To have this operation explicitly not perform any retries, pass an instance of :py:class:`~oci.retry.NoneRetryStrategy`.

        :param bool allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this request should allow control characters in the response object.
            By default, the response will not allow control characters in strings

        :return: A :class:`~oci.response.Response` object with data of type list of :class:`~oci.cims.models.IncidentResourceType`
        :rtype: :class:`~oci.response.Response`

        :example:
        Click `here <https://docs.cloud.oracle.com/en-us/iaas/tools/python-sdk-examples/2.164.0/cims/list_incident_resource_types.py.html>`__ to see an example of how to use list_incident_resource_types API.
        """
        # Required path and query arguments. These are in camelCase to replace values in service endpoints.
        required_arguments = ['problemType', 'compartmentId']
        resource_path = "/v2/incidents/incidentResourceTypes"
        method = "GET"
        operation_name = "list_incident_resource_types"
        api_reference_link = "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/IncidentResourceType/ListIncidentResourceTypes"

        # Don't accept unknown kwargs
        expected_kwargs = [
            "allow_control_chars",
            "retry_strategy",
            "opc_request_id",
            "limit",
            "page",
            "sort_by",
            "sort_order",
            "name",
            "csi",
            "ocid",
            "homeregion",
            "domainid"
        ]
        extra_kwargs = [_key for _key in six.iterkeys(kwargs) if _key not in expected_kwargs]
        if extra_kwargs:
            raise ValueError(
                f"list_incident_resource_types got unknown kwargs: {extra_kwargs!r}")

        if 'sort_by' in kwargs:
            sort_by_allowed_values = ["dateUpdated", "severity"]
            if kwargs['sort_by'] not in sort_by_allowed_values:
                raise ValueError(
                    f"Invalid value for `sort_by`, must be one of { sort_by_allowed_values }"
                )

        if 'sort_order' in kwargs:
            sort_order_allowed_values = ["ASC", "DESC"]
            if kwargs['sort_order'] not in sort_order_allowed_values:
                raise ValueError(
                    f"Invalid value for `sort_order`, must be one of { sort_order_allowed_values }"
                )

        query_params = {
            "problemType": problem_type,
            "limit": kwargs.get("limit", missing),
            "page": kwargs.get("page", missing),
            "sortBy": kwargs.get("sort_by", missing),
            "sortOrder": kwargs.get("sort_order", missing),
            "compartmentId": compartment_id,
            "name": kwargs.get("name", missing)
        }
        query_params = {k: v for (k, v) in six.iteritems(query_params) if v is not missing and v is not None}

        header_params = {
            "accept": "application/json",
            "content-type": "application/json",
            "opc-request-id": kwargs.get("opc_request_id", missing),
            "csi": kwargs.get("csi", missing),
            "ocid": kwargs.get("ocid", missing),
            "homeregion": kwargs.get("homeregion", missing),
            "domainid": kwargs.get("domainid", missing)
        }
        header_params = {k: v for (k, v) in six.iteritems(header_params) if v is not missing and v is not None}

        retry_strategy = self.base_client.get_preferred_retry_strategy(
            operation_retry_strategy=kwargs.get('retry_strategy'),
            client_retry_strategy=self.retry_strategy
        )

        if retry_strategy:
            if not isinstance(retry_strategy, retry.NoneRetryStrategy):
                self.base_client.add_opc_client_retries_header(header_params)
                retry_strategy.add_circuit_breaker_callback(self.circuit_breaker_callback)
            return retry_strategy.make_retrying_call(
                self.base_client.call_api,
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="list[IncidentResourceType]",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
        else:
            return self.base_client.call_api(
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="list[IncidentResourceType]",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)

    def list_incidents(self, compartment_id, **kwargs):
        """
        Lists support requests for the specified tenancy.
        For more information, see `Listing Support Requests`__.

        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/list-incidents.htm


        :param str compartment_id: (required)
            The OCID of the tenancy.

        :param str csi: (optional)
            The Customer Support Identifier (CSI) number associated with the support account.
            The CSI is optional for all support request types.

        :param int limit: (optional)
            For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see `List Pagination`__.

            __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine

        :param str sort_by: (optional)
            The key to use to sort the returned items.

            Allowed values are: "dateUpdated", "severity"

        :param str sort_order: (optional)
            The order to sort the results in.

            Allowed values are: "ASC", "DESC"

        :param str lifecycle_state: (optional)
            The current state of the ticket.

            Allowed values are: "ACTIVE", "CLOSED"

        :param str page: (optional)
            For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see `List Pagination`__.

            __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine

        :param str opc_request_id: (optional)
            Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.

        :param str ocid: (optional)
            User OCID for Oracle Identity Cloud Service (IDCS) users who also have a federated Oracle Cloud Infrastructure account.
            User OCID is mandatory for OCI Users and optional for Multicloud users.

        :param str homeregion: (optional)
            The region of the tenancy.

        :param str problem_type: (optional)
            The kind of support request.

        :param str bearertokentype: (optional)
            Token type that determine which cloud provider the request come from.

        :param str bearertoken: (optional)
            Token that provided by multi cloud provider, which help to validate the email.

        :param str idtoken: (optional)
            IdToken that provided by multi cloud provider, which help to validate the email.

        :param str domainid: (optional)
            The OCID of identity domain.
            DomainID is mandatory if the user is part of Non Default Identity domain.

        :param obj retry_strategy: (optional)
            A retry strategy to apply to this specific operation/call. This will override any retry strategy set at the client-level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. This operation will not retry by default, users can also use the convenient :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY` provided by the SDK to enable retries for it.
            The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

            To have this operation explicitly not perform any retries, pass an instance of :py:class:`~oci.retry.NoneRetryStrategy`.

        :param bool allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this request should allow control characters in the response object.
            By default, the response will not allow control characters in strings

        :return: A :class:`~oci.response.Response` object with data of type list of :class:`~oci.cims.models.IncidentSummary`
        :rtype: :class:`~oci.response.Response`

        :example:
        Click `here <https://docs.cloud.oracle.com/en-us/iaas/tools/python-sdk-examples/2.164.0/cims/list_incidents.py.html>`__ to see an example of how to use list_incidents API.
        """
        # Required path and query arguments. These are in camelCase to replace values in service endpoints.
        required_arguments = ['compartmentId']
        resource_path = "/v2/incidents"
        method = "GET"
        operation_name = "list_incidents"
        api_reference_link = "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/IncidentSummary/ListIncidents"

        # Don't accept unknown kwargs
        expected_kwargs = [
            "allow_control_chars",
            "retry_strategy",
            "csi",
            "limit",
            "sort_by",
            "sort_order",
            "lifecycle_state",
            "page",
            "opc_request_id",
            "ocid",
            "homeregion",
            "problem_type",
            "bearertokentype",
            "bearertoken",
            "idtoken",
            "domainid"
        ]
        extra_kwargs = [_key for _key in six.iterkeys(kwargs) if _key not in expected_kwargs]
        if extra_kwargs:
            raise ValueError(
                f"list_incidents got unknown kwargs: {extra_kwargs!r}")

        if 'sort_by' in kwargs:
            sort_by_allowed_values = ["dateUpdated", "severity"]
            if kwargs['sort_by'] not in sort_by_allowed_values:
                raise ValueError(
                    f"Invalid value for `sort_by`, must be one of { sort_by_allowed_values }"
                )

        if 'sort_order' in kwargs:
            sort_order_allowed_values = ["ASC", "DESC"]
            if kwargs['sort_order'] not in sort_order_allowed_values:
                raise ValueError(
                    f"Invalid value for `sort_order`, must be one of { sort_order_allowed_values }"
                )

        if 'lifecycle_state' in kwargs:
            lifecycle_state_allowed_values = ["ACTIVE", "CLOSED"]
            if kwargs['lifecycle_state'] not in lifecycle_state_allowed_values:
                raise ValueError(
                    f"Invalid value for `lifecycle_state`, must be one of { lifecycle_state_allowed_values }"
                )

        query_params = {
            "limit": kwargs.get("limit", missing),
            "compartmentId": compartment_id,
            "sortBy": kwargs.get("sort_by", missing),
            "sortOrder": kwargs.get("sort_order", missing),
            "lifecycleState": kwargs.get("lifecycle_state", missing),
            "page": kwargs.get("page", missing),
            "problemType": kwargs.get("problem_type", missing)
        }
        query_params = {k: v for (k, v) in six.iteritems(query_params) if v is not missing and v is not None}

        header_params = {
            "accept": "application/json",
            "content-type": "application/json",
            "csi": kwargs.get("csi", missing),
            "opc-request-id": kwargs.get("opc_request_id", missing),
            "ocid": kwargs.get("ocid", missing),
            "homeregion": kwargs.get("homeregion", missing),
            "bearertokentype": kwargs.get("bearertokentype", missing),
            "bearertoken": kwargs.get("bearertoken", missing),
            "idtoken": kwargs.get("idtoken", missing),
            "domainid": kwargs.get("domainid", missing)
        }
        header_params = {k: v for (k, v) in six.iteritems(header_params) if v is not missing and v is not None}

        retry_strategy = self.base_client.get_preferred_retry_strategy(
            operation_retry_strategy=kwargs.get('retry_strategy'),
            client_retry_strategy=self.retry_strategy
        )

        if retry_strategy:
            if not isinstance(retry_strategy, retry.NoneRetryStrategy):
                self.base_client.add_opc_client_retries_header(header_params)
                retry_strategy.add_circuit_breaker_callback(self.circuit_breaker_callback)
            return retry_strategy.make_retrying_call(
                self.base_client.call_api,
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="list[IncidentSummary]",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
        else:
            return self.base_client.call_api(
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="list[IncidentSummary]",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)

    def put_attachment(self, put_attachment_details, incident_key, attachment_name, compartment_id, is_restricted_flag, **kwargs):
        """
        Uploads the file and attaches it to the support request.


        :param stream put_attachment_details: (required)
            File to be uploaded as attachment to the Service Request.

        :param str incident_key: (required)
            Unique identifier for the support request.

        :param str attachment_name: (required)
            The name of the file to attach to the support request. Avoid entering confidential information.

        :param str compartment_id: (required)
            The OCID of the tenancy.

        :param bool is_restricted_flag: (required)
            Set to `true` when the attachment contains personal information (PI)
            or protected health information (PHI).

        :param str csi: (optional)
            The Customer Support Identifier (CSI) number associated with the support account.
            The CSI is optional for all support request types.

        :param str opc_request_id: (optional)
            Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.

        :param str ocid: (optional)
            User OCID for Oracle Identity Cloud Service (IDCS) users who also have a federated Oracle Cloud Infrastructure account.
            User OCID is mandatory for OCI Users and optional for Multicloud users.

        :param str if_match: (optional)
            For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.

        :param str homeregion: (optional)
            The region of the tenancy.

        :param str problemtype: (optional)
            The kind of support request.

        :param str bearertokentype: (optional)
            Token type that determine which cloud provider the request come from.

        :param str bearertoken: (optional)
            Token that provided by multi cloud provider, which help to validate the email.

        :param str idtoken: (optional)
            IdToken that provided by multi cloud provider, which help to validate the email.

        :param str domainid: (optional)
            The OCID of identity domain.
            DomainID is mandatory if the user is part of Non Default Identity domain.

        :param obj retry_strategy: (optional)
            A retry strategy to apply to this specific operation/call. This will override any retry strategy set at the client-level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. This operation will not retry by default, users can also use the convenient :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY` provided by the SDK to enable retries for it.
            The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

            To have this operation explicitly not perform any retries, pass an instance of :py:class:`~oci.retry.NoneRetryStrategy`.

        :param bool allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this request should allow control characters in the response object.
            By default, the response will not allow control characters in strings
        :param int buffer_limit: (optional)
            A buffer limit for the stream to be buffered. buffer_limit is used to set the buffer size capacity. Streams will be read until the size of the buffer reaches the buffer_limit.
            If the stream size is greater than the buffer_limit, a BufferError exception will be thrown.

            The buffer_limit parameter is used when the stream object does not have a `seek`, `tell`, or `fileno` property for the Python Request library to calculate out the content length.
            If buffer_limit is not passed, then the buffer_limit will be defaulted to 100MB.
            Large streams can cause the process to freeze, consider passing in content-length for large streams instead.

        :return: A :class:`~oci.response.Response` object with data of type :class:`~oci.cims.models.Incident`
        :rtype: :class:`~oci.response.Response`

        :example:
        Click `here <https://docs.cloud.oracle.com/en-us/iaas/tools/python-sdk-examples/2.164.0/cims/put_attachment.py.html>`__ to see an example of how to use put_attachment API.
        """
        # Required path and query arguments. These are in camelCase to replace values in service endpoints.
        required_arguments = ['incidentKey', 'attachmentName', 'compartmentId', 'isRestrictedFlag']
        resource_path = "/v2/incidents/{incidentKey}/attachment"
        method = "PUT"
        operation_name = "put_attachment"
        api_reference_link = "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/Incident/PutAttachment"

        # Don't accept unknown kwargs
        expected_kwargs = [
            "allow_control_chars",
            "retry_strategy",
            "buffer_limit",
            "csi",
            "opc_request_id",
            "ocid",
            "if_match",
            "homeregion",
            "problemtype",
            "bearertokentype",
            "bearertoken",
            "idtoken",
            "domainid"
        ]
        extra_kwargs = [_key for _key in six.iterkeys(kwargs) if _key not in expected_kwargs]
        if extra_kwargs:
            raise ValueError(
                f"put_attachment got unknown kwargs: {extra_kwargs!r}")

        path_params = {
            "incidentKey": incident_key
        }

        path_params = {k: v for (k, v) in six.iteritems(path_params) if v is not missing}

        for (k, v) in six.iteritems(path_params):
            if v is None or (isinstance(v, six.string_types) and len(v.strip()) == 0):
                raise ValueError(f'Parameter {k} cannot be None, whitespace or empty string')

        query_params = {
            "attachmentName": attachment_name,
            "compartmentId": compartment_id,
            "isRestrictedFlag": is_restricted_flag
        }
        query_params = {k: v for (k, v) in six.iteritems(query_params) if v is not missing and v is not None}

        header_params = {
            "accept": "application/json",
            "csi": kwargs.get("csi", missing),
            "opc-request-id": kwargs.get("opc_request_id", missing),
            "ocid": kwargs.get("ocid", missing),
            "if-match": kwargs.get("if_match", missing),
            "homeregion": kwargs.get("homeregion", missing),
            "problemtype": kwargs.get("problemtype", missing),
            "bearertokentype": kwargs.get("bearertokentype", missing),
            "bearertoken": kwargs.get("bearertoken", missing),
            "idtoken": kwargs.get("idtoken", missing),
            "domainid": kwargs.get("domainid", missing)
        }
        header_params = {k: v for (k, v) in six.iteritems(header_params) if v is not missing and v is not None}

        # If the body parameter is optional we need to assign it to a variable so additional type checking can be performed.
        try:
            put_attachment_details
        except NameError:
            put_attachment_details = kwargs.get("put_attachment_details", missing)

        if put_attachment_details is not missing and put_attachment_details is not None:
            if (not isinstance(put_attachment_details, (six.binary_type, six.string_types)) and
                    not hasattr(put_attachment_details, "read")):
                raise TypeError('The body must be a string, bytes, or provide a read() method.')

            if hasattr(put_attachment_details, 'fileno') and hasattr(put_attachment_details, 'name') and put_attachment_details.name != '<stdin>':
                if requests.utils.super_len(put_attachment_details) == 0:
                    header_params['Content-Length'] = '0'

            # If content length is not given and stream object have no 'fileno' and is not a string or bytes, try to calculate content length
            elif 'Content-Length' not in header_params and not is_content_length_calculable_by_req_util(put_attachment_details):
                calculated_obj = back_up_body_calculate_stream_content_length(put_attachment_details, kwargs.get("buffer_limit"))
                header_params['Content-Length'] = calculated_obj["content_length"]
                put_attachment_details = calculated_obj["byte_content"]

        retry_strategy = self.base_client.get_preferred_retry_strategy(
            operation_retry_strategy=kwargs.get('retry_strategy'),
            client_retry_strategy=self.retry_strategy
        )

        if retry_strategy:
            if not isinstance(retry_strategy, retry.NoneRetryStrategy):
                self.base_client.add_opc_client_retries_header(header_params)
                retry_strategy.add_circuit_breaker_callback(self.circuit_breaker_callback)
            return retry_strategy.make_retrying_call(
                self.base_client.call_api,
                resource_path=resource_path,
                method=method,
                path_params=path_params,
                query_params=query_params,
                header_params=header_params,
                body=put_attachment_details,
                response_type="Incident",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
        else:
            return self.base_client.call_api(
                resource_path=resource_path,
                method=method,
                path_params=path_params,
                query_params=query_params,
                header_params=header_params,
                body=put_attachment_details,
                response_type="Incident",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)

    def update_incident(self, incident_key, update_incident_details, compartment_id, **kwargs):
        """
        Updates the specified support request.
        For more information, see `Updating Support Requests`__.

        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/update-incident.htm


        :param str incident_key: (required)
            Unique identifier for the support request.

        :param oci.cims.models.UpdateIncident update_incident_details: (required)
            Details about the support request being updated.

        :param str compartment_id: (required)
            The OCID of the tenancy.

        :param str csi: (optional)
            The Customer Support Identifier (CSI) number associated with the support account.
            The CSI is optional for all support request types.

        :param str opc_request_id: (optional)
            Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.

        :param str if_match: (optional)
            For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.

        :param str ocid: (optional)
            User OCID for Oracle Identity Cloud Service (IDCS) users who also have a federated Oracle Cloud Infrastructure account.
            User OCID is mandatory for OCI Users and optional for Multicloud users.

        :param str homeregion: (optional)
            The region of the tenancy.

        :param str bearertokentype: (optional)
            Token type that determine which cloud provider the request come from.

        :param str bearertoken: (optional)
            Token that provided by multi cloud provider, which help to validate the email.

        :param str idtoken: (optional)
            IdToken that provided by multi cloud provider, which help to validate the email.

        :param str domainid: (optional)
            The OCID of identity domain.
            DomainID is mandatory if the user is part of Non Default Identity domain.

        :param obj retry_strategy: (optional)
            A retry strategy to apply to this specific operation/call. This will override any retry strategy set at the client-level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. This operation will not retry by default, users can also use the convenient :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY` provided by the SDK to enable retries for it.
            The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

            To have this operation explicitly not perform any retries, pass an instance of :py:class:`~oci.retry.NoneRetryStrategy`.

        :param bool allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this request should allow control characters in the response object.
            By default, the response will not allow control characters in strings

        :return: A :class:`~oci.response.Response` object with data of type :class:`~oci.cims.models.Incident`
        :rtype: :class:`~oci.response.Response`

        :example:
        Click `here <https://docs.cloud.oracle.com/en-us/iaas/tools/python-sdk-examples/2.164.0/cims/update_incident.py.html>`__ to see an example of how to use update_incident API.
        """
        # Required path and query arguments. These are in camelCase to replace values in service endpoints.
        required_arguments = ['incidentKey', 'compartmentId']
        resource_path = "/v2/incidents/{incidentKey}"
        method = "PUT"
        operation_name = "update_incident"
        api_reference_link = "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/UpdateIncident/UpdateIncident"

        # Don't accept unknown kwargs
        expected_kwargs = [
            "allow_control_chars",
            "retry_strategy",
            "csi",
            "opc_request_id",
            "if_match",
            "ocid",
            "homeregion",
            "bearertokentype",
            "bearertoken",
            "idtoken",
            "domainid"
        ]
        extra_kwargs = [_key for _key in six.iterkeys(kwargs) if _key not in expected_kwargs]
        if extra_kwargs:
            raise ValueError(
                f"update_incident got unknown kwargs: {extra_kwargs!r}")

        path_params = {
            "incidentKey": incident_key
        }

        path_params = {k: v for (k, v) in six.iteritems(path_params) if v is not missing}

        for (k, v) in six.iteritems(path_params):
            if v is None or (isinstance(v, six.string_types) and len(v.strip()) == 0):
                raise ValueError(f'Parameter {k} cannot be None, whitespace or empty string')

        query_params = {
            "compartmentId": compartment_id
        }
        query_params = {k: v for (k, v) in six.iteritems(query_params) if v is not missing and v is not None}

        header_params = {
            "accept": "application/json",
            "content-type": "application/json",
            "csi": kwargs.get("csi", missing),
            "opc-request-id": kwargs.get("opc_request_id", missing),
            "if-match": kwargs.get("if_match", missing),
            "ocid": kwargs.get("ocid", missing),
            "homeregion": kwargs.get("homeregion", missing),
            "bearertokentype": kwargs.get("bearertokentype", missing),
            "bearertoken": kwargs.get("bearertoken", missing),
            "idtoken": kwargs.get("idtoken", missing),
            "domainid": kwargs.get("domainid", missing)
        }
        header_params = {k: v for (k, v) in six.iteritems(header_params) if v is not missing and v is not None}

        retry_strategy = self.base_client.get_preferred_retry_strategy(
            operation_retry_strategy=kwargs.get('retry_strategy'),
            client_retry_strategy=self.retry_strategy
        )

        if retry_strategy:
            if not isinstance(retry_strategy, retry.NoneRetryStrategy):
                self.base_client.add_opc_client_retries_header(header_params)
                retry_strategy.add_circuit_breaker_callback(self.circuit_breaker_callback)
            return retry_strategy.make_retrying_call(
                self.base_client.call_api,
                resource_path=resource_path,
                method=method,
                path_params=path_params,
                query_params=query_params,
                header_params=header_params,
                body=update_incident_details,
                response_type="Incident",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
        else:
            return self.base_client.call_api(
                resource_path=resource_path,
                method=method,
                path_params=path_params,
                query_params=query_params,
                header_params=header_params,
                body=update_incident_details,
                response_type="Incident",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)

    def validate_user(self, **kwargs):
        """
        Checks whether the requested user is valid.
        For more information, see `Validating a User`__.

        __ https://docs.cloud.oracle.com/iaas/Content/GSG/support/validate-user.htm


        :param str csi: (optional)
            The Customer Support Identifier (CSI) number associated with the support account.
            The CSI is optional for all support request types.

        :param str opc_request_id: (optional)
            Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.

        :param str problem_type: (optional)
            The kind of support request.

            Allowed values are: "LIMIT", "LEGACY_LIMIT", "TECH", "ACCOUNT", "TAXONOMY"

        :param str ocid: (optional)
            User OCID for Oracle Identity Cloud Service (IDCS) users who also have a federated Oracle Cloud Infrastructure account.
            User OCID is mandatory for OCI Users and optional for Multicloud users.

        :param str homeregion: (optional)
            The region of the tenancy.

        :param str bearertokentype: (optional)
            Token type that determine which cloud provider the request come from.

        :param str bearertoken: (optional)
            Token that provided by multi cloud provider, which help to validate the email.

        :param str idtoken: (optional)
            IdToken that provided by multi cloud provider, which help to validate the email.

        :param str domainid: (optional)
            The OCID of identity domain.
            DomainID is mandatory if the user is part of Non Default Identity domain.

        :param obj retry_strategy: (optional)
            A retry strategy to apply to this specific operation/call. This will override any retry strategy set at the client-level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. This operation will not retry by default, users can also use the convenient :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY` provided by the SDK to enable retries for it.
            The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

            To have this operation explicitly not perform any retries, pass an instance of :py:class:`~oci.retry.NoneRetryStrategy`.

        :param bool allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this request should allow control characters in the response object.
            By default, the response will not allow control characters in strings

        :return: A :class:`~oci.response.Response` object with data of type :class:`~oci.cims.models.ValidationResponse`
        :rtype: :class:`~oci.response.Response`

        :example:
        Click `here <https://docs.cloud.oracle.com/en-us/iaas/tools/python-sdk-examples/2.164.0/cims/validate_user.py.html>`__ to see an example of how to use validate_user API.
        """
        # Required path and query arguments. These are in camelCase to replace values in service endpoints.
        required_arguments = []
        resource_path = "/v2/incidents/user/validate"
        method = "GET"
        operation_name = "validate_user"
        api_reference_link = "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/ValidationResponse/ValidateUser"

        # Don't accept unknown kwargs
        expected_kwargs = [
            "allow_control_chars",
            "retry_strategy",
            "csi",
            "opc_request_id",
            "problem_type",
            "ocid",
            "homeregion",
            "bearertokentype",
            "bearertoken",
            "idtoken",
            "domainid"
        ]
        extra_kwargs = [_key for _key in six.iterkeys(kwargs) if _key not in expected_kwargs]
        if extra_kwargs:
            raise ValueError(
                f"validate_user got unknown kwargs: {extra_kwargs!r}")

        if 'problem_type' in kwargs:
            problem_type_allowed_values = ["LIMIT", "LEGACY_LIMIT", "TECH", "ACCOUNT", "TAXONOMY"]
            if kwargs['problem_type'] not in problem_type_allowed_values:
                raise ValueError(
                    f"Invalid value for `problem_type`, must be one of { problem_type_allowed_values }"
                )

        query_params = {
            "problemType": kwargs.get("problem_type", missing)
        }
        query_params = {k: v for (k, v) in six.iteritems(query_params) if v is not missing and v is not None}

        header_params = {
            "accept": "application/json",
            "content-type": "application/json",
            "csi": kwargs.get("csi", missing),
            "opc-request-id": kwargs.get("opc_request_id", missing),
            "ocid": kwargs.get("ocid", missing),
            "homeregion": kwargs.get("homeregion", missing),
            "bearertokentype": kwargs.get("bearertokentype", missing),
            "bearertoken": kwargs.get("bearertoken", missing),
            "idtoken": kwargs.get("idtoken", missing),
            "domainid": kwargs.get("domainid", missing)
        }
        header_params = {k: v for (k, v) in six.iteritems(header_params) if v is not missing and v is not None}

        retry_strategy = self.base_client.get_preferred_retry_strategy(
            operation_retry_strategy=kwargs.get('retry_strategy'),
            client_retry_strategy=self.retry_strategy
        )

        if retry_strategy:
            if not isinstance(retry_strategy, retry.NoneRetryStrategy):
                self.base_client.add_opc_client_retries_header(header_params)
                retry_strategy.add_circuit_breaker_callback(self.circuit_breaker_callback)
            return retry_strategy.make_retrying_call(
                self.base_client.call_api,
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="ValidationResponse",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
        else:
            return self.base_client.call_api(
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="ValidationResponse",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
