# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181231


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Services(object):
    """
    List of Service Categories of a Service for MOS Taxonomy.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Services object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param service:
            The value to assign to the service property of this Services.
        :type service: dict(str, str)

        :param schema:
            The value to assign to the schema property of this Services.
        :type schema: str

        :param service_categories:
            The value to assign to the service_categories property of this Services.
        :type service_categories: list[oci.cims.models.SubCategories]

        """
        self.swagger_types = {
            'service': 'dict(str, str)',
            'schema': 'str',
            'service_categories': 'list[SubCategories]'
        }
        self.attribute_map = {
            'service': 'service',
            'schema': 'schema',
            'service_categories': 'serviceCategories'
        }
        self._service = None
        self._schema = None
        self._service_categories = None

    @property
    def service(self):
        """
        Gets the service of this Services.
        Service Category list.


        :return: The service of this Services.
        :rtype: dict(str, str)
        """
        return self._service

    @service.setter
    def service(self, service):
        """
        Sets the service of this Services.
        Service Category list.


        :param service: The service of this Services.
        :type: dict(str, str)
        """
        self._service = service

    @property
    def schema(self):
        """
        Gets the schema of this Services.
        Schema of a Service Category.


        :return: The schema of this Services.
        :rtype: str
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """
        Sets the schema of this Services.
        Schema of a Service Category.


        :param schema: The schema of this Services.
        :type: str
        """
        self._schema = schema

    @property
    def service_categories(self):
        """
        Gets the service_categories of this Services.
        The service categories list for MOS Taxonomy.


        :return: The service_categories of this Services.
        :rtype: list[oci.cims.models.SubCategories]
        """
        return self._service_categories

    @service_categories.setter
    def service_categories(self, service_categories):
        """
        Sets the service_categories of this Services.
        The service categories list for MOS Taxonomy.


        :param service_categories: The service_categories of this Services.
        :type: list[oci.cims.models.SubCategories]
        """
        self._service_categories = service_categories

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
