# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180222


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RebootClusterNodeDetails(object):
    """
    The properties that define a node reboot action.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RebootClusterNodeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param node_eviction_settings:
            The value to assign to the node_eviction_settings property of this RebootClusterNodeDetails.
        :type node_eviction_settings: oci.container_engine.models.NodeEvictionSettings

        """
        self.swagger_types = {
            'node_eviction_settings': 'NodeEvictionSettings'
        }
        self.attribute_map = {
            'node_eviction_settings': 'nodeEvictionSettings'
        }
        self._node_eviction_settings = None

    @property
    def node_eviction_settings(self):
        """
        Gets the node_eviction_settings of this RebootClusterNodeDetails.

        :return: The node_eviction_settings of this RebootClusterNodeDetails.
        :rtype: oci.container_engine.models.NodeEvictionSettings
        """
        return self._node_eviction_settings

    @node_eviction_settings.setter
    def node_eviction_settings(self, node_eviction_settings):
        """
        Sets the node_eviction_settings of this RebootClusterNodeDetails.

        :param node_eviction_settings: The node_eviction_settings of this RebootClusterNodeDetails.
        :type: oci.container_engine.models.NodeEvictionSettings
        """
        self._node_eviction_settings = node_eviction_settings

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
