# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateComputeHostGroupDetails(object):
    """
    Detail information for a compute host group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateComputeHostGroupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateComputeHostGroupDetails.
        :type availability_domain: str

        :param display_name:
            The value to assign to the display_name property of this CreateComputeHostGroupDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateComputeHostGroupDetails.
        :type compartment_id: str

        :param configurations:
            The value to assign to the configurations property of this CreateComputeHostGroupDetails.
        :type configurations: list[oci.core.models.HostGroupConfiguration]

        :param is_targeted_placement_required:
            The value to assign to the is_targeted_placement_required property of this CreateComputeHostGroupDetails.
        :type is_targeted_placement_required: bool

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateComputeHostGroupDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateComputeHostGroupDetails.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'availability_domain': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'configurations': 'list[HostGroupConfiguration]',
            'is_targeted_placement_required': 'bool',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }
        self.attribute_map = {
            'availability_domain': 'availabilityDomain',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'configurations': 'configurations',
            'is_targeted_placement_required': 'isTargetedPlacementRequired',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }
        self._availability_domain = None
        self._display_name = None
        self._compartment_id = None
        self._configurations = None
        self._is_targeted_placement_required = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this CreateComputeHostGroupDetails.
        The availability domain of a host group.

        Example: `Uocm:PHX-AD-1`


        :return: The availability_domain of this CreateComputeHostGroupDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this CreateComputeHostGroupDetails.
        The availability domain of a host group.

        Example: `Uocm:PHX-AD-1`


        :param availability_domain: The availability_domain of this CreateComputeHostGroupDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateComputeHostGroupDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this CreateComputeHostGroupDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateComputeHostGroupDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreateComputeHostGroupDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateComputeHostGroupDetails.
        The OCID of the compartment that contains host group.


        :return: The compartment_id of this CreateComputeHostGroupDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateComputeHostGroupDetails.
        The OCID of the compartment that contains host group.


        :param compartment_id: The compartment_id of this CreateComputeHostGroupDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def configurations(self):
        """
        Gets the configurations of this CreateComputeHostGroupDetails.
        A list of HostGroupConfiguration objects


        :return: The configurations of this CreateComputeHostGroupDetails.
        :rtype: list[oci.core.models.HostGroupConfiguration]
        """
        return self._configurations

    @configurations.setter
    def configurations(self, configurations):
        """
        Sets the configurations of this CreateComputeHostGroupDetails.
        A list of HostGroupConfiguration objects


        :param configurations: The configurations of this CreateComputeHostGroupDetails.
        :type: list[oci.core.models.HostGroupConfiguration]
        """
        self._configurations = configurations

    @property
    def is_targeted_placement_required(self):
        """
        **[Required]** Gets the is_targeted_placement_required of this CreateComputeHostGroupDetails.
        A flag that allows customers to restrict placement for hosts attached to the group. If true, the only way to place on hosts is to target the specific host group.


        :return: The is_targeted_placement_required of this CreateComputeHostGroupDetails.
        :rtype: bool
        """
        return self._is_targeted_placement_required

    @is_targeted_placement_required.setter
    def is_targeted_placement_required(self, is_targeted_placement_required):
        """
        Sets the is_targeted_placement_required of this CreateComputeHostGroupDetails.
        A flag that allows customers to restrict placement for hosts attached to the group. If true, the only way to place on hosts is to target the specific host group.


        :param is_targeted_placement_required: The is_targeted_placement_required of this CreateComputeHostGroupDetails.
        :type: bool
        """
        self._is_targeted_placement_required = is_targeted_placement_required

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateComputeHostGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateComputeHostGroupDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateComputeHostGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateComputeHostGroupDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateComputeHostGroupDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateComputeHostGroupDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateComputeHostGroupDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateComputeHostGroupDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
