# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UserAccessAnalyticsSummary(object):
    """
    Summary of user access analytics data
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UserAccessAnalyticsSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param count:
            The value to assign to the count property of this UserAccessAnalyticsSummary.
        :type count: int

        :param user_name:
            The value to assign to the user_name property of this UserAccessAnalyticsSummary.
        :type user_name: str

        """
        self.swagger_types = {
            'count': 'int',
            'user_name': 'str'
        }
        self.attribute_map = {
            'count': 'count',
            'user_name': 'userName'
        }
        self._count = None
        self._user_name = None

    @property
    def count(self):
        """
        **[Required]** Gets the count of this UserAccessAnalyticsSummary.
        The total count of schemas a user can access


        :return: The count of this UserAccessAnalyticsSummary.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this UserAccessAnalyticsSummary.
        The total count of schemas a user can access


        :param count: The count of this UserAccessAnalyticsSummary.
        :type: int
        """
        self._count = count

    @property
    def user_name(self):
        """
        **[Required]** Gets the user_name of this UserAccessAnalyticsSummary.
        Name of the user.


        :return: The user_name of this UserAccessAnalyticsSummary.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this UserAccessAnalyticsSummary.
        Name of the user.


        :param user_name: The user_name of this UserAccessAnalyticsSummary.
        :type: str
        """
        self._user_name = user_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
