# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelGroupDetails(object):
    """
    The model group details.
    """

    #: A constant which can be used with the type property of a ModelGroupDetails.
    #: This constant has a value of "HOMOGENEOUS"
    TYPE_HOMOGENEOUS = "HOMOGENEOUS"

    #: A constant which can be used with the type property of a ModelGroupDetails.
    #: This constant has a value of "HETEROGENEOUS"
    TYPE_HETEROGENEOUS = "HETEROGENEOUS"

    #: A constant which can be used with the type property of a ModelGroupDetails.
    #: This constant has a value of "STACKED"
    TYPE_STACKED = "STACKED"

    def __init__(self, **kwargs):
        """
        Initializes a new ModelGroupDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.HeterogeneousModelGroupDetails`
        * :class:`~oci.data_science.models.StackedModelGroupDetails`
        * :class:`~oci.data_science.models.HomogeneousModelGroupDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ModelGroupDetails.
            Allowed values for this property are: "HOMOGENEOUS", "HETEROGENEOUS", "STACKED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param custom_metadata_list:
            The value to assign to the custom_metadata_list property of this ModelGroupDetails.
        :type custom_metadata_list: list[oci.data_science.models.CustomMetadata]

        """
        self.swagger_types = {
            'type': 'str',
            'custom_metadata_list': 'list[CustomMetadata]'
        }
        self.attribute_map = {
            'type': 'type',
            'custom_metadata_list': 'customMetadataList'
        }
        self._type = None
        self._custom_metadata_list = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'HETEROGENEOUS':
            return 'HeterogeneousModelGroupDetails'

        if type == 'STACKED':
            return 'StackedModelGroupDetails'

        if type == 'HOMOGENEOUS':
            return 'HomogeneousModelGroupDetails'
        else:
            return 'ModelGroupDetails'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this ModelGroupDetails.
        The type of the model group.

        Allowed values for this property are: "HOMOGENEOUS", "HETEROGENEOUS", "STACKED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this ModelGroupDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ModelGroupDetails.
        The type of the model group.


        :param type: The type of this ModelGroupDetails.
        :type: str
        """
        allowed_values = ["HOMOGENEOUS", "HETEROGENEOUS", "STACKED"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def custom_metadata_list(self):
        """
        Gets the custom_metadata_list of this ModelGroupDetails.
        An array of custom metadata details for the model group.


        :return: The custom_metadata_list of this ModelGroupDetails.
        :rtype: list[oci.data_science.models.CustomMetadata]
        """
        return self._custom_metadata_list

    @custom_metadata_list.setter
    def custom_metadata_list(self, custom_metadata_list):
        """
        Sets the custom_metadata_list of this ModelGroupDetails.
        An array of custom metadata details for the model group.


        :param custom_metadata_list: The custom_metadata_list of this ModelGroupDetails.
        :type: list[oci.data_science.models.CustomMetadata]
        """
        self._custom_metadata_list = custom_metadata_list

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
