# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .pipeline_step_output_parameter_details import PipelineStepOutputParameterDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PipelineJsonStepOutputParameterDetails(PipelineStepOutputParameterDetails):
    """
    Pipeline JSON output parameter details
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PipelineJsonStepOutputParameterDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.PipelineJsonStepOutputParameterDetails.output_parameter_type` attribute
        of this class is ``JSON`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param output_parameter_type:
            The value to assign to the output_parameter_type property of this PipelineJsonStepOutputParameterDetails.
            Allowed values for this property are: "JSON"
        :type output_parameter_type: str

        :param parameter_names:
            The value to assign to the parameter_names property of this PipelineJsonStepOutputParameterDetails.
        :type parameter_names: list[str]

        :param output_file:
            The value to assign to the output_file property of this PipelineJsonStepOutputParameterDetails.
        :type output_file: str

        """
        self.swagger_types = {
            'output_parameter_type': 'str',
            'parameter_names': 'list[str]',
            'output_file': 'str'
        }
        self.attribute_map = {
            'output_parameter_type': 'outputParameterType',
            'parameter_names': 'parameterNames',
            'output_file': 'outputFile'
        }
        self._output_parameter_type = None
        self._parameter_names = None
        self._output_file = None
        self._output_parameter_type = 'JSON'

    @property
    def parameter_names(self):
        """
        **[Required]** Gets the parameter_names of this PipelineJsonStepOutputParameterDetails.
        The list of parameter names that will be output by this step


        :return: The parameter_names of this PipelineJsonStepOutputParameterDetails.
        :rtype: list[str]
        """
        return self._parameter_names

    @parameter_names.setter
    def parameter_names(self, parameter_names):
        """
        Sets the parameter_names of this PipelineJsonStepOutputParameterDetails.
        The list of parameter names that will be output by this step


        :param parameter_names: The parameter_names of this PipelineJsonStepOutputParameterDetails.
        :type: list[str]
        """
        self._parameter_names = parameter_names

    @property
    def output_file(self):
        """
        **[Required]** Gets the output_file of this PipelineJsonStepOutputParameterDetails.
        Output file name


        :return: The output_file of this PipelineJsonStepOutputParameterDetails.
        :rtype: str
        """
        return self._output_file

    @output_file.setter
    def output_file(self, output_file):
        """
        Sets the output_file of this PipelineJsonStepOutputParameterDetails.
        Output file name


        :param output_file: The output_file of this PipelineJsonStepOutputParameterDetails.
        :type: str
        """
        self._output_file = output_file

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
