# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlApplyError(object):
    """
    Error from the apply operation of a MySQL server replication channel.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlApplyError object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param last_error_number:
            The value to assign to the last_error_number property of this MySqlApplyError.
        :type last_error_number: int

        :param last_error_message:
            The value to assign to the last_error_message property of this MySqlApplyError.
        :type last_error_message: str

        :param time_last_error:
            The value to assign to the time_last_error property of this MySqlApplyError.
        :type time_last_error: datetime

        :param worker_errors:
            The value to assign to the worker_errors property of this MySqlApplyError.
        :type worker_errors: list[oci.database_management.models.MySqlApplyErrorWorker]

        """
        self.swagger_types = {
            'last_error_number': 'int',
            'last_error_message': 'str',
            'time_last_error': 'datetime',
            'worker_errors': 'list[MySqlApplyErrorWorker]'
        }
        self.attribute_map = {
            'last_error_number': 'lastErrorNumber',
            'last_error_message': 'lastErrorMessage',
            'time_last_error': 'timeLastError',
            'worker_errors': 'workerErrors'
        }
        self._last_error_number = None
        self._last_error_message = None
        self._time_last_error = None
        self._worker_errors = None

    @property
    def last_error_number(self):
        """
        Gets the last_error_number of this MySqlApplyError.
        The error number of the most recent error that caused the SQL or coordinator thread to stop.


        :return: The last_error_number of this MySqlApplyError.
        :rtype: int
        """
        return self._last_error_number

    @last_error_number.setter
    def last_error_number(self, last_error_number):
        """
        Sets the last_error_number of this MySqlApplyError.
        The error number of the most recent error that caused the SQL or coordinator thread to stop.


        :param last_error_number: The last_error_number of this MySqlApplyError.
        :type: int
        """
        self._last_error_number = last_error_number

    @property
    def last_error_message(self):
        """
        Gets the last_error_message of this MySqlApplyError.
        The error message of the most recent error that caused the SQL or coordinator thread to stop.


        :return: The last_error_message of this MySqlApplyError.
        :rtype: str
        """
        return self._last_error_message

    @last_error_message.setter
    def last_error_message(self, last_error_message):
        """
        Sets the last_error_message of this MySqlApplyError.
        The error message of the most recent error that caused the SQL or coordinator thread to stop.


        :param last_error_message: The last_error_message of this MySqlApplyError.
        :type: str
        """
        self._last_error_message = last_error_message

    @property
    def time_last_error(self):
        """
        Gets the time_last_error of this MySqlApplyError.
        The timestamp when the most recent SQL or coordinator error occurred.


        :return: The time_last_error of this MySqlApplyError.
        :rtype: datetime
        """
        return self._time_last_error

    @time_last_error.setter
    def time_last_error(self, time_last_error):
        """
        Sets the time_last_error of this MySqlApplyError.
        The timestamp when the most recent SQL or coordinator error occurred.


        :param time_last_error: The time_last_error of this MySqlApplyError.
        :type: datetime
        """
        self._time_last_error = time_last_error

    @property
    def worker_errors(self):
        """
        Gets the worker_errors of this MySqlApplyError.
        A list of MySqlApplyErrorWorker records.


        :return: The worker_errors of this MySqlApplyError.
        :rtype: list[oci.database_management.models.MySqlApplyErrorWorker]
        """
        return self._worker_errors

    @worker_errors.setter
    def worker_errors(self, worker_errors):
        """
        Sets the worker_errors of this MySqlApplyError.
        A list of MySqlApplyErrorWorker records.


        :param worker_errors: The worker_errors of this MySqlApplyError.
        :type: list[oci.database_management.models.MySqlApplyErrorWorker]
        """
        self._worker_errors = worker_errors

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
