# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlDatabaseObject(object):
    """
    Database objects to include or exclude from migration
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlDatabaseObject object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param schema:
            The value to assign to the schema property of this MySqlDatabaseObject.
        :type schema: str

        :param object_name:
            The value to assign to the object_name property of this MySqlDatabaseObject.
        :type object_name: str

        :param type:
            The value to assign to the type property of this MySqlDatabaseObject.
        :type type: str

        """
        self.swagger_types = {
            'schema': 'str',
            'object_name': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'schema': 'schema',
            'object_name': 'objectName',
            'type': 'type'
        }
        self._schema = None
        self._object_name = None
        self._type = None

    @property
    def schema(self):
        """
        **[Required]** Gets the schema of this MySqlDatabaseObject.
        Schema of the object (regular expression is allowed)


        :return: The schema of this MySqlDatabaseObject.
        :rtype: str
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """
        Sets the schema of this MySqlDatabaseObject.
        Schema of the object (regular expression is allowed)


        :param schema: The schema of this MySqlDatabaseObject.
        :type: str
        """
        self._schema = schema

    @property
    def object_name(self):
        """
        **[Required]** Gets the object_name of this MySqlDatabaseObject.
        Name of the object (regular expression is allowed)


        :return: The object_name of this MySqlDatabaseObject.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this MySqlDatabaseObject.
        Name of the object (regular expression is allowed)


        :param object_name: The object_name of this MySqlDatabaseObject.
        :type: str
        """
        self._object_name = object_name

    @property
    def type(self):
        """
        Gets the type of this MySqlDatabaseObject.
        Type of object to exclude.
        If not specified, matching owners and object names of type TABLE would be excluded.


        :return: The type of this MySqlDatabaseObject.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this MySqlDatabaseObject.
        Type of object to exclude.
        If not specified, matching owners and object names of type TABLE would be excluded.


        :param type: The type of this MySqlDatabaseObject.
        :type: str
        """
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
