# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518

from .migration_object_collection import MigrationObjectCollection
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleMigrationObjectCollection(MigrationObjectCollection):
    """
    Database objects to migrate.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OracleMigrationObjectCollection object with values from keyword arguments. The default value of the :py:attr:`~oci.database_migration.models.OracleMigrationObjectCollection.database_combination` attribute
        of this class is ``ORACLE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_combination:
            The value to assign to the database_combination property of this OracleMigrationObjectCollection.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type database_combination: str

        :param items:
            The value to assign to the items property of this OracleMigrationObjectCollection.
        :type items: list[oci.database_migration.models.OracleDatabaseObjectSummary]

        :param bulk_include_exclude_data:
            The value to assign to the bulk_include_exclude_data property of this OracleMigrationObjectCollection.
        :type bulk_include_exclude_data: str

        """
        self.swagger_types = {
            'database_combination': 'str',
            'items': 'list[OracleDatabaseObjectSummary]',
            'bulk_include_exclude_data': 'str'
        }
        self.attribute_map = {
            'database_combination': 'databaseCombination',
            'items': 'items',
            'bulk_include_exclude_data': 'bulkIncludeExcludeData'
        }
        self._database_combination = None
        self._items = None
        self._bulk_include_exclude_data = None
        self._database_combination = 'ORACLE'

    @property
    def items(self):
        """
        **[Required]** Gets the items of this OracleMigrationObjectCollection.
        Database objects to exclude/include from migration


        :return: The items of this OracleMigrationObjectCollection.
        :rtype: list[oci.database_migration.models.OracleDatabaseObjectSummary]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this OracleMigrationObjectCollection.
        Database objects to exclude/include from migration


        :param items: The items of this OracleMigrationObjectCollection.
        :type: list[oci.database_migration.models.OracleDatabaseObjectSummary]
        """
        self._items = items

    @property
    def bulk_include_exclude_data(self):
        """
        Gets the bulk_include_exclude_data of this OracleMigrationObjectCollection.
        Specifies the database objects to be excluded from the migration in bulk.
        The definition accepts input in a CSV format, newline separated for each entry.
        More details can be found in the documentation.


        :return: The bulk_include_exclude_data of this OracleMigrationObjectCollection.
        :rtype: str
        """
        return self._bulk_include_exclude_data

    @bulk_include_exclude_data.setter
    def bulk_include_exclude_data(self, bulk_include_exclude_data):
        """
        Sets the bulk_include_exclude_data of this OracleMigrationObjectCollection.
        Specifies the database objects to be excluded from the migration in bulk.
        The definition accepts input in a CSV format, newline separated for each entry.
        More details can be found in the documentation.


        :param bulk_include_exclude_data: The bulk_include_exclude_data of this OracleMigrationObjectCollection.
        :type: str
        """
        self._bulk_include_exclude_data = bulk_include_exclude_data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
