# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOracleDbAwsIdentityConnectorDetails(object):
    """
    This object is about to provide input params to create Oracle DB AWS Identity Connector Resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOracleDbAwsIdentityConnectorDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type display_name: str

        :param resource_id:
            The value to assign to the resource_id property of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type resource_id: str

        :param oidc_scope:
            The value to assign to the oidc_scope property of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type oidc_scope: str

        :param issuer_url:
            The value to assign to the issuer_url property of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type issuer_url: str

        :param service_role_details:
            The value to assign to the service_role_details property of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type service_role_details: list[oci.dbmulticloud.models.ServiceRoleDetail]

        :param aws_location:
            The value to assign to the aws_location property of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type aws_location: str

        :param aws_sts_private_endpoint:
            The value to assign to the aws_sts_private_endpoint property of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type aws_sts_private_endpoint: str

        :param aws_account_id:
            The value to assign to the aws_account_id property of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type aws_account_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'resource_id': 'str',
            'oidc_scope': 'str',
            'issuer_url': 'str',
            'service_role_details': 'list[ServiceRoleDetail]',
            'aws_location': 'str',
            'aws_sts_private_endpoint': 'str',
            'aws_account_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'resource_id': 'resourceId',
            'oidc_scope': 'oidcScope',
            'issuer_url': 'issuerUrl',
            'service_role_details': 'serviceRoleDetails',
            'aws_location': 'awsLocation',
            'aws_sts_private_endpoint': 'awsStsPrivateEndpoint',
            'aws_account_id': 'awsAccountId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._resource_id = None
        self._oidc_scope = None
        self._issuer_url = None
        self._service_role_details = None
        self._aws_location = None
        self._aws_sts_private_endpoint = None
        self._aws_account_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateOracleDbAwsIdentityConnectorDetails.
        Oracle DB Google AWS Identity Connector resource name.


        :return: The display_name of this UpdateOracleDbAwsIdentityConnectorDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateOracleDbAwsIdentityConnectorDetails.
        Oracle DB Google AWS Identity Connector resource name.


        :param display_name: The display_name of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def resource_id(self):
        """
        Gets the resource_id of this UpdateOracleDbAwsIdentityConnectorDetails.
        The `OCID`__ of the AWS VM Cluster resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this UpdateOracleDbAwsIdentityConnectorDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this UpdateOracleDbAwsIdentityConnectorDetails.
        The `OCID`__ of the AWS VM Cluster resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def oidc_scope(self):
        """
        Gets the oidc_scope of this UpdateOracleDbAwsIdentityConnectorDetails.
        IAM Domain scope for issuer URL.


        :return: The oidc_scope of this UpdateOracleDbAwsIdentityConnectorDetails.
        :rtype: str
        """
        return self._oidc_scope

    @oidc_scope.setter
    def oidc_scope(self, oidc_scope):
        """
        Sets the oidc_scope of this UpdateOracleDbAwsIdentityConnectorDetails.
        IAM Domain scope for issuer URL.


        :param oidc_scope: The oidc_scope of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type: str
        """
        self._oidc_scope = oidc_scope

    @property
    def issuer_url(self):
        """
        Gets the issuer_url of this UpdateOracleDbAwsIdentityConnectorDetails.
        OIDC token issuer Url.


        :return: The issuer_url of this UpdateOracleDbAwsIdentityConnectorDetails.
        :rtype: str
        """
        return self._issuer_url

    @issuer_url.setter
    def issuer_url(self, issuer_url):
        """
        Sets the issuer_url of this UpdateOracleDbAwsIdentityConnectorDetails.
        OIDC token issuer Url.


        :param issuer_url: The issuer_url of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type: str
        """
        self._issuer_url = issuer_url

    @property
    def service_role_details(self):
        """
        Gets the service_role_details of this UpdateOracleDbAwsIdentityConnectorDetails.
        Service role details and respective Amazon resource nam of Role.


        :return: The service_role_details of this UpdateOracleDbAwsIdentityConnectorDetails.
        :rtype: list[oci.dbmulticloud.models.ServiceRoleDetail]
        """
        return self._service_role_details

    @service_role_details.setter
    def service_role_details(self, service_role_details):
        """
        Sets the service_role_details of this UpdateOracleDbAwsIdentityConnectorDetails.
        Service role details and respective Amazon resource nam of Role.


        :param service_role_details: The service_role_details of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type: list[oci.dbmulticloud.models.ServiceRoleDetail]
        """
        self._service_role_details = service_role_details

    @property
    def aws_location(self):
        """
        Gets the aws_location of this UpdateOracleDbAwsIdentityConnectorDetails.
        AWS resource Location.


        :return: The aws_location of this UpdateOracleDbAwsIdentityConnectorDetails.
        :rtype: str
        """
        return self._aws_location

    @aws_location.setter
    def aws_location(self, aws_location):
        """
        Sets the aws_location of this UpdateOracleDbAwsIdentityConnectorDetails.
        AWS resource Location.


        :param aws_location: The aws_location of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type: str
        """
        self._aws_location = aws_location

    @property
    def aws_sts_private_endpoint(self):
        """
        Gets the aws_sts_private_endpoint of this UpdateOracleDbAwsIdentityConnectorDetails.
        Private endpoint of AWS Security Token Service.


        :return: The aws_sts_private_endpoint of this UpdateOracleDbAwsIdentityConnectorDetails.
        :rtype: str
        """
        return self._aws_sts_private_endpoint

    @aws_sts_private_endpoint.setter
    def aws_sts_private_endpoint(self, aws_sts_private_endpoint):
        """
        Sets the aws_sts_private_endpoint of this UpdateOracleDbAwsIdentityConnectorDetails.
        Private endpoint of AWS Security Token Service.


        :param aws_sts_private_endpoint: The aws_sts_private_endpoint of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type: str
        """
        self._aws_sts_private_endpoint = aws_sts_private_endpoint

    @property
    def aws_account_id(self):
        """
        Gets the aws_account_id of this UpdateOracleDbAwsIdentityConnectorDetails.
        AWS Account ID.


        :return: The aws_account_id of this UpdateOracleDbAwsIdentityConnectorDetails.
        :rtype: str
        """
        return self._aws_account_id

    @aws_account_id.setter
    def aws_account_id(self, aws_account_id):
        """
        Sets the aws_account_id of this UpdateOracleDbAwsIdentityConnectorDetails.
        AWS Account ID.


        :param aws_account_id: The aws_account_id of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type: str
        """
        self._aws_account_id = aws_account_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateOracleDbAwsIdentityConnectorDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateOracleDbAwsIdentityConnectorDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateOracleDbAwsIdentityConnectorDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateOracleDbAwsIdentityConnectorDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateOracleDbAwsIdentityConnectorDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateOracleDbAwsIdentityConnectorDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateOracleDbAwsIdentityConnectorDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
