# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OccDemandSignalData(object):
    """
    The Data Object For Demand Signal.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OccDemandSignalData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_type:
            The value to assign to the resource_type property of this OccDemandSignalData.
        :type resource_type: str

        :param units:
            The value to assign to the units property of this OccDemandSignalData.
        :type units: str

        :param values:
            The value to assign to the values property of this OccDemandSignalData.
        :type values: list[oci.demand_signal.models.OccDemandSignalValue]

        """
        self.swagger_types = {
            'resource_type': 'str',
            'units': 'str',
            'values': 'list[OccDemandSignalValue]'
        }
        self.attribute_map = {
            'resource_type': 'resourceType',
            'units': 'units',
            'values': 'values'
        }
        self._resource_type = None
        self._units = None
        self._values = None

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this OccDemandSignalData.
        The name of the resource for the data.


        :return: The resource_type of this OccDemandSignalData.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this OccDemandSignalData.
        The name of the resource for the data.


        :param resource_type: The resource_type of this OccDemandSignalData.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def units(self):
        """
        **[Required]** Gets the units of this OccDemandSignalData.
        The units of the data.


        :return: The units of this OccDemandSignalData.
        :rtype: str
        """
        return self._units

    @units.setter
    def units(self, units):
        """
        Sets the units of this OccDemandSignalData.
        The units of the data.


        :param units: The units of this OccDemandSignalData.
        :type: str
        """
        self._units = units

    @property
    def values(self):
        """
        **[Required]** Gets the values of this OccDemandSignalData.
        The values of forecast.


        :return: The values of this OccDemandSignalData.
        :rtype: list[oci.demand_signal.models.OccDemandSignalValue]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this OccDemandSignalData.
        The values of forecast.


        :param values: The values of this OccDemandSignalData.
        :type: list[oci.demand_signal.models.OccDemandSignalValue]
        """
        self._values = values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
