# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdditionalDetails(object):
    """
    Additional details about the provisioned services
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AdditionalDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param assigned_connections:
            The value to assign to the assigned_connections property of this AdditionalDetails.
        :type assigned_connections: list[oci.dif.models.AssignedConnectionDetails]

        :param model_id:
            The value to assign to the model_id property of this AdditionalDetails.
        :type model_id: str

        :param model_version:
            The value to assign to the model_version property of this AdditionalDetails.
        :type model_version: str

        :param oci_region:
            The value to assign to the oci_region property of this AdditionalDetails.
        :type oci_region: str

        :param endpoint_details:
            The value to assign to the endpoint_details property of this AdditionalDetails.
        :type endpoint_details: list[oci.dif.models.EndpointAdditional]

        :param private_endpoint_id:
            The value to assign to the private_endpoint_id property of this AdditionalDetails.
        :type private_endpoint_id: str

        """
        self.swagger_types = {
            'assigned_connections': 'list[AssignedConnectionDetails]',
            'model_id': 'str',
            'model_version': 'str',
            'oci_region': 'str',
            'endpoint_details': 'list[EndpointAdditional]',
            'private_endpoint_id': 'str'
        }
        self.attribute_map = {
            'assigned_connections': 'assignedConnections',
            'model_id': 'modelId',
            'model_version': 'modelVersion',
            'oci_region': 'ociRegion',
            'endpoint_details': 'endpointDetails',
            'private_endpoint_id': 'privateEndpointId'
        }
        self._assigned_connections = None
        self._model_id = None
        self._model_version = None
        self._oci_region = None
        self._endpoint_details = None
        self._private_endpoint_id = None

    @property
    def assigned_connections(self):
        """
        Gets the assigned_connections of this AdditionalDetails.
        connections assigned to Golden Gate deployment


        :return: The assigned_connections of this AdditionalDetails.
        :rtype: list[oci.dif.models.AssignedConnectionDetails]
        """
        return self._assigned_connections

    @assigned_connections.setter
    def assigned_connections(self, assigned_connections):
        """
        Sets the assigned_connections of this AdditionalDetails.
        connections assigned to Golden Gate deployment


        :param assigned_connections: The assigned_connections of this AdditionalDetails.
        :type: list[oci.dif.models.AssignedConnectionDetails]
        """
        self._assigned_connections = assigned_connections

    @property
    def model_id(self):
        """
        Gets the model_id of this AdditionalDetails.
        OCID of model


        :return: The model_id of this AdditionalDetails.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this AdditionalDetails.
        OCID of model


        :param model_id: The model_id of this AdditionalDetails.
        :type: str
        """
        self._model_id = model_id

    @property
    def model_version(self):
        """
        Gets the model_version of this AdditionalDetails.
        version of model


        :return: The model_version of this AdditionalDetails.
        :rtype: str
        """
        return self._model_version

    @model_version.setter
    def model_version(self, model_version):
        """
        Sets the model_version of this AdditionalDetails.
        version of model


        :param model_version: The model_version of this AdditionalDetails.
        :type: str
        """
        self._model_version = model_version

    @property
    def oci_region(self):
        """
        Gets the oci_region of this AdditionalDetails.
        region of cluster


        :return: The oci_region of this AdditionalDetails.
        :rtype: str
        """
        return self._oci_region

    @oci_region.setter
    def oci_region(self, oci_region):
        """
        Sets the oci_region of this AdditionalDetails.
        region of cluster


        :param oci_region: The oci_region of this AdditionalDetails.
        :type: str
        """
        self._oci_region = oci_region

    @property
    def endpoint_details(self):
        """
        Gets the endpoint_details of this AdditionalDetails.
        details of all endpoints assigned to cluster


        :return: The endpoint_details of this AdditionalDetails.
        :rtype: list[oci.dif.models.EndpointAdditional]
        """
        return self._endpoint_details

    @endpoint_details.setter
    def endpoint_details(self, endpoint_details):
        """
        Sets the endpoint_details of this AdditionalDetails.
        details of all endpoints assigned to cluster


        :param endpoint_details: The endpoint_details of this AdditionalDetails.
        :type: list[oci.dif.models.EndpointAdditional]
        """
        self._endpoint_details = endpoint_details

    @property
    def private_endpoint_id(self):
        """
        Gets the private_endpoint_id of this AdditionalDetails.
        OCID of model


        :return: The private_endpoint_id of this AdditionalDetails.
        :rtype: str
        """
        return self._private_endpoint_id

    @private_endpoint_id.setter
    def private_endpoint_id(self, private_endpoint_id):
        """
        Sets the private_endpoint_id of this AdditionalDetails.
        OCID of model


        :param private_endpoint_id: The private_endpoint_id of this AdditionalDetails.
        :type: str
        """
        self._private_endpoint_id = private_endpoint_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
