# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataflowArtifactsDetail(object):
    """
    Detail to deploy Artifacts for Dataflow service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataflowArtifactsDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this DataflowArtifactsDetail.
        :type instance_id: str

        :param execute:
            The value to assign to the execute property of this DataflowArtifactsDetail.
        :type execute: str

        :param archive_uri:
            The value to assign to the archive_uri property of this DataflowArtifactsDetail.
        :type archive_uri: str

        """
        self.swagger_types = {
            'instance_id': 'str',
            'execute': 'str',
            'archive_uri': 'str'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'execute': 'execute',
            'archive_uri': 'archiveUri'
        }
        self._instance_id = None
        self._execute = None
        self._archive_uri = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this DataflowArtifactsDetail.
        Instance id of the existing Dataflow Instance for artifact deployment.


        :return: The instance_id of this DataflowArtifactsDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this DataflowArtifactsDetail.
        Instance id of the existing Dataflow Instance for artifact deployment.


        :param instance_id: The instance_id of this DataflowArtifactsDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def execute(self):
        """
        **[Required]** Gets the execute of this DataflowArtifactsDetail.
        Contains the main file (py/jar) along with parameters & configuration to be passed to the DataFlow run.


        :return: The execute of this DataflowArtifactsDetail.
        :rtype: str
        """
        return self._execute

    @execute.setter
    def execute(self, execute):
        """
        Sets the execute of this DataflowArtifactsDetail.
        Contains the main file (py/jar) along with parameters & configuration to be passed to the DataFlow run.


        :param execute: The execute of this DataflowArtifactsDetail.
        :type: str
        """
        self._execute = execute

    @property
    def archive_uri(self):
        """
        Gets the archive_uri of this DataflowArtifactsDetail.
        Contains the archive from object storage bucket which can be added as dependency to data flow application.


        :return: The archive_uri of this DataflowArtifactsDetail.
        :rtype: str
        """
        return self._archive_uri

    @archive_uri.setter
    def archive_uri(self, archive_uri):
        """
        Sets the archive_uri of this DataflowArtifactsDetail.
        Contains the archive from object storage bucket which can be added as dependency to data flow application.


        :param archive_uri: The archive_uri of this DataflowArtifactsDetail.
        :type: str
        """
        self._archive_uri = archive_uri

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
