# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ShapeConfig(object):
    """
    This is used to configure the shape of the driver or executor if a flexible shape is used.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ShapeConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param memory_in_gbs:
            The value to assign to the memory_in_gbs property of this ShapeConfig.
        :type memory_in_gbs: int

        :param ocpus:
            The value to assign to the ocpus property of this ShapeConfig.
        :type ocpus: int

        """
        self.swagger_types = {
            'memory_in_gbs': 'int',
            'ocpus': 'int'
        }
        self.attribute_map = {
            'memory_in_gbs': 'memoryInGBs',
            'ocpus': 'ocpus'
        }
        self._memory_in_gbs = None
        self._ocpus = None

    @property
    def memory_in_gbs(self):
        """
        **[Required]** Gets the memory_in_gbs of this ShapeConfig.
        The amount of memory used for the driver or executors.


        :return: The memory_in_gbs of this ShapeConfig.
        :rtype: int
        """
        return self._memory_in_gbs

    @memory_in_gbs.setter
    def memory_in_gbs(self, memory_in_gbs):
        """
        Sets the memory_in_gbs of this ShapeConfig.
        The amount of memory used for the driver or executors.


        :param memory_in_gbs: The memory_in_gbs of this ShapeConfig.
        :type: int
        """
        self._memory_in_gbs = memory_in_gbs

    @property
    def ocpus(self):
        """
        **[Required]** Gets the ocpus of this ShapeConfig.
        The total number of OCPUs used for the driver or executors. See here for details.


        :return: The ocpus of this ShapeConfig.
        :rtype: int
        """
        return self._ocpus

    @ocpus.setter
    def ocpus(self, ocpus):
        """
        Sets the ocpus of this ShapeConfig.
        The total number of OCPUs used for the driver or executors. See here for details.


        :param ocpus: The ocpus of this ShapeConfig.
        :type: int
        """
        self._ocpus = ocpus

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
