# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KmsKeyVariableDependsOn(object):
    """
    Depends on object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KmsKeyVariableDependsOn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this KmsKeyVariableDependsOn.
        :type compartment_id: str

        :param vault_id:
            The value to assign to the vault_id property of this KmsKeyVariableDependsOn.
        :type vault_id: str

        :param protection_mode:
            The value to assign to the protection_mode property of this KmsKeyVariableDependsOn.
        :type protection_mode: str

        :param algorithm:
            The value to assign to the algorithm property of this KmsKeyVariableDependsOn.
        :type algorithm: str

        :param length:
            The value to assign to the length property of this KmsKeyVariableDependsOn.
        :type length: int

        :param curve_id:
            The value to assign to the curve_id property of this KmsKeyVariableDependsOn.
        :type curve_id: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'vault_id': 'str',
            'protection_mode': 'str',
            'algorithm': 'str',
            'length': 'int',
            'curve_id': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'vault_id': 'vaultId',
            'protection_mode': 'protectionMode',
            'algorithm': 'algorithm',
            'length': 'length',
            'curve_id': 'curveId'
        }
        self._compartment_id = None
        self._vault_id = None
        self._protection_mode = None
        self._algorithm = None
        self._length = None
        self._curve_id = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this KmsKeyVariableDependsOn.
        OCID of the compartment.


        :return: The compartment_id of this KmsKeyVariableDependsOn.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this KmsKeyVariableDependsOn.
        OCID of the compartment.


        :param compartment_id: The compartment_id of this KmsKeyVariableDependsOn.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def vault_id(self):
        """
        **[Required]** Gets the vault_id of this KmsKeyVariableDependsOn.
        OCID of the Vault.


        :return: The vault_id of this KmsKeyVariableDependsOn.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this KmsKeyVariableDependsOn.
        OCID of the Vault.


        :param vault_id: The vault_id of this KmsKeyVariableDependsOn.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def protection_mode(self):
        """
        Gets the protection_mode of this KmsKeyVariableDependsOn.
        The KMS crypto protection mode string.


        :return: The protection_mode of this KmsKeyVariableDependsOn.
        :rtype: str
        """
        return self._protection_mode

    @protection_mode.setter
    def protection_mode(self, protection_mode):
        """
        Sets the protection_mode of this KmsKeyVariableDependsOn.
        The KMS crypto protection mode string.


        :param protection_mode: The protection_mode of this KmsKeyVariableDependsOn.
        :type: str
        """
        self._protection_mode = protection_mode

    @property
    def algorithm(self):
        """
        Gets the algorithm of this KmsKeyVariableDependsOn.
        Key cryptographic algorithm (RSA, AES, etc).


        :return: The algorithm of this KmsKeyVariableDependsOn.
        :rtype: str
        """
        return self._algorithm

    @algorithm.setter
    def algorithm(self, algorithm):
        """
        Sets the algorithm of this KmsKeyVariableDependsOn.
        Key cryptographic algorithm (RSA, AES, etc).


        :param algorithm: The algorithm of this KmsKeyVariableDependsOn.
        :type: str
        """
        self._algorithm = algorithm

    @property
    def length(self):
        """
        Gets the length of this KmsKeyVariableDependsOn.
        Length of the cryptographic key in bits.


        :return: The length of this KmsKeyVariableDependsOn.
        :rtype: int
        """
        return self._length

    @length.setter
    def length(self, length):
        """
        Sets the length of this KmsKeyVariableDependsOn.
        Length of the cryptographic key in bits.


        :param length: The length of this KmsKeyVariableDependsOn.
        :type: int
        """
        self._length = length

    @property
    def curve_id(self):
        """
        Gets the curve_id of this KmsKeyVariableDependsOn.
        Curve identifier for key creation.


        :return: The curve_id of this KmsKeyVariableDependsOn.
        :rtype: str
        """
        return self._curve_id

    @curve_id.setter
    def curve_id(self, curve_id):
        """
        Sets the curve_id of this KmsKeyVariableDependsOn.
        Curve identifier for key creation.


        :param curve_id: The curve_id of this KmsKeyVariableDependsOn.
        :type: str
        """
        self._curve_id = curve_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
