# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OutputGroup(object):
    """
    Output group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OutputGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param title:
            The value to assign to the title property of this OutputGroup.
        :type title: str

        :param outputs:
            The value to assign to the outputs property of this OutputGroup.
        :type outputs: list[str]

        """
        self.swagger_types = {
            'title': 'str',
            'outputs': 'list[str]'
        }
        self.attribute_map = {
            'title': 'title',
            'outputs': 'outputs'
        }
        self._title = None
        self._outputs = None

    @property
    def title(self):
        """
        **[Required]** Gets the title of this OutputGroup.
        Display name for group of outputs.


        :return: The title of this OutputGroup.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this OutputGroup.
        Display name for group of outputs.


        :param title: The title of this OutputGroup.
        :type: str
        """
        self._title = title

    @property
    def outputs(self):
        """
        **[Required]** Gets the outputs of this OutputGroup.
        Array of output strings included in group.


        :return: The outputs of this OutputGroup.
        :rtype: list[str]
        """
        return self._outputs

    @outputs.setter
    def outputs(self, outputs):
        """
        Sets the outputs of this OutputGroup.
        Array of output strings included in group.


        :param outputs: The outputs of this OutputGroup.
        :type: list[str]
        """
        self._outputs = outputs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
