# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Preferences(object):
    """
    Preferences to send notifications on the fleet activities.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Preferences object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param upcoming_schedule:
            The value to assign to the upcoming_schedule property of this Preferences.
        :type upcoming_schedule: oci.fleet_apps_management.models.UpcomingSchedule

        :param on_job_failure:
            The value to assign to the on_job_failure property of this Preferences.
        :type on_job_failure: bool

        :param on_topology_modification:
            The value to assign to the on_topology_modification property of this Preferences.
        :type on_topology_modification: bool

        :param on_task_pause:
            The value to assign to the on_task_pause property of this Preferences.
        :type on_task_pause: bool

        :param on_task_failure:
            The value to assign to the on_task_failure property of this Preferences.
        :type on_task_failure: bool

        :param on_task_success:
            The value to assign to the on_task_success property of this Preferences.
        :type on_task_success: bool

        :param on_resource_non_compliance:
            The value to assign to the on_resource_non_compliance property of this Preferences.
        :type on_resource_non_compliance: bool

        :param on_runbook_newer_version:
            The value to assign to the on_runbook_newer_version property of this Preferences.
        :type on_runbook_newer_version: bool

        :param on_job_success:
            The value to assign to the on_job_success property of this Preferences.
        :type on_job_success: bool

        :param on_job_start:
            The value to assign to the on_job_start property of this Preferences.
        :type on_job_start: bool

        :param on_job_canceled:
            The value to assign to the on_job_canceled property of this Preferences.
        :type on_job_canceled: bool

        :param on_job_schedule_change:
            The value to assign to the on_job_schedule_change property of this Preferences.
        :type on_job_schedule_change: bool

        """
        self.swagger_types = {
            'upcoming_schedule': 'UpcomingSchedule',
            'on_job_failure': 'bool',
            'on_topology_modification': 'bool',
            'on_task_pause': 'bool',
            'on_task_failure': 'bool',
            'on_task_success': 'bool',
            'on_resource_non_compliance': 'bool',
            'on_runbook_newer_version': 'bool',
            'on_job_success': 'bool',
            'on_job_start': 'bool',
            'on_job_canceled': 'bool',
            'on_job_schedule_change': 'bool'
        }
        self.attribute_map = {
            'upcoming_schedule': 'upcomingSchedule',
            'on_job_failure': 'onJobFailure',
            'on_topology_modification': 'onTopologyModification',
            'on_task_pause': 'onTaskPause',
            'on_task_failure': 'onTaskFailure',
            'on_task_success': 'onTaskSuccess',
            'on_resource_non_compliance': 'onResourceNonCompliance',
            'on_runbook_newer_version': 'onRunbookNewerVersion',
            'on_job_success': 'onJobSuccess',
            'on_job_start': 'onJobStart',
            'on_job_canceled': 'onJobCanceled',
            'on_job_schedule_change': 'onJobScheduleChange'
        }
        self._upcoming_schedule = None
        self._on_job_failure = None
        self._on_topology_modification = None
        self._on_task_pause = None
        self._on_task_failure = None
        self._on_task_success = None
        self._on_resource_non_compliance = None
        self._on_runbook_newer_version = None
        self._on_job_success = None
        self._on_job_start = None
        self._on_job_canceled = None
        self._on_job_schedule_change = None

    @property
    def upcoming_schedule(self):
        """
        Gets the upcoming_schedule of this Preferences.

        :return: The upcoming_schedule of this Preferences.
        :rtype: oci.fleet_apps_management.models.UpcomingSchedule
        """
        return self._upcoming_schedule

    @upcoming_schedule.setter
    def upcoming_schedule(self, upcoming_schedule):
        """
        Sets the upcoming_schedule of this Preferences.

        :param upcoming_schedule: The upcoming_schedule of this Preferences.
        :type: oci.fleet_apps_management.models.UpcomingSchedule
        """
        self._upcoming_schedule = upcoming_schedule

    @property
    def on_job_failure(self):
        """
        Gets the on_job_failure of this Preferences.
        Enables or disables notification on Job Failures.


        :return: The on_job_failure of this Preferences.
        :rtype: bool
        """
        return self._on_job_failure

    @on_job_failure.setter
    def on_job_failure(self, on_job_failure):
        """
        Sets the on_job_failure of this Preferences.
        Enables or disables notification on Job Failures.


        :param on_job_failure: The on_job_failure of this Preferences.
        :type: bool
        """
        self._on_job_failure = on_job_failure

    @property
    def on_topology_modification(self):
        """
        Gets the on_topology_modification of this Preferences.
        Enables or disables notification on Environment Fleet Topology Modification.


        :return: The on_topology_modification of this Preferences.
        :rtype: bool
        """
        return self._on_topology_modification

    @on_topology_modification.setter
    def on_topology_modification(self, on_topology_modification):
        """
        Sets the on_topology_modification of this Preferences.
        Enables or disables notification on Environment Fleet Topology Modification.


        :param on_topology_modification: The on_topology_modification of this Preferences.
        :type: bool
        """
        self._on_topology_modification = on_topology_modification

    @property
    def on_task_pause(self):
        """
        Gets the on_task_pause of this Preferences.
        Enables or disables notification when a task is paused.


        :return: The on_task_pause of this Preferences.
        :rtype: bool
        """
        return self._on_task_pause

    @on_task_pause.setter
    def on_task_pause(self, on_task_pause):
        """
        Sets the on_task_pause of this Preferences.
        Enables or disables notification when a task is paused.


        :param on_task_pause: The on_task_pause of this Preferences.
        :type: bool
        """
        self._on_task_pause = on_task_pause

    @property
    def on_task_failure(self):
        """
        Gets the on_task_failure of this Preferences.
        Enables or disables notification on task failure.


        :return: The on_task_failure of this Preferences.
        :rtype: bool
        """
        return self._on_task_failure

    @on_task_failure.setter
    def on_task_failure(self, on_task_failure):
        """
        Sets the on_task_failure of this Preferences.
        Enables or disables notification on task failure.


        :param on_task_failure: The on_task_failure of this Preferences.
        :type: bool
        """
        self._on_task_failure = on_task_failure

    @property
    def on_task_success(self):
        """
        Gets the on_task_success of this Preferences.
        Enables or disables notification on task success.


        :return: The on_task_success of this Preferences.
        :rtype: bool
        """
        return self._on_task_success

    @on_task_success.setter
    def on_task_success(self, on_task_success):
        """
        Sets the on_task_success of this Preferences.
        Enables or disables notification on task success.


        :param on_task_success: The on_task_success of this Preferences.
        :type: bool
        """
        self._on_task_success = on_task_success

    @property
    def on_resource_non_compliance(self):
        """
        Gets the on_resource_non_compliance of this Preferences.
        Enables or disables notification when fleet resource becomes non compliant.


        :return: The on_resource_non_compliance of this Preferences.
        :rtype: bool
        """
        return self._on_resource_non_compliance

    @on_resource_non_compliance.setter
    def on_resource_non_compliance(self, on_resource_non_compliance):
        """
        Sets the on_resource_non_compliance of this Preferences.
        Enables or disables notification when fleet resource becomes non compliant.


        :param on_resource_non_compliance: The on_resource_non_compliance of this Preferences.
        :type: bool
        """
        self._on_resource_non_compliance = on_resource_non_compliance

    @property
    def on_runbook_newer_version(self):
        """
        Gets the on_runbook_newer_version of this Preferences.
        Enables or disables notification when a newer version of runbook associated with a fleet is available


        :return: The on_runbook_newer_version of this Preferences.
        :rtype: bool
        """
        return self._on_runbook_newer_version

    @on_runbook_newer_version.setter
    def on_runbook_newer_version(self, on_runbook_newer_version):
        """
        Sets the on_runbook_newer_version of this Preferences.
        Enables or disables notification when a newer version of runbook associated with a fleet is available


        :param on_runbook_newer_version: The on_runbook_newer_version of this Preferences.
        :type: bool
        """
        self._on_runbook_newer_version = on_runbook_newer_version

    @property
    def on_job_success(self):
        """
        Gets the on_job_success of this Preferences.
        Enables or disables notification on job success.


        :return: The on_job_success of this Preferences.
        :rtype: bool
        """
        return self._on_job_success

    @on_job_success.setter
    def on_job_success(self, on_job_success):
        """
        Sets the on_job_success of this Preferences.
        Enables or disables notification on job success.


        :param on_job_success: The on_job_success of this Preferences.
        :type: bool
        """
        self._on_job_success = on_job_success

    @property
    def on_job_start(self):
        """
        Gets the on_job_start of this Preferences.
        Enables or disables notification on job start.


        :return: The on_job_start of this Preferences.
        :rtype: bool
        """
        return self._on_job_start

    @on_job_start.setter
    def on_job_start(self, on_job_start):
        """
        Sets the on_job_start of this Preferences.
        Enables or disables notification on job start.


        :param on_job_start: The on_job_start of this Preferences.
        :type: bool
        """
        self._on_job_start = on_job_start

    @property
    def on_job_canceled(self):
        """
        Gets the on_job_canceled of this Preferences.
        Enables or disables notification on job canceled.


        :return: The on_job_canceled of this Preferences.
        :rtype: bool
        """
        return self._on_job_canceled

    @on_job_canceled.setter
    def on_job_canceled(self, on_job_canceled):
        """
        Sets the on_job_canceled of this Preferences.
        Enables or disables notification on job canceled.


        :param on_job_canceled: The on_job_canceled of this Preferences.
        :type: bool
        """
        self._on_job_canceled = on_job_canceled

    @property
    def on_job_schedule_change(self):
        """
        Gets the on_job_schedule_change of this Preferences.
        Enables or disables notification on job schedule change.


        :return: The on_job_schedule_change of this Preferences.
        :rtype: bool
        """
        return self._on_job_schedule_change

    @on_job_schedule_change.setter
    def on_job_schedule_change(self, on_job_schedule_change):
        """
        Sets the on_job_schedule_change of this Preferences.
        Enables or disables notification on job schedule change.


        :param on_job_schedule_change: The on_job_schedule_change of this Preferences.
        :type: bool
        """
        self._on_job_schedule_change = on_job_schedule_change

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
