# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PreviousTaskInstanceDetails(object):
    """
    Previous Task Instance Details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PreviousTaskInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param output_variable_details:
            The value to assign to the output_variable_details property of this PreviousTaskInstanceDetails.
        :type output_variable_details: oci.fleet_apps_management.models.OutputVariableDetails

        :param resource_id:
            The value to assign to the resource_id property of this PreviousTaskInstanceDetails.
        :type resource_id: str

        :param resource_type:
            The value to assign to the resource_type property of this PreviousTaskInstanceDetails.
        :type resource_type: str

        """
        self.swagger_types = {
            'output_variable_details': 'OutputVariableDetails',
            'resource_id': 'str',
            'resource_type': 'str'
        }
        self.attribute_map = {
            'output_variable_details': 'outputVariableDetails',
            'resource_id': 'resourceId',
            'resource_type': 'resourceType'
        }
        self._output_variable_details = None
        self._resource_id = None
        self._resource_type = None

    @property
    def output_variable_details(self):
        """
        **[Required]** Gets the output_variable_details of this PreviousTaskInstanceDetails.

        :return: The output_variable_details of this PreviousTaskInstanceDetails.
        :rtype: oci.fleet_apps_management.models.OutputVariableDetails
        """
        return self._output_variable_details

    @output_variable_details.setter
    def output_variable_details(self, output_variable_details):
        """
        Sets the output_variable_details of this PreviousTaskInstanceDetails.

        :param output_variable_details: The output_variable_details of this PreviousTaskInstanceDetails.
        :type: oci.fleet_apps_management.models.OutputVariableDetails
        """
        self._output_variable_details = output_variable_details

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this PreviousTaskInstanceDetails.
        Resource Ocid.


        :return: The resource_id of this PreviousTaskInstanceDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this PreviousTaskInstanceDetails.
        Resource Ocid.


        :param resource_id: The resource_id of this PreviousTaskInstanceDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def resource_type(self):
        """
        Gets the resource_type of this PreviousTaskInstanceDetails.
        Resource Type.


        :return: The resource_type of this PreviousTaskInstanceDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this PreviousTaskInstanceDetails.
        Resource Type.


        :param resource_type: The resource_type of this PreviousTaskInstanceDetails.
        :type: str
        """
        self._resource_type = resource_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
