# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .guest_os_fleet_discovery_filter import GuestOsFleetDiscoveryFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuestOsVersionFilter(GuestOsFleetDiscoveryFilter):
    """
    Exadata Image (Guest OS) versions to include when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.
    Only versions related to the specified sourceMajorVersion are allowed.
    For example, version \"22.1.26.0.0.240801\" can be specified for sourceMajorVersion \"EXA_OL_7\" (Oracle Linux 7).
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GuestOsVersionFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.GuestOsVersionFilter.type` attribute
        of this class is ``VERSION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this GuestOsVersionFilter.
            Allowed values for this property are: "COMPARTMENT_ID", "VERSION", "EXADATA_RELEASE_VERSION", "FREEFORM_TAG", "DEFINED_TAG", "RESOURCE_ID"
        :type type: str

        :param mode:
            The value to assign to the mode property of this GuestOsVersionFilter.
            Allowed values for this property are: "INCLUDE", "EXCLUDE"
        :type mode: str

        :param versions:
            The value to assign to the versions property of this GuestOsVersionFilter.
        :type versions: list[str]

        """
        self.swagger_types = {
            'type': 'str',
            'mode': 'str',
            'versions': 'list[str]'
        }
        self.attribute_map = {
            'type': 'type',
            'mode': 'mode',
            'versions': 'versions'
        }
        self._type = None
        self._mode = None
        self._versions = None
        self._type = 'VERSION'

    @property
    def versions(self):
        """
        **[Required]** Gets the versions of this GuestOsVersionFilter.
        List of Exadata Image (Guest OS) version strings to include when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.


        :return: The versions of this GuestOsVersionFilter.
        :rtype: list[str]
        """
        return self._versions

    @versions.setter
    def versions(self, versions):
        """
        Sets the versions of this GuestOsVersionFilter.
        List of Exadata Image (Guest OS) version strings to include when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.


        :param versions: The versions of this GuestOsVersionFilter.
        :type: list[str]
        """
        self._versions = versions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
