# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PromptInjectionGuardrailConfig(object):
    """
    The configuration details for Prompt Injection.
    """

    #: A constant which can be used with the input_guardrail_mode property of a PromptInjectionGuardrailConfig.
    #: This constant has a value of "DISABLE"
    INPUT_GUARDRAIL_MODE_DISABLE = "DISABLE"

    #: A constant which can be used with the input_guardrail_mode property of a PromptInjectionGuardrailConfig.
    #: This constant has a value of "BLOCK"
    INPUT_GUARDRAIL_MODE_BLOCK = "BLOCK"

    #: A constant which can be used with the input_guardrail_mode property of a PromptInjectionGuardrailConfig.
    #: This constant has a value of "INFORM"
    INPUT_GUARDRAIL_MODE_INFORM = "INFORM"

    def __init__(self, **kwargs):
        """
        Initializes a new PromptInjectionGuardrailConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param input_guardrail_mode:
            The value to assign to the input_guardrail_mode property of this PromptInjectionGuardrailConfig.
            Allowed values for this property are: "DISABLE", "BLOCK", "INFORM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type input_guardrail_mode: str

        """
        self.swagger_types = {
            'input_guardrail_mode': 'str'
        }
        self.attribute_map = {
            'input_guardrail_mode': 'inputGuardrailMode'
        }
        self._input_guardrail_mode = None

    @property
    def input_guardrail_mode(self):
        """
        Gets the input_guardrail_mode of this PromptInjectionGuardrailConfig.
        An input guardrail mode for prompt injection.

        Allowed values for this property are: "DISABLE", "BLOCK", "INFORM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The input_guardrail_mode of this PromptInjectionGuardrailConfig.
        :rtype: str
        """
        return self._input_guardrail_mode

    @input_guardrail_mode.setter
    def input_guardrail_mode(self, input_guardrail_mode):
        """
        Sets the input_guardrail_mode of this PromptInjectionGuardrailConfig.
        An input guardrail mode for prompt injection.


        :param input_guardrail_mode: The input_guardrail_mode of this PromptInjectionGuardrailConfig.
        :type: str
        """
        allowed_values = ["DISABLE", "BLOCK", "INFORM"]
        if not value_allowed_none_or_none_sentinel(input_guardrail_mode, allowed_values):
            input_guardrail_mode = 'UNKNOWN_ENUM_VALUE'
        self._input_guardrail_mode = input_guardrail_mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
