# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GroundingMetadata(object):
    """
    Grounding metadata.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GroundingMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param web_search_queries:
            The value to assign to the web_search_queries property of this GroundingMetadata.
        :type web_search_queries: list[str]

        :param search_entry_point:
            The value to assign to the search_entry_point property of this GroundingMetadata.
        :type search_entry_point: oci.generative_ai_inference.models.SearchEntryPoint

        :param grounding_chunks:
            The value to assign to the grounding_chunks property of this GroundingMetadata.
        :type grounding_chunks: list[oci.generative_ai_inference.models.GroundingChunk]

        :param grounding_supports:
            The value to assign to the grounding_supports property of this GroundingMetadata.
        :type grounding_supports: list[oci.generative_ai_inference.models.GroundingSupport]

        """
        self.swagger_types = {
            'web_search_queries': 'list[str]',
            'search_entry_point': 'SearchEntryPoint',
            'grounding_chunks': 'list[GroundingChunk]',
            'grounding_supports': 'list[GroundingSupport]'
        }
        self.attribute_map = {
            'web_search_queries': 'webSearchQueries',
            'search_entry_point': 'searchEntryPoint',
            'grounding_chunks': 'groundingChunks',
            'grounding_supports': 'groundingSupports'
        }
        self._web_search_queries = None
        self._search_entry_point = None
        self._grounding_chunks = None
        self._grounding_supports = None

    @property
    def web_search_queries(self):
        """
        Gets the web_search_queries of this GroundingMetadata.
        The queries to be used for Search suggestions.


        :return: The web_search_queries of this GroundingMetadata.
        :rtype: list[str]
        """
        return self._web_search_queries

    @web_search_queries.setter
    def web_search_queries(self, web_search_queries):
        """
        Sets the web_search_queries of this GroundingMetadata.
        The queries to be used for Search suggestions.


        :param web_search_queries: The web_search_queries of this GroundingMetadata.
        :type: list[str]
        """
        self._web_search_queries = web_search_queries

    @property
    def search_entry_point(self):
        """
        Gets the search_entry_point of this GroundingMetadata.

        :return: The search_entry_point of this GroundingMetadata.
        :rtype: oci.generative_ai_inference.models.SearchEntryPoint
        """
        return self._search_entry_point

    @search_entry_point.setter
    def search_entry_point(self, search_entry_point):
        """
        Sets the search_entry_point of this GroundingMetadata.

        :param search_entry_point: The search_entry_point of this GroundingMetadata.
        :type: oci.generative_ai_inference.models.SearchEntryPoint
        """
        self._search_entry_point = search_entry_point

    @property
    def grounding_chunks(self):
        """
        Gets the grounding_chunks of this GroundingMetadata.
        Array of objects containing the web sources.


        :return: The grounding_chunks of this GroundingMetadata.
        :rtype: list[oci.generative_ai_inference.models.GroundingChunk]
        """
        return self._grounding_chunks

    @grounding_chunks.setter
    def grounding_chunks(self, grounding_chunks):
        """
        Sets the grounding_chunks of this GroundingMetadata.
        Array of objects containing the web sources.


        :param grounding_chunks: The grounding_chunks of this GroundingMetadata.
        :type: list[oci.generative_ai_inference.models.GroundingChunk]
        """
        self._grounding_chunks = grounding_chunks

    @property
    def grounding_supports(self):
        """
        Gets the grounding_supports of this GroundingMetadata.
        Array of chunks to connect model response text to the sources in groundingChunks.


        :return: The grounding_supports of this GroundingMetadata.
        :rtype: list[oci.generative_ai_inference.models.GroundingSupport]
        """
        return self._grounding_supports

    @grounding_supports.setter
    def grounding_supports(self, grounding_supports):
        """
        Sets the grounding_supports of this GroundingMetadata.
        Array of chunks to connect model response text to the sources in groundingChunks.


        :param grounding_supports: The grounding_supports of this GroundingMetadata.
        :type: list[oci.generative_ai_inference.models.GroundingSupport]
        """
        self._grounding_supports = grounding_supports

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
