# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuardrailConfigs(object):
    """
    Additional configuration for each guardrail.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GuardrailConfigs object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content_moderation_config:
            The value to assign to the content_moderation_config property of this GuardrailConfigs.
        :type content_moderation_config: oci.generative_ai_inference.models.ContentModerationConfiguration

        :param personally_identifiable_information_config:
            The value to assign to the personally_identifiable_information_config property of this GuardrailConfigs.
        :type personally_identifiable_information_config: oci.generative_ai_inference.models.PersonallyIdentifiableInformationConfiguration

        :param prompt_injection_config:
            The value to assign to the prompt_injection_config property of this GuardrailConfigs.
        :type prompt_injection_config: oci.generative_ai_inference.models.PromptInjectionConfiguration

        """
        self.swagger_types = {
            'content_moderation_config': 'ContentModerationConfiguration',
            'personally_identifiable_information_config': 'PersonallyIdentifiableInformationConfiguration',
            'prompt_injection_config': 'PromptInjectionConfiguration'
        }
        self.attribute_map = {
            'content_moderation_config': 'contentModerationConfig',
            'personally_identifiable_information_config': 'personallyIdentifiableInformationConfig',
            'prompt_injection_config': 'promptInjectionConfig'
        }
        self._content_moderation_config = None
        self._personally_identifiable_information_config = None
        self._prompt_injection_config = None

    @property
    def content_moderation_config(self):
        """
        Gets the content_moderation_config of this GuardrailConfigs.

        :return: The content_moderation_config of this GuardrailConfigs.
        :rtype: oci.generative_ai_inference.models.ContentModerationConfiguration
        """
        return self._content_moderation_config

    @content_moderation_config.setter
    def content_moderation_config(self, content_moderation_config):
        """
        Sets the content_moderation_config of this GuardrailConfigs.

        :param content_moderation_config: The content_moderation_config of this GuardrailConfigs.
        :type: oci.generative_ai_inference.models.ContentModerationConfiguration
        """
        self._content_moderation_config = content_moderation_config

    @property
    def personally_identifiable_information_config(self):
        """
        Gets the personally_identifiable_information_config of this GuardrailConfigs.

        :return: The personally_identifiable_information_config of this GuardrailConfigs.
        :rtype: oci.generative_ai_inference.models.PersonallyIdentifiableInformationConfiguration
        """
        return self._personally_identifiable_information_config

    @personally_identifiable_information_config.setter
    def personally_identifiable_information_config(self, personally_identifiable_information_config):
        """
        Sets the personally_identifiable_information_config of this GuardrailConfigs.

        :param personally_identifiable_information_config: The personally_identifiable_information_config of this GuardrailConfigs.
        :type: oci.generative_ai_inference.models.PersonallyIdentifiableInformationConfiguration
        """
        self._personally_identifiable_information_config = personally_identifiable_information_config

    @property
    def prompt_injection_config(self):
        """
        Gets the prompt_injection_config of this GuardrailConfigs.

        :return: The prompt_injection_config of this GuardrailConfigs.
        :rtype: oci.generative_ai_inference.models.PromptInjectionConfiguration
        """
        return self._prompt_injection_config

    @prompt_injection_config.setter
    def prompt_injection_config(self, prompt_injection_config):
        """
        Sets the prompt_injection_config of this GuardrailConfigs.

        :param prompt_injection_config: The prompt_injection_config of this GuardrailConfigs.
        :type: oci.generative_ai_inference.models.PromptInjectionConfiguration
        """
        self._prompt_injection_config = prompt_injection_config

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
