# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DeploymentPeerSummary(object):
    """
    The summary of the deployment Peer.
    """

    #: A constant which can be used with the peer_type property of a DeploymentPeerSummary.
    #: This constant has a value of "LOCAL"
    PEER_TYPE_LOCAL = "LOCAL"

    #: A constant which can be used with the peer_type property of a DeploymentPeerSummary.
    #: This constant has a value of "REMOTE"
    PEER_TYPE_REMOTE = "REMOTE"

    #: A constant which can be used with the peer_role property of a DeploymentPeerSummary.
    #: This constant has a value of "PRIMARY"
    PEER_ROLE_PRIMARY = "PRIMARY"

    #: A constant which can be used with the peer_role property of a DeploymentPeerSummary.
    #: This constant has a value of "STANDBY"
    PEER_ROLE_STANDBY = "STANDBY"

    #: A constant which can be used with the lifecycle_state property of a DeploymentPeerSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DeploymentPeerSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DeploymentPeerSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a DeploymentPeerSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a DeploymentPeerSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    def __init__(self, **kwargs):
        """
        Initializes a new DeploymentPeerSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param deployment_id:
            The value to assign to the deployment_id property of this DeploymentPeerSummary.
        :type deployment_id: str

        :param region:
            The value to assign to the region property of this DeploymentPeerSummary.
        :type region: str

        :param availability_domain:
            The value to assign to the availability_domain property of this DeploymentPeerSummary.
        :type availability_domain: str

        :param fault_domain:
            The value to assign to the fault_domain property of this DeploymentPeerSummary.
        :type fault_domain: str

        :param display_name:
            The value to assign to the display_name property of this DeploymentPeerSummary.
        :type display_name: str

        :param peer_type:
            The value to assign to the peer_type property of this DeploymentPeerSummary.
            Allowed values for this property are: "LOCAL", "REMOTE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type peer_type: str

        :param peer_role:
            The value to assign to the peer_role property of this DeploymentPeerSummary.
            Allowed values for this property are: "PRIMARY", "STANDBY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type peer_role: str

        :param time_created:
            The value to assign to the time_created property of this DeploymentPeerSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DeploymentPeerSummary.
        :type time_updated: datetime

        :param time_role_changed:
            The value to assign to the time_role_changed property of this DeploymentPeerSummary.
        :type time_role_changed: datetime

        :param time_last_synced:
            The value to assign to the time_last_synced property of this DeploymentPeerSummary.
        :type time_last_synced: datetime

        :param subscription_id:
            The value to assign to the subscription_id property of this DeploymentPeerSummary.
        :type subscription_id: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this DeploymentPeerSummary.
        :type cluster_placement_group_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DeploymentPeerSummary.
            Allowed values for this property are: "CREATING", "ACTIVE", "FAILED", "UPDATING", "DELETING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'deployment_id': 'str',
            'region': 'str',
            'availability_domain': 'str',
            'fault_domain': 'str',
            'display_name': 'str',
            'peer_type': 'str',
            'peer_role': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_role_changed': 'datetime',
            'time_last_synced': 'datetime',
            'subscription_id': 'str',
            'cluster_placement_group_id': 'str',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'deployment_id': 'deploymentId',
            'region': 'region',
            'availability_domain': 'availabilityDomain',
            'fault_domain': 'faultDomain',
            'display_name': 'displayName',
            'peer_type': 'peerType',
            'peer_role': 'peerRole',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_role_changed': 'timeRoleChanged',
            'time_last_synced': 'timeLastSynced',
            'subscription_id': 'subscriptionId',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'lifecycle_state': 'lifecycleState'
        }
        self._deployment_id = None
        self._region = None
        self._availability_domain = None
        self._fault_domain = None
        self._display_name = None
        self._peer_type = None
        self._peer_role = None
        self._time_created = None
        self._time_updated = None
        self._time_role_changed = None
        self._time_last_synced = None
        self._subscription_id = None
        self._cluster_placement_group_id = None
        self._lifecycle_state = None

    @property
    def deployment_id(self):
        """
        **[Required]** Gets the deployment_id of this DeploymentPeerSummary.
        The `OCID`__ of the deployment being referenced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The deployment_id of this DeploymentPeerSummary.
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id):
        """
        Sets the deployment_id of this DeploymentPeerSummary.
        The `OCID`__ of the deployment being referenced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param deployment_id: The deployment_id of this DeploymentPeerSummary.
        :type: str
        """
        self._deployment_id = deployment_id

    @property
    def region(self):
        """
        **[Required]** Gets the region of this DeploymentPeerSummary.
        The name of the region. e.g.: us-ashburn-1
        If the region is not provided, backend will default to the default region.


        :return: The region of this DeploymentPeerSummary.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this DeploymentPeerSummary.
        The name of the region. e.g.: us-ashburn-1
        If the region is not provided, backend will default to the default region.


        :param region: The region of this DeploymentPeerSummary.
        :type: str
        """
        self._region = region

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this DeploymentPeerSummary.
        The availability domain of a placement.


        :return: The availability_domain of this DeploymentPeerSummary.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this DeploymentPeerSummary.
        The availability domain of a placement.


        :param availability_domain: The availability_domain of this DeploymentPeerSummary.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def fault_domain(self):
        """
        **[Required]** Gets the fault_domain of this DeploymentPeerSummary.
        The fault domain of a placement.


        :return: The fault_domain of this DeploymentPeerSummary.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this DeploymentPeerSummary.
        The fault domain of a placement.


        :param fault_domain: The fault_domain of this DeploymentPeerSummary.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DeploymentPeerSummary.
        An object's Display Name.


        :return: The display_name of this DeploymentPeerSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DeploymentPeerSummary.
        An object's Display Name.


        :param display_name: The display_name of this DeploymentPeerSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def peer_type(self):
        """
        **[Required]** Gets the peer_type of this DeploymentPeerSummary.
        The type of the deployment peer.

        Allowed values for this property are: "LOCAL", "REMOTE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The peer_type of this DeploymentPeerSummary.
        :rtype: str
        """
        return self._peer_type

    @peer_type.setter
    def peer_type(self, peer_type):
        """
        Sets the peer_type of this DeploymentPeerSummary.
        The type of the deployment peer.


        :param peer_type: The peer_type of this DeploymentPeerSummary.
        :type: str
        """
        allowed_values = ["LOCAL", "REMOTE"]
        if not value_allowed_none_or_none_sentinel(peer_type, allowed_values):
            peer_type = 'UNKNOWN_ENUM_VALUE'
        self._peer_type = peer_type

    @property
    def peer_role(self):
        """
        **[Required]** Gets the peer_role of this DeploymentPeerSummary.
        The type of the deployment role.

        Allowed values for this property are: "PRIMARY", "STANDBY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The peer_role of this DeploymentPeerSummary.
        :rtype: str
        """
        return self._peer_role

    @peer_role.setter
    def peer_role(self, peer_role):
        """
        Sets the peer_role of this DeploymentPeerSummary.
        The type of the deployment role.


        :param peer_role: The peer_role of this DeploymentPeerSummary.
        :type: str
        """
        allowed_values = ["PRIMARY", "STANDBY"]
        if not value_allowed_none_or_none_sentinel(peer_role, allowed_values):
            peer_role = 'UNKNOWN_ENUM_VALUE'
        self._peer_role = peer_role

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DeploymentPeerSummary.
        The time the resource was created. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this DeploymentPeerSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DeploymentPeerSummary.
        The time the resource was created. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this DeploymentPeerSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DeploymentPeerSummary.
        The time the resource was last updated. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this DeploymentPeerSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DeploymentPeerSummary.
        The time the resource was last updated. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this DeploymentPeerSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_role_changed(self):
        """
        **[Required]** Gets the time_role_changed of this DeploymentPeerSummary.
        The time of the last role change. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_role_changed of this DeploymentPeerSummary.
        :rtype: datetime
        """
        return self._time_role_changed

    @time_role_changed.setter
    def time_role_changed(self, time_role_changed):
        """
        Sets the time_role_changed of this DeploymentPeerSummary.
        The time of the last role change. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param time_role_changed: The time_role_changed of this DeploymentPeerSummary.
        :type: datetime
        """
        self._time_role_changed = time_role_changed

    @property
    def time_last_synced(self):
        """
        Gets the time_last_synced of this DeploymentPeerSummary.
        The time of the last data synchronization from the primary to the standby peer.
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_last_synced of this DeploymentPeerSummary.
        :rtype: datetime
        """
        return self._time_last_synced

    @time_last_synced.setter
    def time_last_synced(self, time_last_synced):
        """
        Sets the time_last_synced of this DeploymentPeerSummary.
        The time of the last data synchronization from the primary to the standby peer.
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param time_last_synced: The time_last_synced of this DeploymentPeerSummary.
        :type: datetime
        """
        self._time_last_synced = time_last_synced

    @property
    def subscription_id(self):
        """
        Gets the subscription_id of this DeploymentPeerSummary.
        The `OCID`__ of the subscription with which resource needs to be associated with.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subscription_id of this DeploymentPeerSummary.
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """
        Sets the subscription_id of this DeploymentPeerSummary.
        The `OCID`__ of the subscription with which resource needs to be associated with.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subscription_id: The subscription_id of this DeploymentPeerSummary.
        :type: str
        """
        self._subscription_id = subscription_id

    @property
    def cluster_placement_group_id(self):
        """
        Gets the cluster_placement_group_id of this DeploymentPeerSummary.
        The OCID(/Content/General/Concepts/identifiers.htm) of the cluster placement group for the resource.
        Only applicable for multicloud subscriptions. The cluster placement group id must be provided when a multicloud
        subscription id is provided. Otherwise the cluster placement group must not be provided.


        :return: The cluster_placement_group_id of this DeploymentPeerSummary.
        :rtype: str
        """
        return self._cluster_placement_group_id

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, cluster_placement_group_id):
        """
        Sets the cluster_placement_group_id of this DeploymentPeerSummary.
        The OCID(/Content/General/Concepts/identifiers.htm) of the cluster placement group for the resource.
        Only applicable for multicloud subscriptions. The cluster placement group id must be provided when a multicloud
        subscription id is provided. Otherwise the cluster placement group must not be provided.


        :param cluster_placement_group_id: The cluster_placement_group_id of this DeploymentPeerSummary.
        :type: str
        """
        self._cluster_placement_group_id = cluster_placement_group_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DeploymentPeerSummary.
        Possible lifecycle states for deployment peer.

        Allowed values for this property are: "CREATING", "ACTIVE", "FAILED", "UPDATING", "DELETING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DeploymentPeerSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DeploymentPeerSummary.
        Possible lifecycle states for deployment peer.


        :param lifecycle_state: The lifecycle_state of this DeploymentPeerSummary.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "FAILED", "UPDATING", "DELETING"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
