# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PipelineDiagnosticData(object):
    """
    Information regarding the pipeline diagnostic collection
    """

    #: A constant which can be used with the diagnostic_state property of a PipelineDiagnosticData.
    #: This constant has a value of "IN_PROGRESS"
    DIAGNOSTIC_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the diagnostic_state property of a PipelineDiagnosticData.
    #: This constant has a value of "SUCCEEDED"
    DIAGNOSTIC_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the diagnostic_state property of a PipelineDiagnosticData.
    #: This constant has a value of "FAILED"
    DIAGNOSTIC_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new PipelineDiagnosticData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param namespace_name:
            The value to assign to the namespace_name property of this PipelineDiagnosticData.
        :type namespace_name: str

        :param bucket_name:
            The value to assign to the bucket_name property of this PipelineDiagnosticData.
        :type bucket_name: str

        :param object_name:
            The value to assign to the object_name property of this PipelineDiagnosticData.
        :type object_name: str

        :param diagnostic_state:
            The value to assign to the diagnostic_state property of this PipelineDiagnosticData.
            Allowed values for this property are: "IN_PROGRESS", "SUCCEEDED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type diagnostic_state: str

        :param time_last_collected:
            The value to assign to the time_last_collected property of this PipelineDiagnosticData.
        :type time_last_collected: datetime

        """
        self.swagger_types = {
            'namespace_name': 'str',
            'bucket_name': 'str',
            'object_name': 'str',
            'diagnostic_state': 'str',
            'time_last_collected': 'datetime'
        }
        self.attribute_map = {
            'namespace_name': 'namespaceName',
            'bucket_name': 'bucketName',
            'object_name': 'objectName',
            'diagnostic_state': 'diagnosticState',
            'time_last_collected': 'timeLastCollected'
        }
        self._namespace_name = None
        self._bucket_name = None
        self._object_name = None
        self._diagnostic_state = None
        self._time_last_collected = None

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this PipelineDiagnosticData.
        Name of namespace that serves as a container for all of your buckets


        :return: The namespace_name of this PipelineDiagnosticData.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this PipelineDiagnosticData.
        Name of namespace that serves as a container for all of your buckets


        :param namespace_name: The namespace_name of this PipelineDiagnosticData.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this PipelineDiagnosticData.
        Name of the bucket where the object is to be uploaded in the object storage


        :return: The bucket_name of this PipelineDiagnosticData.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this PipelineDiagnosticData.
        Name of the bucket where the object is to be uploaded in the object storage


        :param bucket_name: The bucket_name of this PipelineDiagnosticData.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def object_name(self):
        """
        **[Required]** Gets the object_name of this PipelineDiagnosticData.
        Name of the diagnostic collected and uploaded to object storage


        :return: The object_name of this PipelineDiagnosticData.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this PipelineDiagnosticData.
        Name of the diagnostic collected and uploaded to object storage


        :param object_name: The object_name of this PipelineDiagnosticData.
        :type: str
        """
        self._object_name = object_name

    @property
    def diagnostic_state(self):
        """
        **[Required]** Gets the diagnostic_state of this PipelineDiagnosticData.
        The state of the pipeline diagnostics collection.

        Allowed values for this property are: "IN_PROGRESS", "SUCCEEDED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The diagnostic_state of this PipelineDiagnosticData.
        :rtype: str
        """
        return self._diagnostic_state

    @diagnostic_state.setter
    def diagnostic_state(self, diagnostic_state):
        """
        Sets the diagnostic_state of this PipelineDiagnosticData.
        The state of the pipeline diagnostics collection.


        :param diagnostic_state: The diagnostic_state of this PipelineDiagnosticData.
        :type: str
        """
        allowed_values = ["IN_PROGRESS", "SUCCEEDED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(diagnostic_state, allowed_values):
            diagnostic_state = 'UNKNOWN_ENUM_VALUE'
        self._diagnostic_state = diagnostic_state

    @property
    def time_last_collected(self):
        """
        Gets the time_last_collected of this PipelineDiagnosticData.
        The date and time the diagnostic data was last collected for the pipeline. The format is defined by
        `RFC3339`__, such as `2024-07-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_last_collected of this PipelineDiagnosticData.
        :rtype: datetime
        """
        return self._time_last_collected

    @time_last_collected.setter
    def time_last_collected(self, time_last_collected):
        """
        Sets the time_last_collected of this PipelineDiagnosticData.
        The date and time the diagnostic data was last collected for the pipeline. The format is defined by
        `RFC3339`__, such as `2024-07-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param time_last_collected: The time_last_collected of this PipelineDiagnosticData.
        :type: datetime
        """
        self._time_last_collected = time_last_collected

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
