# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PipelineInitializationStep(object):
    """
    The step and its progress based on the recipe type.
    """

    #: A constant which can be used with the status property of a PipelineInitializationStep.
    #: This constant has a value of "PENDING"
    STATUS_PENDING = "PENDING"

    #: A constant which can be used with the status property of a PipelineInitializationStep.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a PipelineInitializationStep.
    #: This constant has a value of "COMPLETED"
    STATUS_COMPLETED = "COMPLETED"

    #: A constant which can be used with the status property of a PipelineInitializationStep.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new PipelineInitializationStep object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this PipelineInitializationStep.
        :type name: str

        :param status:
            The value to assign to the status property of this PipelineInitializationStep.
            Allowed values for this property are: "PENDING", "IN_PROGRESS", "COMPLETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param percent_complete:
            The value to assign to the percent_complete property of this PipelineInitializationStep.
        :type percent_complete: int

        :param time_started:
            The value to assign to the time_started property of this PipelineInitializationStep.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this PipelineInitializationStep.
        :type time_finished: datetime

        :param messages:
            The value to assign to the messages property of this PipelineInitializationStep.
        :type messages: list[oci.golden_gate.models.StepMessage]

        """
        self.swagger_types = {
            'name': 'str',
            'status': 'str',
            'percent_complete': 'int',
            'time_started': 'datetime',
            'time_finished': 'datetime',
            'messages': 'list[StepMessage]'
        }
        self.attribute_map = {
            'name': 'name',
            'status': 'status',
            'percent_complete': 'percentComplete',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished',
            'messages': 'messages'
        }
        self._name = None
        self._status = None
        self._percent_complete = None
        self._time_started = None
        self._time_finished = None
        self._messages = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this PipelineInitializationStep.
        An object's Display Name.


        :return: The name of this PipelineInitializationStep.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PipelineInitializationStep.
        An object's Display Name.


        :param name: The name of this PipelineInitializationStep.
        :type: str
        """
        self._name = name

    @property
    def status(self):
        """
        **[Required]** Gets the status of this PipelineInitializationStep.
        Status of the steps in a recipe. This option applies during pipeline initialization.

        Allowed values for this property are: "PENDING", "IN_PROGRESS", "COMPLETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this PipelineInitializationStep.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this PipelineInitializationStep.
        Status of the steps in a recipe. This option applies during pipeline initialization.


        :param status: The status of this PipelineInitializationStep.
        :type: str
        """
        allowed_values = ["PENDING", "IN_PROGRESS", "COMPLETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def percent_complete(self):
        """
        **[Required]** Gets the percent_complete of this PipelineInitializationStep.
        Shows the percentage complete of each recipe step during pipeline initialization.


        :return: The percent_complete of this PipelineInitializationStep.
        :rtype: int
        """
        return self._percent_complete

    @percent_complete.setter
    def percent_complete(self, percent_complete):
        """
        Sets the percent_complete of this PipelineInitializationStep.
        Shows the percentage complete of each recipe step during pipeline initialization.


        :param percent_complete: The percent_complete of this PipelineInitializationStep.
        :type: int
        """
        self._percent_complete = percent_complete

    @property
    def time_started(self):
        """
        **[Required]** Gets the time_started of this PipelineInitializationStep.
        The date and time the request was started. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_started of this PipelineInitializationStep.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this PipelineInitializationStep.
        The date and time the request was started. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param time_started: The time_started of this PipelineInitializationStep.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        **[Required]** Gets the time_finished of this PipelineInitializationStep.
        The date and time the request was finished. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_finished of this PipelineInitializationStep.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this PipelineInitializationStep.
        The date and time the request was finished. The format is defined by
        `RFC3339`__, such as `2016-08-25T21:10:29.600Z`.

        __ https://tools.ietf.org/html/rfc3339


        :param time_finished: The time_finished of this PipelineInitializationStep.
        :type: datetime
        """
        self._time_finished = time_finished

    @property
    def messages(self):
        """
        Gets the messages of this PipelineInitializationStep.
        The list of messages for each step while running.


        :return: The messages of this PipelineInitializationStep.
        :rtype: list[oci.golden_gate.models.StepMessage]
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """
        Sets the messages of this PipelineInitializationStep.
        The list of messages for each step while running.


        :param messages: The messages of this PipelineInitializationStep.
        :type: list[oci.golden_gate.models.StepMessage]
        """
        self._messages = messages

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
