# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250521


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SubscriptionAcknowledgmentConfiguration(object):
    """
    The configuration for subscription acknowledgment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SubscriptionAcknowledgmentConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_acknowledged:
            The value to assign to the is_acknowledged property of this SubscriptionAcknowledgmentConfiguration.
        :type is_acknowledged: bool

        :param acknowledged_by:
            The value to assign to the acknowledged_by property of this SubscriptionAcknowledgmentConfiguration.
        :type acknowledged_by: str

        :param time_acknowledged:
            The value to assign to the time_acknowledged property of this SubscriptionAcknowledgmentConfiguration.
        :type time_acknowledged: datetime

        """
        self.swagger_types = {
            'is_acknowledged': 'bool',
            'acknowledged_by': 'str',
            'time_acknowledged': 'datetime'
        }
        self.attribute_map = {
            'is_acknowledged': 'isAcknowledged',
            'acknowledged_by': 'acknowledgedBy',
            'time_acknowledged': 'timeAcknowledged'
        }
        self._is_acknowledged = None
        self._acknowledged_by = None
        self._time_acknowledged = None

    @property
    def is_acknowledged(self):
        """
        **[Required]** Gets the is_acknowledged of this SubscriptionAcknowledgmentConfiguration.
        Flag to determine whether the subscription was acknowledged or not.


        :return: The is_acknowledged of this SubscriptionAcknowledgmentConfiguration.
        :rtype: bool
        """
        return self._is_acknowledged

    @is_acknowledged.setter
    def is_acknowledged(self, is_acknowledged):
        """
        Sets the is_acknowledged of this SubscriptionAcknowledgmentConfiguration.
        Flag to determine whether the subscription was acknowledged or not.


        :param is_acknowledged: The is_acknowledged of this SubscriptionAcknowledgmentConfiguration.
        :type: bool
        """
        self._is_acknowledged = is_acknowledged

    @property
    def acknowledged_by(self):
        """
        Gets the acknowledged_by of this SubscriptionAcknowledgmentConfiguration.
        The `OCID`__ of the principal that ackwnoledged the subscription.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The acknowledged_by of this SubscriptionAcknowledgmentConfiguration.
        :rtype: str
        """
        return self._acknowledged_by

    @acknowledged_by.setter
    def acknowledged_by(self, acknowledged_by):
        """
        Sets the acknowledged_by of this SubscriptionAcknowledgmentConfiguration.
        The `OCID`__ of the principal that ackwnoledged the subscription.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param acknowledged_by: The acknowledged_by of this SubscriptionAcknowledgmentConfiguration.
        :type: str
        """
        self._acknowledged_by = acknowledged_by

    @property
    def time_acknowledged(self):
        """
        Gets the time_acknowledged of this SubscriptionAcknowledgmentConfiguration.
        The date and time the subscription was acknowledged (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_acknowledged of this SubscriptionAcknowledgmentConfiguration.
        :rtype: datetime
        """
        return self._time_acknowledged

    @time_acknowledged.setter
    def time_acknowledged(self, time_acknowledged):
        """
        Sets the time_acknowledged of this SubscriptionAcknowledgmentConfiguration.
        The date and time the subscription was acknowledged (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_acknowledged: The time_acknowledged of this SubscriptionAcknowledgmentConfiguration.
        :type: datetime
        """
        self._time_acknowledged = time_acknowledged

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
