# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PricingPlan(object):
    """
    A pricing plan provided by the Publisher.
    """

    #: A constant which can be used with the plan_type property of a PricingPlan.
    #: This constant has a value of "METERED"
    PLAN_TYPE_METERED = "METERED"

    #: A constant which can be used with the plan_type property of a PricingPlan.
    #: This constant has a value of "FIXED"
    PLAN_TYPE_FIXED = "FIXED"

    def __init__(self, **kwargs):
        """
        Initializes a new PricingPlan object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.marketplace_publisher.models.MeteredPricingPlan`
        * :class:`~oci.marketplace_publisher.models.SaaSPricingPlan`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param plan_type:
            The value to assign to the plan_type property of this PricingPlan.
            Allowed values for this property are: "METERED", "FIXED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type plan_type: str

        :param rates:
            The value to assign to the rates property of this PricingPlan.
        :type rates: list[oci.marketplace_publisher.models.PricingRate]

        """
        self.swagger_types = {
            'plan_type': 'str',
            'rates': 'list[PricingRate]'
        }
        self.attribute_map = {
            'plan_type': 'planType',
            'rates': 'rates'
        }
        self._plan_type = None
        self._rates = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['planType']

        if type == 'METERED':
            return 'MeteredPricingPlan'

        if type == 'FIXED':
            return 'SaaSPricingPlan'
        else:
            return 'PricingPlan'

    @property
    def plan_type(self):
        """
        **[Required]** Gets the plan_type of this PricingPlan.
        The listing's pricing plan type.

        Allowed values for this property are: "METERED", "FIXED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The plan_type of this PricingPlan.
        :rtype: str
        """
        return self._plan_type

    @plan_type.setter
    def plan_type(self, plan_type):
        """
        Sets the plan_type of this PricingPlan.
        The listing's pricing plan type.


        :param plan_type: The plan_type of this PricingPlan.
        :type: str
        """
        allowed_values = ["METERED", "FIXED"]
        if not value_allowed_none_or_none_sentinel(plan_type, allowed_values):
            plan_type = 'UNKNOWN_ENUM_VALUE'
        self._plan_type = plan_type

    @property
    def rates(self):
        """
        **[Required]** Gets the rates of this PricingPlan.
        List of pricing rates provider by publisher.


        :return: The rates of this PricingPlan.
        :rtype: list[oci.marketplace_publisher.models.PricingRate]
        """
        return self._rates

    @rates.setter
    def rates(self, rates):
        """
        Sets the rates of this PricingPlan.
        List of pricing rates provider by publisher.


        :param rates: The rates of this PricingPlan.
        :type: list[oci.marketplace_publisher.models.PricingRate]
        """
        self._rates = rates

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
