# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SubmitListingRevisionForReviewDetails(object):
    """
    The model for an Oracle Cloud Infrastructure Marketplace Publisher review listing revision.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SubmitListingRevisionForReviewDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param note_details:
            The value to assign to the note_details property of this SubmitListingRevisionForReviewDetails.
        :type note_details: str

        :param are_internal_tenancy_launch_allowed:
            The value to assign to the are_internal_tenancy_launch_allowed property of this SubmitListingRevisionForReviewDetails.
        :type are_internal_tenancy_launch_allowed: bool

        :param should_auto_publish_on_approval:
            The value to assign to the should_auto_publish_on_approval property of this SubmitListingRevisionForReviewDetails.
        :type should_auto_publish_on_approval: bool

        """
        self.swagger_types = {
            'note_details': 'str',
            'are_internal_tenancy_launch_allowed': 'bool',
            'should_auto_publish_on_approval': 'bool'
        }
        self.attribute_map = {
            'note_details': 'noteDetails',
            'are_internal_tenancy_launch_allowed': 'areInternalTenancyLaunchAllowed',
            'should_auto_publish_on_approval': 'shouldAutoPublishOnApproval'
        }
        self._note_details = None
        self._are_internal_tenancy_launch_allowed = None
        self._should_auto_publish_on_approval = None

    @property
    def note_details(self):
        """
        Gets the note_details of this SubmitListingRevisionForReviewDetails.
        Notes provided for the listing revision.


        :return: The note_details of this SubmitListingRevisionForReviewDetails.
        :rtype: str
        """
        return self._note_details

    @note_details.setter
    def note_details(self, note_details):
        """
        Sets the note_details of this SubmitListingRevisionForReviewDetails.
        Notes provided for the listing revision.


        :param note_details: The note_details of this SubmitListingRevisionForReviewDetails.
        :type: str
        """
        self._note_details = note_details

    @property
    def are_internal_tenancy_launch_allowed(self):
        """
        Gets the are_internal_tenancy_launch_allowed of this SubmitListingRevisionForReviewDetails.
        Identifies whether publisher allows internal tenancy launches for the listing revision.


        :return: The are_internal_tenancy_launch_allowed of this SubmitListingRevisionForReviewDetails.
        :rtype: bool
        """
        return self._are_internal_tenancy_launch_allowed

    @are_internal_tenancy_launch_allowed.setter
    def are_internal_tenancy_launch_allowed(self, are_internal_tenancy_launch_allowed):
        """
        Sets the are_internal_tenancy_launch_allowed of this SubmitListingRevisionForReviewDetails.
        Identifies whether publisher allows internal tenancy launches for the listing revision.


        :param are_internal_tenancy_launch_allowed: The are_internal_tenancy_launch_allowed of this SubmitListingRevisionForReviewDetails.
        :type: bool
        """
        self._are_internal_tenancy_launch_allowed = are_internal_tenancy_launch_allowed

    @property
    def should_auto_publish_on_approval(self):
        """
        Gets the should_auto_publish_on_approval of this SubmitListingRevisionForReviewDetails.
        Identifies whether publisher intends to publish the listing automatically upon approval.


        :return: The should_auto_publish_on_approval of this SubmitListingRevisionForReviewDetails.
        :rtype: bool
        """
        return self._should_auto_publish_on_approval

    @should_auto_publish_on_approval.setter
    def should_auto_publish_on_approval(self, should_auto_publish_on_approval):
        """
        Sets the should_auto_publish_on_approval of this SubmitListingRevisionForReviewDetails.
        Identifies whether publisher intends to publish the listing automatically upon approval.


        :param should_auto_publish_on_approval: The should_auto_publish_on_approval of this SubmitListingRevisionForReviewDetails.
        :type: bool
        """
        self._should_auto_publish_on_approval = should_auto_publish_on_approval

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
