# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NetworkAnchor(object):
    """
    A NetworkAnchor is a description of a NetworkAnchor.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the network_anchor_lifecycle_state property of a NetworkAnchor.
    #: This constant has a value of "CREATING"
    NETWORK_ANCHOR_LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the network_anchor_lifecycle_state property of a NetworkAnchor.
    #: This constant has a value of "UPDATING"
    NETWORK_ANCHOR_LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the network_anchor_lifecycle_state property of a NetworkAnchor.
    #: This constant has a value of "ACTIVE"
    NETWORK_ANCHOR_LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the network_anchor_lifecycle_state property of a NetworkAnchor.
    #: This constant has a value of "DELETING"
    NETWORK_ANCHOR_LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the network_anchor_lifecycle_state property of a NetworkAnchor.
    #: This constant has a value of "DELETED"
    NETWORK_ANCHOR_LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the network_anchor_lifecycle_state property of a NetworkAnchor.
    #: This constant has a value of "FAILED"
    NETWORK_ANCHOR_LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the setup_mode property of a NetworkAnchor.
    #: This constant has a value of "AUTO_BIND"
    SETUP_MODE_AUTO_BIND = "AUTO_BIND"

    #: A constant which can be used with the setup_mode property of a NetworkAnchor.
    #: This constant has a value of "NO_AUTO_BIND"
    SETUP_MODE_NO_AUTO_BIND = "NO_AUTO_BIND"

    #: A constant which can be used with the subscription_type property of a NetworkAnchor.
    #: This constant has a value of "ORACLEDBATAZURE"
    SUBSCRIPTION_TYPE_ORACLEDBATAZURE = "ORACLEDBATAZURE"

    #: A constant which can be used with the subscription_type property of a NetworkAnchor.
    #: This constant has a value of "ORACLEDBATGOOGLE"
    SUBSCRIPTION_TYPE_ORACLEDBATGOOGLE = "ORACLEDBATGOOGLE"

    #: A constant which can be used with the subscription_type property of a NetworkAnchor.
    #: This constant has a value of "ORACLEDBATAWS"
    SUBSCRIPTION_TYPE_ORACLEDBATAWS = "ORACLEDBATAWS"

    def __init__(self, **kwargs):
        """
        Initializes a new NetworkAnchor object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this NetworkAnchor.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this NetworkAnchor.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this NetworkAnchor.
        :type compartment_id: str

        :param resource_anchor_id:
            The value to assign to the resource_anchor_id property of this NetworkAnchor.
        :type resource_anchor_id: str

        :param time_created:
            The value to assign to the time_created property of this NetworkAnchor.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this NetworkAnchor.
        :type time_updated: datetime

        :param network_anchor_lifecycle_state:
            The value to assign to the network_anchor_lifecycle_state property of this NetworkAnchor.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type network_anchor_lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this NetworkAnchor.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this NetworkAnchor.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this NetworkAnchor.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this NetworkAnchor.
        :type system_tags: dict(str, dict(str, object))

        :param setup_mode:
            The value to assign to the setup_mode property of this NetworkAnchor.
            Allowed values for this property are: "AUTO_BIND", "NO_AUTO_BIND", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type setup_mode: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this NetworkAnchor.
        :type cluster_placement_group_id: str

        :param oci_metadata_item:
            The value to assign to the oci_metadata_item property of this NetworkAnchor.
        :type oci_metadata_item: oci.multicloud.models.OciNetworkMetadata

        :param cloud_service_provider_metadata_item:
            The value to assign to the cloud_service_provider_metadata_item property of this NetworkAnchor.
        :type cloud_service_provider_metadata_item: oci.multicloud.models.CloudServiceProviderNetworkMetadataItem

        :param subscription_type:
            The value to assign to the subscription_type property of this NetworkAnchor.
            Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type subscription_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'resource_anchor_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'network_anchor_lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'setup_mode': 'str',
            'cluster_placement_group_id': 'str',
            'oci_metadata_item': 'OciNetworkMetadata',
            'cloud_service_provider_metadata_item': 'CloudServiceProviderNetworkMetadataItem',
            'subscription_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'resource_anchor_id': 'resourceAnchorId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'network_anchor_lifecycle_state': 'networkAnchorLifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'setup_mode': 'setupMode',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'oci_metadata_item': 'ociMetadataItem',
            'cloud_service_provider_metadata_item': 'cloudServiceProviderMetadataItem',
            'subscription_type': 'subscriptionType'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._resource_anchor_id = None
        self._time_created = None
        self._time_updated = None
        self._network_anchor_lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._setup_mode = None
        self._cluster_placement_group_id = None
        self._oci_metadata_item = None
        self._cloud_service_provider_metadata_item = None
        self._subscription_type = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this NetworkAnchor.
        The `OCID`__ of the NetworkAnchor.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this NetworkAnchor.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NetworkAnchor.
        The `OCID`__ of the NetworkAnchor.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this NetworkAnchor.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this NetworkAnchor.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this NetworkAnchor.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this NetworkAnchor.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this NetworkAnchor.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this NetworkAnchor.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this NetworkAnchor.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this NetworkAnchor.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this NetworkAnchor.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_anchor_id(self):
        """
        **[Required]** Gets the resource_anchor_id of this NetworkAnchor.
        OCI resource anchor Id (OCID).


        :return: The resource_anchor_id of this NetworkAnchor.
        :rtype: str
        """
        return self._resource_anchor_id

    @resource_anchor_id.setter
    def resource_anchor_id(self, resource_anchor_id):
        """
        Sets the resource_anchor_id of this NetworkAnchor.
        OCI resource anchor Id (OCID).


        :param resource_anchor_id: The resource_anchor_id of this NetworkAnchor.
        :type: str
        """
        self._resource_anchor_id = resource_anchor_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this NetworkAnchor.
        The date and time the NetworkAnchor was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this NetworkAnchor.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this NetworkAnchor.
        The date and time the NetworkAnchor was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this NetworkAnchor.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this NetworkAnchor.
        The date and time the NetworkAnchor was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this NetworkAnchor.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this NetworkAnchor.
        The date and time the NetworkAnchor was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this NetworkAnchor.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def network_anchor_lifecycle_state(self):
        """
        **[Required]** Gets the network_anchor_lifecycle_state of this NetworkAnchor.
        The current state of the NetworkAnchor.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The network_anchor_lifecycle_state of this NetworkAnchor.
        :rtype: str
        """
        return self._network_anchor_lifecycle_state

    @network_anchor_lifecycle_state.setter
    def network_anchor_lifecycle_state(self, network_anchor_lifecycle_state):
        """
        Sets the network_anchor_lifecycle_state of this NetworkAnchor.
        The current state of the NetworkAnchor.


        :param network_anchor_lifecycle_state: The network_anchor_lifecycle_state of this NetworkAnchor.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(network_anchor_lifecycle_state, allowed_values):
            network_anchor_lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._network_anchor_lifecycle_state = network_anchor_lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this NetworkAnchor.
        A message that describes the current state of the NetworkAnchor in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this NetworkAnchor.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this NetworkAnchor.
        A message that describes the current state of the NetworkAnchor in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this NetworkAnchor.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this NetworkAnchor.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this NetworkAnchor.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this NetworkAnchor.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this NetworkAnchor.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this NetworkAnchor.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this NetworkAnchor.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this NetworkAnchor.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this NetworkAnchor.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this NetworkAnchor.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this NetworkAnchor.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this NetworkAnchor.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this NetworkAnchor.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def setup_mode(self):
        """
        Gets the setup_mode of this NetworkAnchor.
        AUTO_BIND - when passed compartment will be created on-behalf of customer and bind to this resource anchor
        NO_AUTO_BIND - compartment will not be created and later customer can bind existing compartment.
        to this resource anchor. This is for future use only

        Allowed values for this property are: "AUTO_BIND", "NO_AUTO_BIND", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The setup_mode of this NetworkAnchor.
        :rtype: str
        """
        return self._setup_mode

    @setup_mode.setter
    def setup_mode(self, setup_mode):
        """
        Sets the setup_mode of this NetworkAnchor.
        AUTO_BIND - when passed compartment will be created on-behalf of customer and bind to this resource anchor
        NO_AUTO_BIND - compartment will not be created and later customer can bind existing compartment.
        to this resource anchor. This is for future use only


        :param setup_mode: The setup_mode of this NetworkAnchor.
        :type: str
        """
        allowed_values = ["AUTO_BIND", "NO_AUTO_BIND"]
        if not value_allowed_none_or_none_sentinel(setup_mode, allowed_values):
            setup_mode = 'UNKNOWN_ENUM_VALUE'
        self._setup_mode = setup_mode

    @property
    def cluster_placement_group_id(self):
        """
        Gets the cluster_placement_group_id of this NetworkAnchor.
        The CPG ID in which Network Anchor will be created.


        :return: The cluster_placement_group_id of this NetworkAnchor.
        :rtype: str
        """
        return self._cluster_placement_group_id

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, cluster_placement_group_id):
        """
        Sets the cluster_placement_group_id of this NetworkAnchor.
        The CPG ID in which Network Anchor will be created.


        :param cluster_placement_group_id: The cluster_placement_group_id of this NetworkAnchor.
        :type: str
        """
        self._cluster_placement_group_id = cluster_placement_group_id

    @property
    def oci_metadata_item(self):
        """
        Gets the oci_metadata_item of this NetworkAnchor.

        :return: The oci_metadata_item of this NetworkAnchor.
        :rtype: oci.multicloud.models.OciNetworkMetadata
        """
        return self._oci_metadata_item

    @oci_metadata_item.setter
    def oci_metadata_item(self, oci_metadata_item):
        """
        Sets the oci_metadata_item of this NetworkAnchor.

        :param oci_metadata_item: The oci_metadata_item of this NetworkAnchor.
        :type: oci.multicloud.models.OciNetworkMetadata
        """
        self._oci_metadata_item = oci_metadata_item

    @property
    def cloud_service_provider_metadata_item(self):
        """
        Gets the cloud_service_provider_metadata_item of this NetworkAnchor.

        :return: The cloud_service_provider_metadata_item of this NetworkAnchor.
        :rtype: oci.multicloud.models.CloudServiceProviderNetworkMetadataItem
        """
        return self._cloud_service_provider_metadata_item

    @cloud_service_provider_metadata_item.setter
    def cloud_service_provider_metadata_item(self, cloud_service_provider_metadata_item):
        """
        Sets the cloud_service_provider_metadata_item of this NetworkAnchor.

        :param cloud_service_provider_metadata_item: The cloud_service_provider_metadata_item of this NetworkAnchor.
        :type: oci.multicloud.models.CloudServiceProviderNetworkMetadataItem
        """
        self._cloud_service_provider_metadata_item = cloud_service_provider_metadata_item

    @property
    def subscription_type(self):
        """
        Gets the subscription_type of this NetworkAnchor.
        Oracle Cloud Infrastructure Subscription Type.

        Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The subscription_type of this NetworkAnchor.
        :rtype: str
        """
        return self._subscription_type

    @subscription_type.setter
    def subscription_type(self, subscription_type):
        """
        Sets the subscription_type of this NetworkAnchor.
        Oracle Cloud Infrastructure Subscription Type.


        :param subscription_type: The subscription_type of this NetworkAnchor.
        :type: str
        """
        allowed_values = ["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]
        if not value_allowed_none_or_none_sentinel(subscription_type, allowed_values):
            subscription_type = 'UNKNOWN_ENUM_VALUE'
        self._subscription_type = subscription_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
