# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrgPromotionStatusResponse(object):
    """
    The promotion/unpromotion status of a DRG
    """

    #: A constant which can be used with the drg_promotion_status property of a DrgPromotionStatusResponse.
    #: This constant has a value of "UNPROMOTED"
    DRG_PROMOTION_STATUS_UNPROMOTED = "UNPROMOTED"

    #: A constant which can be used with the drg_promotion_status property of a DrgPromotionStatusResponse.
    #: This constant has a value of "PROMOTING"
    DRG_PROMOTION_STATUS_PROMOTING = "PROMOTING"

    #: A constant which can be used with the drg_promotion_status property of a DrgPromotionStatusResponse.
    #: This constant has a value of "PROMOTED"
    DRG_PROMOTION_STATUS_PROMOTED = "PROMOTED"

    #: A constant which can be used with the drg_promotion_status property of a DrgPromotionStatusResponse.
    #: This constant has a value of "UNPROMOTING"
    DRG_PROMOTION_STATUS_UNPROMOTING = "UNPROMOTING"

    def __init__(self, **kwargs):
        """
        Initializes a new DrgPromotionStatusResponse object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param drg_id:
            The value to assign to the drg_id property of this DrgPromotionStatusResponse.
        :type drg_id: str

        :param drg_promotion_status:
            The value to assign to the drg_promotion_status property of this DrgPromotionStatusResponse.
            Allowed values for this property are: "UNPROMOTED", "PROMOTING", "PROMOTED", "UNPROMOTING"
        :type drg_promotion_status: str

        :param rpc_promotion_status:
            The value to assign to the rpc_promotion_status property of this DrgPromotionStatusResponse.
        :type rpc_promotion_status: dict(str, str)

        :param vc_promotion_status:
            The value to assign to the vc_promotion_status property of this DrgPromotionStatusResponse.
        :type vc_promotion_status: dict(str, str)

        :param ipsec_promotion_status:
            The value to assign to the ipsec_promotion_status property of this DrgPromotionStatusResponse.
        :type ipsec_promotion_status: dict(str, str)

        """
        self.swagger_types = {
            'drg_id': 'str',
            'drg_promotion_status': 'str',
            'rpc_promotion_status': 'dict(str, str)',
            'vc_promotion_status': 'dict(str, str)',
            'ipsec_promotion_status': 'dict(str, str)'
        }
        self.attribute_map = {
            'drg_id': 'drgId',
            'drg_promotion_status': 'drgPromotionStatus',
            'rpc_promotion_status': 'rpcPromotionStatus',
            'vc_promotion_status': 'vcPromotionStatus',
            'ipsec_promotion_status': 'ipsecPromotionStatus'
        }
        self._drg_id = None
        self._drg_promotion_status = None
        self._rpc_promotion_status = None
        self._vc_promotion_status = None
        self._ipsec_promotion_status = None

    @property
    def drg_id(self):
        """
        **[Required]** Gets the drg_id of this DrgPromotionStatusResponse.
        OCID of the DRG


        :return: The drg_id of this DrgPromotionStatusResponse.
        :rtype: str
        """
        return self._drg_id

    @drg_id.setter
    def drg_id(self, drg_id):
        """
        Sets the drg_id of this DrgPromotionStatusResponse.
        OCID of the DRG


        :param drg_id: The drg_id of this DrgPromotionStatusResponse.
        :type: str
        """
        self._drg_id = drg_id

    @property
    def drg_promotion_status(self):
        """
        Gets the drg_promotion_status of this DrgPromotionStatusResponse.
        The promotion status of the DRG

        Allowed values for this property are: "UNPROMOTED", "PROMOTING", "PROMOTED", "UNPROMOTING"


        :return: The drg_promotion_status of this DrgPromotionStatusResponse.
        :rtype: str
        """
        return self._drg_promotion_status

    @drg_promotion_status.setter
    def drg_promotion_status(self, drg_promotion_status):
        """
        Sets the drg_promotion_status of this DrgPromotionStatusResponse.
        The promotion status of the DRG


        :param drg_promotion_status: The drg_promotion_status of this DrgPromotionStatusResponse.
        :type: str
        """
        allowed_values = ["UNPROMOTED", "PROMOTING", "PROMOTED", "UNPROMOTING"]
        if not value_allowed_none_or_none_sentinel(drg_promotion_status, allowed_values):
            raise ValueError(
                f"Invalid value for `drg_promotion_status`, must be None or one of {allowed_values}"
            )
        self._drg_promotion_status = drg_promotion_status

    @property
    def rpc_promotion_status(self):
        """
        Gets the rpc_promotion_status of this DrgPromotionStatusResponse.
        A map of the promotion status of each RPC connection on this DRG {conn_id -> promo_status}


        :return: The rpc_promotion_status of this DrgPromotionStatusResponse.
        :rtype: dict(str, str)
        """
        return self._rpc_promotion_status

    @rpc_promotion_status.setter
    def rpc_promotion_status(self, rpc_promotion_status):
        """
        Sets the rpc_promotion_status of this DrgPromotionStatusResponse.
        A map of the promotion status of each RPC connection on this DRG {conn_id -> promo_status}


        :param rpc_promotion_status: The rpc_promotion_status of this DrgPromotionStatusResponse.
        :type: dict(str, str)
        """
        self._rpc_promotion_status = rpc_promotion_status

    @property
    def vc_promotion_status(self):
        """
        Gets the vc_promotion_status of this DrgPromotionStatusResponse.
        A map of the promotion status of each VC on this DRG {conn_id -> promo_status}


        :return: The vc_promotion_status of this DrgPromotionStatusResponse.
        :rtype: dict(str, str)
        """
        return self._vc_promotion_status

    @vc_promotion_status.setter
    def vc_promotion_status(self, vc_promotion_status):
        """
        Sets the vc_promotion_status of this DrgPromotionStatusResponse.
        A map of the promotion status of each VC on this DRG {conn_id -> promo_status}


        :param vc_promotion_status: The vc_promotion_status of this DrgPromotionStatusResponse.
        :type: dict(str, str)
        """
        self._vc_promotion_status = vc_promotion_status

    @property
    def ipsec_promotion_status(self):
        """
        Gets the ipsec_promotion_status of this DrgPromotionStatusResponse.
        A map of the promotion status of each IPSec connection on this DRG {conn_id -> promo_status}


        :return: The ipsec_promotion_status of this DrgPromotionStatusResponse.
        :rtype: dict(str, str)
        """
        return self._ipsec_promotion_status

    @ipsec_promotion_status.setter
    def ipsec_promotion_status(self, ipsec_promotion_status):
        """
        Sets the ipsec_promotion_status of this DrgPromotionStatusResponse.
        A map of the promotion status of each IPSec connection on this DRG {conn_id -> promo_status}


        :param ipsec_promotion_status: The ipsec_promotion_status of this DrgPromotionStatusResponse.
        :type: dict(str, str)
        """
        self._ipsec_promotion_status = ipsec_promotion_status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
