# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .drg_attachment_network_update_details import DrgAttachmentNetworkUpdateDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LoopbackDrgAttachmentNetworkUpdateDetails(DrgAttachmentNetworkUpdateDetails):
    """
    Specifies the update details for Loopback attachment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LoopbackDrgAttachmentNetworkUpdateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.LoopbackDrgAttachmentNetworkUpdateDetails.type` attribute
        of this class is ``LOOPBACK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this LoopbackDrgAttachmentNetworkUpdateDetails.
            Allowed values for this property are: "VCN", "VIRTUAL_CIRCUIT", "LOOPBACK", "INTERNET"
        :type type: str

        :param ids:
            The value to assign to the ids property of this LoopbackDrgAttachmentNetworkUpdateDetails.
        :type ids: list[str]

        """
        self.swagger_types = {
            'type': 'str',
            'ids': 'list[str]'
        }
        self.attribute_map = {
            'type': 'type',
            'ids': 'ids'
        }
        self._type = None
        self._ids = None
        self._type = 'LOOPBACK'

    @property
    def ids(self):
        """
        Gets the ids of this LoopbackDrgAttachmentNetworkUpdateDetails.
        The `OCID`__ of the Ipsec tunnel attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The ids of this LoopbackDrgAttachmentNetworkUpdateDetails.
        :rtype: list[str]
        """
        return self._ids

    @ids.setter
    def ids(self, ids):
        """
        Sets the ids of this LoopbackDrgAttachmentNetworkUpdateDetails.
        The `OCID`__ of the Ipsec tunnel attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param ids: The ids of this LoopbackDrgAttachmentNetworkUpdateDetails.
        :type: list[str]
        """
        self._ids = ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
