# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SetDrgPeeringConnectionDetails(object):
    """
    SetDrgPeeringConnectionDetails model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SetDrgPeeringConnectionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param drg_id:
            The value to assign to the drg_id property of this SetDrgPeeringConnectionDetails.
        :type drg_id: str

        :param peer_rpc_route_target:
            The value to assign to the peer_rpc_route_target property of this SetDrgPeeringConnectionDetails.
        :type peer_rpc_route_target: str

        :param peer_region_name:
            The value to assign to the peer_region_name property of this SetDrgPeeringConnectionDetails.
        :type peer_region_name: str

        :param peer_ingress_vip:
            The value to assign to the peer_ingress_vip property of this SetDrgPeeringConnectionDetails.
        :type peer_ingress_vip: str

        """
        self.swagger_types = {
            'drg_id': 'str',
            'peer_rpc_route_target': 'str',
            'peer_region_name': 'str',
            'peer_ingress_vip': 'str'
        }
        self.attribute_map = {
            'drg_id': 'drgId',
            'peer_rpc_route_target': 'peerRpcRouteTarget',
            'peer_region_name': 'peerRegionName',
            'peer_ingress_vip': 'peerIngressVIP'
        }
        self._drg_id = None
        self._peer_rpc_route_target = None
        self._peer_region_name = None
        self._peer_ingress_vip = None

    @property
    def drg_id(self):
        """
        **[Required]** Gets the drg_id of this SetDrgPeeringConnectionDetails.
        The `OCID`__ of the DRG.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The drg_id of this SetDrgPeeringConnectionDetails.
        :rtype: str
        """
        return self._drg_id

    @drg_id.setter
    def drg_id(self, drg_id):
        """
        Sets the drg_id of this SetDrgPeeringConnectionDetails.
        The `OCID`__ of the DRG.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param drg_id: The drg_id of this SetDrgPeeringConnectionDetails.
        :type: str
        """
        self._drg_id = drg_id

    @property
    def peer_rpc_route_target(self):
        """
        **[Required]** Gets the peer_rpc_route_target of this SetDrgPeeringConnectionDetails.
        The string in the form ASN:rpc_attachment_mplsLabel.


        :return: The peer_rpc_route_target of this SetDrgPeeringConnectionDetails.
        :rtype: str
        """
        return self._peer_rpc_route_target

    @peer_rpc_route_target.setter
    def peer_rpc_route_target(self, peer_rpc_route_target):
        """
        Sets the peer_rpc_route_target of this SetDrgPeeringConnectionDetails.
        The string in the form ASN:rpc_attachment_mplsLabel.


        :param peer_rpc_route_target: The peer_rpc_route_target of this SetDrgPeeringConnectionDetails.
        :type: str
        """
        self._peer_rpc_route_target = peer_rpc_route_target

    @property
    def peer_region_name(self):
        """
        **[Required]** Gets the peer_region_name of this SetDrgPeeringConnectionDetails.
        OCI region name to include in the routeData


        :return: The peer_region_name of this SetDrgPeeringConnectionDetails.
        :rtype: str
        """
        return self._peer_region_name

    @peer_region_name.setter
    def peer_region_name(self, peer_region_name):
        """
        Sets the peer_region_name of this SetDrgPeeringConnectionDetails.
        OCI region name to include in the routeData


        :param peer_region_name: The peer_region_name of this SetDrgPeeringConnectionDetails.
        :type: str
        """
        self._peer_region_name = peer_region_name

    @property
    def peer_ingress_vip(self):
        """
        Gets the peer_ingress_vip of this SetDrgPeeringConnectionDetails.
        ingress VIP of the peered DRG


        :return: The peer_ingress_vip of this SetDrgPeeringConnectionDetails.
        :rtype: str
        """
        return self._peer_ingress_vip

    @peer_ingress_vip.setter
    def peer_ingress_vip(self, peer_ingress_vip):
        """
        Sets the peer_ingress_vip of this SetDrgPeeringConnectionDetails.
        ingress VIP of the peered DRG


        :param peer_ingress_vip: The peer_ingress_vip of this SetDrgPeeringConnectionDetails.
        :type: str
        """
        self._peer_ingress_vip = peer_ingress_vip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
