# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .drg_attachment_network_details import DrgAttachmentNetworkDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VirtualCircuitDrgAttachmentNetworkDetails(DrgAttachmentNetworkDetails):
    """
    Specifies the virtual circuit attached to the DRG.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VirtualCircuitDrgAttachmentNetworkDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.VirtualCircuitDrgAttachmentNetworkDetails.type` attribute
        of this class is ``VIRTUAL_CIRCUIT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this VirtualCircuitDrgAttachmentNetworkDetails.
            Allowed values for this property are: "VCN", "IPSEC_TUNNEL", "VIRTUAL_CIRCUIT", "REMOTE_PEERING_CONNECTION", "FLEX_TUNNEL", "LOOPBACK", "INTERNET"
        :type type: str

        :param id:
            The value to assign to the id property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type id: str

        :param is_ffab:
            The value to assign to the is_ffab property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type is_ffab: bool

        :param is_edge_pop:
            The value to assign to the is_edge_pop property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type is_edge_pop: bool

        :param import_route_target:
            The value to assign to the import_route_target property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type import_route_target: str

        :param export_route_target:
            The value to assign to the export_route_target property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type export_route_target: str

        :param mpls_label:
            The value to assign to the mpls_label property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type mpls_label: int

        :param regional_oci_asn:
            The value to assign to the regional_oci_asn property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type regional_oci_asn: str

        :param region_name:
            The value to assign to the region_name property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type region_name: str

        :param common_export_rt:
            The value to assign to the common_export_rt property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type common_export_rt: str

        :param common_import_rt:
            The value to assign to the common_import_rt property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type common_import_rt: str

        :param is_ingress_disintermediation_enabled:
            The value to assign to the is_ingress_disintermediation_enabled property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type is_ingress_disintermediation_enabled: bool

        :param is_route_unification_enabled:
            The value to assign to the is_route_unification_enabled property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type is_route_unification_enabled: bool

        :param transport_only_mode:
            The value to assign to the transport_only_mode property of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type transport_only_mode: bool

        """
        self.swagger_types = {
            'type': 'str',
            'id': 'str',
            'is_ffab': 'bool',
            'is_edge_pop': 'bool',
            'import_route_target': 'str',
            'export_route_target': 'str',
            'mpls_label': 'int',
            'regional_oci_asn': 'str',
            'region_name': 'str',
            'common_export_rt': 'str',
            'common_import_rt': 'str',
            'is_ingress_disintermediation_enabled': 'bool',
            'is_route_unification_enabled': 'bool',
            'transport_only_mode': 'bool'
        }
        self.attribute_map = {
            'type': 'type',
            'id': 'id',
            'is_ffab': 'isFFAB',
            'is_edge_pop': 'isEdgePop',
            'import_route_target': 'importRouteTarget',
            'export_route_target': 'exportRouteTarget',
            'mpls_label': 'mplsLabel',
            'regional_oci_asn': 'regionalOciAsn',
            'region_name': 'regionName',
            'common_export_rt': 'commonExportRT',
            'common_import_rt': 'commonImportRT',
            'is_ingress_disintermediation_enabled': 'isIngressDisintermediationEnabled',
            'is_route_unification_enabled': 'isRouteUnificationEnabled',
            'transport_only_mode': 'transportOnlyMode'
        }
        self._type = None
        self._id = None
        self._is_ffab = None
        self._is_edge_pop = None
        self._import_route_target = None
        self._export_route_target = None
        self._mpls_label = None
        self._regional_oci_asn = None
        self._region_name = None
        self._common_export_rt = None
        self._common_import_rt = None
        self._is_ingress_disintermediation_enabled = None
        self._is_route_unification_enabled = None
        self._transport_only_mode = None
        self._type = 'VIRTUAL_CIRCUIT'

    @property
    def is_ffab(self):
        """
        Gets the is_ffab of this VirtualCircuitDrgAttachmentNetworkDetails.
        Whether the Fast Connect is an FFAB VirtualCircuit.

        Example: `true`


        :return: The is_ffab of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: bool
        """
        return self._is_ffab

    @is_ffab.setter
    def is_ffab(self, is_ffab):
        """
        Sets the is_ffab of this VirtualCircuitDrgAttachmentNetworkDetails.
        Whether the Fast Connect is an FFAB VirtualCircuit.

        Example: `true`


        :param is_ffab: The is_ffab of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: bool
        """
        self._is_ffab = is_ffab

    @property
    def is_edge_pop(self):
        """
        Gets the is_edge_pop of this VirtualCircuitDrgAttachmentNetworkDetails.
        This indicates whether FastConnect extends through an edge POP region.

        Example: `true`


        :return: The is_edge_pop of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: bool
        """
        return self._is_edge_pop

    @is_edge_pop.setter
    def is_edge_pop(self, is_edge_pop):
        """
        Sets the is_edge_pop of this VirtualCircuitDrgAttachmentNetworkDetails.
        This indicates whether FastConnect extends through an edge POP region.

        Example: `true`


        :param is_edge_pop: The is_edge_pop of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: bool
        """
        self._is_edge_pop = is_edge_pop

    @property
    def import_route_target(self):
        """
        Gets the import_route_target of this VirtualCircuitDrgAttachmentNetworkDetails.
        Routes which may be imported from the attachment (subject to import policy) appear in the route reflectors
        tagged with the attachment's import route target.


        :return: The import_route_target of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._import_route_target

    @import_route_target.setter
    def import_route_target(self, import_route_target):
        """
        Sets the import_route_target of this VirtualCircuitDrgAttachmentNetworkDetails.
        Routes which may be imported from the attachment (subject to import policy) appear in the route reflectors
        tagged with the attachment's import route target.


        :param import_route_target: The import_route_target of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: str
        """
        self._import_route_target = import_route_target

    @property
    def export_route_target(self):
        """
        Gets the export_route_target of this VirtualCircuitDrgAttachmentNetworkDetails.
        Routes which are exported to the attachment are exported to the route reflectors
        with the route target set to the value of the attachment's export route target.


        :return: The export_route_target of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._export_route_target

    @export_route_target.setter
    def export_route_target(self, export_route_target):
        """
        Sets the export_route_target of this VirtualCircuitDrgAttachmentNetworkDetails.
        Routes which are exported to the attachment are exported to the route reflectors
        with the route target set to the value of the attachment's export route target.


        :param export_route_target: The export_route_target of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: str
        """
        self._export_route_target = export_route_target

    @property
    def mpls_label(self):
        """
        Gets the mpls_label of this VirtualCircuitDrgAttachmentNetworkDetails.
        The MPLS label of the DRG attachment.


        :return: The mpls_label of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: int
        """
        return self._mpls_label

    @mpls_label.setter
    def mpls_label(self, mpls_label):
        """
        Sets the mpls_label of this VirtualCircuitDrgAttachmentNetworkDetails.
        The MPLS label of the DRG attachment.


        :param mpls_label: The mpls_label of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: int
        """
        self._mpls_label = mpls_label

    @property
    def regional_oci_asn(self):
        """
        Gets the regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkDetails.
        The BGP ASN to use for the IPSec connection's route target.


        :return: The regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._regional_oci_asn

    @regional_oci_asn.setter
    def regional_oci_asn(self, regional_oci_asn):
        """
        Sets the regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkDetails.
        The BGP ASN to use for the IPSec connection's route target.


        :param regional_oci_asn: The regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: str
        """
        self._regional_oci_asn = regional_oci_asn

    @property
    def region_name(self):
        """
        Gets the region_name of this VirtualCircuitDrgAttachmentNetworkDetails.
        The Oracle Cloud Infrastructure region name.


        :return: The region_name of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._region_name

    @region_name.setter
    def region_name(self, region_name):
        """
        Sets the region_name of this VirtualCircuitDrgAttachmentNetworkDetails.
        The Oracle Cloud Infrastructure region name.


        :param region_name: The region_name of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: str
        """
        self._region_name = region_name

    @property
    def common_export_rt(self):
        """
        Gets the common_export_rt of this VirtualCircuitDrgAttachmentNetworkDetails.
        Common Export route target to use for the DRG Attachment instead of per-attachment route target.
        This is applicable to DRG attachments that are assigned to a DRG route table which is whitelisted for high
        throughput mode.


        :return: The common_export_rt of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._common_export_rt

    @common_export_rt.setter
    def common_export_rt(self, common_export_rt):
        """
        Sets the common_export_rt of this VirtualCircuitDrgAttachmentNetworkDetails.
        Common Export route target to use for the DRG Attachment instead of per-attachment route target.
        This is applicable to DRG attachments that are assigned to a DRG route table which is whitelisted for high
        throughput mode.


        :param common_export_rt: The common_export_rt of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: str
        """
        self._common_export_rt = common_export_rt

    @property
    def common_import_rt(self):
        """
        Gets the common_import_rt of this VirtualCircuitDrgAttachmentNetworkDetails.
        Common Import route target to use for the DRG attachment instead of per-attachment import route target.
        This is applicable to DRG attachments that are assigned to a DRG route table which is whitelisted for high
        throughput mode.


        :return: The common_import_rt of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._common_import_rt

    @common_import_rt.setter
    def common_import_rt(self, common_import_rt):
        """
        Sets the common_import_rt of this VirtualCircuitDrgAttachmentNetworkDetails.
        Common Import route target to use for the DRG attachment instead of per-attachment import route target.
        This is applicable to DRG attachments that are assigned to a DRG route table which is whitelisted for high
        throughput mode.


        :param common_import_rt: The common_import_rt of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: str
        """
        self._common_import_rt = common_import_rt

    @property
    def is_ingress_disintermediation_enabled(self):
        """
        Gets the is_ingress_disintermediation_enabled of this VirtualCircuitDrgAttachmentNetworkDetails.
        This indicates whether the DRG route table associated with the DRG attachment is whitelisted for High Throughput mode.

        Example: `true`


        :return: The is_ingress_disintermediation_enabled of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: bool
        """
        return self._is_ingress_disintermediation_enabled

    @is_ingress_disintermediation_enabled.setter
    def is_ingress_disintermediation_enabled(self, is_ingress_disintermediation_enabled):
        """
        Sets the is_ingress_disintermediation_enabled of this VirtualCircuitDrgAttachmentNetworkDetails.
        This indicates whether the DRG route table associated with the DRG attachment is whitelisted for High Throughput mode.

        Example: `true`


        :param is_ingress_disintermediation_enabled: The is_ingress_disintermediation_enabled of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: bool
        """
        self._is_ingress_disintermediation_enabled = is_ingress_disintermediation_enabled

    @property
    def is_route_unification_enabled(self):
        """
        Gets the is_route_unification_enabled of this VirtualCircuitDrgAttachmentNetworkDetails.
        This indicates whether the DRG route table associated with the DRG attachment is whitelisted for route unification.

        Example: `true`


        :return: The is_route_unification_enabled of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: bool
        """
        return self._is_route_unification_enabled

    @is_route_unification_enabled.setter
    def is_route_unification_enabled(self, is_route_unification_enabled):
        """
        Sets the is_route_unification_enabled of this VirtualCircuitDrgAttachmentNetworkDetails.
        This indicates whether the DRG route table associated with the DRG attachment is whitelisted for route unification.

        Example: `true`


        :param is_route_unification_enabled: The is_route_unification_enabled of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: bool
        """
        self._is_route_unification_enabled = is_route_unification_enabled

    @property
    def transport_only_mode(self):
        """
        Gets the transport_only_mode of this VirtualCircuitDrgAttachmentNetworkDetails.
        Boolean flag that determines wether all traffic over the virtual circuits is encrypted.

        Example: `true`


        :return: The transport_only_mode of this VirtualCircuitDrgAttachmentNetworkDetails.
        :rtype: bool
        """
        return self._transport_only_mode

    @transport_only_mode.setter
    def transport_only_mode(self, transport_only_mode):
        """
        Sets the transport_only_mode of this VirtualCircuitDrgAttachmentNetworkDetails.
        Boolean flag that determines wether all traffic over the virtual circuits is encrypted.

        Example: `true`


        :param transport_only_mode: The transport_only_mode of this VirtualCircuitDrgAttachmentNetworkDetails.
        :type: bool
        """
        self._transport_only_mode = transport_only_mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
