
# Copyright (c) 2025, Oracle and/or its affiliates.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License, version 2.0,
# as published by the Free Software Foundation.
#
# This program is designed to work with certain software (including
# but not limited to OpenSSL) that is licensed under separate terms, as
# designated in a particular file or component or in included license
# documentation.  The authors of MySQL hereby grant you an additional
# permission to link the program and your derivative works with the
# separately licensed software that they have either included with
# the program or referenced in the documentation.
#
# This program is distributed in the hope that it will be useful,  but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
# the GNU General Public License, version 2.0, for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

# this file is auto-generated
k_configuration_variables_metadata = {
   'completion_type': {'type': 'string', 'enum': ['NO_CHAIN', 'CHAIN', 'RELEASE'], 'description': '("completion_type")', 'default': 'NO_CHAIN'},
   'big_tables': {'type': 'boolean', 'description': 'If enabled, the server stores all temporary tables on disk rather than in memory.\n\nbigTables corresponds to the MySQL server variable [big_tables](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_big_tables).\n', 'default': False},
   'character_set_server': {'type': 'string', 'enum': ['ARMSCII8', 'ASCII', 'BIG5', 'BINARY', 'CP1250', 'CP1251', 'CP1256', 'CP1257', 'CP850', 'CP852', 'CP866', 'CP932', 'DEC8', 'EUCJPMS', 'EUCKR', 'GB18030', 'GB2312', 'GBK', 'GEOSTD8', 'GREEK', 'HEBREW', 'HP8', 'KEYBCS2', 'KOI8R', 'KOI8U', 'LATIN1', 'LATIN2', 'LATIN5', 'LATIN7', 'MACCE', 'MACROMAN', 'SJIS', 'SWE7', 'TIS620', 'UCS2', 'UJIS', 'UTF16', 'UTF16LE', 'UTF32', 'UTF8MB3', 'UTF8MB4'], 'description': "The server's default character set. If you set this variable, you should also set collation_server to specify the collation for the character set.\n\ncharacterSetServer corresponds to the MySQL server variable [character_set_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_character_set_server).\n"},
   'collation_server': {'type': 'string', 'enum': ['ARMSCII8_GENERAL_CI', 'ARMSCII8_BIN', 'ASCII_GENERAL_CI', 'ASCII_BIN', 'BIG5_CHINESE_CI', 'BIG5_BIN', 'BINARY', 'CP1250_GENERAL_CI', 'CP1250_BIN', 'CP1250_CROATIAN_CI', 'CP1250_CZECH_CS', 'CP1250_POLISH_CI', 'CP1251_GENERAL_CI', 'CP1251_BIN', 'CP1251_BULGARIAN_CI', 'CP1251_GENERAL_CS', 'CP1251_UKRAINIAN_CI', 'CP1256_GENERAL_CI', 'CP1256_BIN', 'CP1257_GENERAL_CI', 'CP1257_BIN', 'CP1257_LITHUANIAN_CI', 'CP850_GENERAL_CI', 'CP850_BIN', 'CP852_GENERAL_CI', 'CP852_BIN', 'CP866_GENERAL_CI', 'CP866_BIN', 'CP932_JAPANESE_CI', 'CP932_BIN', 'DEC8_SWEDISH_CI', 'DEC8_BIN', 'EUCJPMS_JAPANESE_CI', 'EUCJPMS_BIN', 'EUCKR_KOREAN_CI', 'EUCKR_BIN', 'GB18030_CHINESE_CI', 'GB18030_BIN', 'GB18030_UNICODE_520_CI', 'GB2312_CHINESE_CI', 'GB2312_BIN', 'GBK_CHINESE_CI', 'GBK_BIN', 'GEOSTD8_GENERAL_CI', 'GEOSTD8_BIN', 'GREEK_GENERAL_CI', 'GREEK_BIN', 'HEBREW_GENERAL_CI', 'HEBREW_BIN', 'HP8_ENGLISH_CI', 'HP8_BIN', 'KEYBCS2_GENERAL_CI', 'KEYBCS2_BIN', 'KOI8R_GENERAL_CI', 'KOI8R_BIN', 'KOI8U_GENERAL_CI', 'KOI8U_BIN', 'LATIN1_SWEDISH_CI', 'LATIN1_BIN', 'LATIN1_DANISH_CI', 'LATIN1_GENERAL_CI', 'LATIN1_GENERAL_CS', 'LATIN1_GERMAN1_CI', 'LATIN1_GERMAN2_CI', 'LATIN1_SPANISH_CI', 'LATIN2_GENERAL_CI', 'LATIN2_BIN', 'LATIN2_CROATIAN_CI', 'LATIN2_CZECH_CS', 'LATIN2_HUNGARIAN_CI', 'LATIN5_TURKISH_CI', 'LATIN5_BIN', 'LATIN7_GENERAL_CI', 'LATIN7_BIN', 'LATIN7_ESTONIAN_CS', 'LATIN7_GENERAL_CS', 'MACCE_GENERAL_CI', 'MACCE_BIN', 'MACROMAN_GENERAL_CI', 'MACROMAN_BIN', 'SJIS_JAPANESE_CI', 'SJIS_BIN', 'SWE7_SWEDISH_CI', 'SWE7_BIN', 'TIS620_THAI_CI', 'TIS620_BIN', 'UCS2_GENERAL_CI', 'UCS2_BIN', 'UCS2_CROATIAN_CI', 'UCS2_CZECH_CI', 'UCS2_DANISH_CI', 'UCS2_ESPERANTO_CI', 'UCS2_ESTONIAN_CI', 'UCS2_GENERAL_MYSQL500_CI', 'UCS2_GERMAN2_CI', 'UCS2_HUNGARIAN_CI', 'UCS2_ICELANDIC_CI', 'UCS2_LATVIAN_CI', 'UCS2_LITHUANIAN_CI', 'UCS2_PERSIAN_CI', 'UCS2_POLISH_CI', 'UCS2_ROMANIAN_CI', 'UCS2_ROMAN_CI', 'UCS2_SINHALA_CI', 'UCS2_SLOVAK_CI', 'UCS2_SLOVENIAN_CI', 'UCS2_SPANISH2_CI', 'UCS2_SPANISH_CI', 'UCS2_SWEDISH_CI', 'UCS2_TURKISH_CI', 'UCS2_UNICODE_520_CI', 'UCS2_UNICODE_CI', 'UCS2_VIETNAMESE_CI', 'UJIS_JAPANESE_CI', 'UJIS_BIN', 'UTF16_GENERAL_CI', 'UTF16_BIN', 'UTF16_CROATIAN_CI', 'UTF16_CZECH_CI', 'UTF16_DANISH_CI', 'UTF16_ESPERANTO_CI', 'UTF16_ESTONIAN_CI', 'UTF16_GERMAN2_CI', 'UTF16_HUNGARIAN_CI', 'UTF16_ICELANDIC_CI', 'UTF16_LATVIAN_CI', 'UTF16_LITHUANIAN_CI', 'UTF16_PERSIAN_CI', 'UTF16_POLISH_CI', 'UTF16_ROMANIAN_CI', 'UTF16_ROMAN_CI', 'UTF16_SINHALA_CI', 'UTF16_SLOVAK_CI', 'UTF16_SLOVENIAN_CI', 'UTF16_SPANISH2_CI', 'UTF16_SPANISH_CI', 'UTF16_SWEDISH_CI', 'UTF16_TURKISH_CI', 'UTF16_UNICODE_520_CI', 'UTF16_UNICODE_CI', 'UTF16_VIETNAMESE_CI', 'UTF16LE_GENERAL_CI', 'UTF16LE_BIN', 'UTF32_GENERAL_CI', 'UTF32_BIN', 'UTF32_CROATIAN_CI', 'UTF32_CZECH_CI', 'UTF32_DANISH_CI', 'UTF32_ESPERANTO_CI', 'UTF32_ESTONIAN_CI', 'UTF32_GERMAN2_CI', 'UTF32_HUNGARIAN_CI', 'UTF32_ICELANDIC_CI', 'UTF32_LATVIAN_CI', 'UTF32_LITHUANIAN_CI', 'UTF32_PERSIAN_CI', 'UTF32_POLISH_CI', 'UTF32_ROMANIAN_CI', 'UTF32_ROMAN_CI', 'UTF32_SINHALA_CI', 'UTF32_SLOVAK_CI', 'UTF32_SLOVENIAN_CI', 'UTF32_SPANISH2_CI', 'UTF32_SPANISH_CI', 'UTF32_SWEDISH_CI', 'UTF32_TURKISH_CI', 'UTF32_UNICODE_520_CI', 'UTF32_UNICODE_CI', 'UTF32_VIETNAMESE_CI', 'UTF8_GENERAL_CI', 'UTF8_BIN', 'UTF8_CROATIAN_CI', 'UTF8_CZECH_CI', 'UTF8_DANISH_CI', 'UTF8_ESPERANTO_CI', 'UTF8_ESTONIAN_CI', 'UTF8_GENERAL_MYSQL500_CI', 'UTF8_GERMAN2_CI', 'UTF8_HUNGARIAN_CI', 'UTF8_ICELANDIC_CI', 'UTF8_LATVIAN_CI', 'UTF8_LITHUANIAN_CI', 'UTF8_PERSIAN_CI', 'UTF8_POLISH_CI', 'UTF8_ROMANIAN_CI', 'UTF8_ROMAN_CI', 'UTF8_SINHALA_CI', 'UTF8_SLOVAK_CI', 'UTF8_SLOVENIAN_CI', 'UTF8_SPANISH2_CI', 'UTF8_SPANISH_CI', 'UTF8_SWEDISH_CI', 'UTF8_TOLOWER_CI', 'UTF8_TURKISH_CI', 'UTF8_UNICODE_520_CI', 'UTF8_UNICODE_CI', 'UTF8_VIETNAMESE_CI', 'UTF8MB4_0900_AI_CI', 'UTF8MB4_0900_AS_CI', 'UTF8MB4_0900_AS_CS', 'UTF8MB4_0900_BIN', 'UTF8MB4_BIN', 'UTF8MB4_CROATIAN_CI', 'UTF8MB4_CS_0900_AI_CI', 'UTF8MB4_CS_0900_AS_CS', 'UTF8MB4_CZECH_CI', 'UTF8MB4_DANISH_CI', 'UTF8MB4_DA_0900_AI_CI', 'UTF8MB4_DA_0900_AS_CS', 'UTF8MB4_DE_PB_0900_AI_CI', 'UTF8MB4_DE_PB_0900_AS_CS', 'UTF8MB4_EO_0900_AI_CI', 'UTF8MB4_EO_0900_AS_CS', 'UTF8MB4_ESPERANTO_CI', 'UTF8MB4_ESTONIAN_CI', 'UTF8MB4_ES_0900_AI_CI', 'UTF8MB4_ES_0900_AS_CS', 'UTF8MB4_ES_TRAD_0900_AI_CI', 'UTF8MB4_ES_TRAD_0900_AS_CS', 'UTF8MB4_ET_0900_AI_CI', 'UTF8MB4_ET_0900_AS_CS', 'UTF8MB4_GENERAL_CI', 'UTF8MB4_GERMAN2_CI', 'UTF8MB4_HR_0900_AI_CI', 'UTF8MB4_HR_0900_AS_CS', 'UTF8MB4_HUNGARIAN_CI', 'UTF8MB4_HU_0900_AI_CI', 'UTF8MB4_HU_0900_AS_CS', 'UTF8MB4_ICELANDIC_CI', 'UTF8MB4_IS_0900_AI_CI', 'UTF8MB4_IS_0900_AS_CS', 'UTF8MB4_JA_0900_AS_CS', 'UTF8MB4_JA_0900_AS_CS_KS', 'UTF8MB4_LATVIAN_CI', 'UTF8MB4_LA_0900_AI_CI', 'UTF8MB4_LA_0900_AS_CS', 'UTF8MB4_LITHUANIAN_CI', 'UTF8MB4_LT_0900_AI_CI', 'UTF8MB4_LT_0900_AS_CS', 'UTF8MB4_LV_0900_AI_CI', 'UTF8MB4_LV_0900_AS_CS', 'UTF8MB4_PERSIAN_CI', 'UTF8MB4_PL_0900_AI_CI', 'UTF8MB4_PL_0900_AS_CS', 'UTF8MB4_POLISH_CI', 'UTF8MB4_ROMANIAN_CI', 'UTF8MB4_ROMAN_CI', 'UTF8MB4_RO_0900_AI_CI', 'UTF8MB4_RO_0900_AS_CS', 'UTF8MB4_RU_0900_AI_CI', 'UTF8MB4_RU_0900_AS_CS', 'UTF8MB4_SINHALA_CI', 'UTF8MB4_SK_0900_AI_CI', 'UTF8MB4_SK_0900_AS_CS', 'UTF8MB4_SLOVAK_CI', 'UTF8MB4_SLOVENIAN_CI', 'UTF8MB4_SL_0900_AI_CI', 'UTF8MB4_SL_0900_AS_CS', 'UTF8MB4_SPANISH2_CI', 'UTF8MB4_SPANISH_CI', 'UTF8MB4_SV_0900_AI_CI', 'UTF8MB4_SV_0900_AS_CS', 'UTF8MB4_SWEDISH_CI', 'UTF8MB4_TR_0900_AI_CI', 'UTF8MB4_TR_0900_AS_CS', 'UTF8MB4_TURKISH_CI', 'UTF8MB4_UNICODE_520_CI', 'UTF8MB4_UNICODE_CI', 'UTF8MB4_VIETNAMESE_CI', 'UTF8MB4_VI_0900_AI_CI', 'UTF8MB4_VI_0900_AS_CS', 'UTF8MB4_ZH_0900_AS_CS'], 'description': "The server's default collation.\n\ncollationServer corresponds to the MySQL server variable [collation_server](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_collation_server).\n"},
   'connection_memory_chunk_size': {'type': 'integer', 'description': 'Set the chunking size for updates to the global memory usage counter Global_connection_memory.\n\nconnectionMemoryChunkSize corresponds to the MySQL system variable [connection_memory_chunk_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_chunk_size).\n', 'minimum': 0, 'maximum': 536870912, 'default': 8912},
   'connection_memory_limit': {'type': 'integer', 'description': 'Set the maximum amount of memory that can be used by a single user connection.\n\nconnectionMemoryLimit corresponds to the MySQL system variable [connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_connection_memory_limit).\n', 'minimum': 2097152, 'maximum': 9223372036854775807},
   'default_authentication_plugin': {'type': 'string', 'enum': ['mysql_native_password', 'sha256_password', 'caching_sha2_password'], 'description': 'The default authentication plugin. This must be a plugin that uses internal credentials storage, so these values are permitted:\nmysql_native_password, sha256_password, caching_sha2_password.\n\nAs of MySQL 8.0.27, which introduces multifactor authentication, default_authentication_plugin is still used,\nbut in conjunction with and at a lower precedence than the authentication_policy system variable.\nFor details, see The Default Authentication Plugin. Because of this diminished role, default_authentication_plugin is deprecated as of MySQL 8.0.27\nand subject to removal in a future MySQL version.\n\ndefaultAuthenticationPlugin corresponds to the MySQL system variable\n[default_authentication_plugin](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_authentication_plugin).\n', 'default': 'caching_sha2_password'},
   'global_connection_memory_limit': {'type': 'integer', 'description': 'Set the total amount of memory that can be used by all user connections.\n\nglobalConnectionMemoryLimit corresponds to the MySQL system variable [global_connection_memory_limit](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_limit).\n', 'minimum': 2097152, 'maximum': 9223372036854775807},
   'global_connection_memory_tracking': {'type': 'boolean', 'description': 'Determines whether the MySQL server calculates Global_connection_memory.\n\nglobalConnectionMemoryTracking corresponds to the MySQL system variable [global_connection_memory_tracking](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_global_connection_memory_tracking).\n', 'default': False},
   'transaction_isolation': {'type': 'string', 'enum': ['READ-UNCOMMITTED', 'READ-COMMITED', 'READ-COMMITTED', 'REPEATABLE-READ', 'SERIALIZABLE'], 'description': '("transaction_isolation")', 'default': 'REPEATABLE-READ'},
   'innodb_ft_server_stopword_table': {'type': 'string', 'description': '("innodb_ft_server_stopword_table")', 'default': None},
   'mandatory_roles': {'type': 'string', 'description': '("mandatory_roles")', 'default': ''},
   'autocommit': {'type': 'boolean', 'description': '("autocommit")', 'default': True},
   'foreign_key_checks': {'type': 'boolean', 'description': '("foreign_key_checks")', 'default': True},
   'group_replication_consistency': {'type': 'string', 'enum': ['EVENTUAL', 'BEFORE_ON_PRIMARY_FAILOVER', 'BEFORE', 'AFTER', 'BEFORE_AND_AFTER'], 'description': '- EVENTUAL:\n    Both RO and RW transactions do not wait for preceding transactions to be applied before executing.\n    A RW transaction does not wait for other members to apply a transaction. This means that a transaction\n    could be externalized on one member before the others. This also means that in the event of a primary failover,\n    the new primary can accept new RO and RW transactions before the previous primary transactions are all applied.\n    RO transactions could result in outdated values, RW transactions could result in a rollback due to conflicts.\n- BEFORE_ON_PRIMARY_FAILOVER:\n    New RO or RW transactions with a newly elected primary that is applying backlog from the old\n    primary are held (not applied) until any backlog has been applied. This ensures that when a primary failover happens,\n    intentionally or not, clients always see the latest value on the primary. This guarantees consistency, but means that\n    clients must be able to handle the delay in the event that a backlog is being applied. Usually this delay should be minimal,\n    but does depend on the size of the backlog.\n- BEFORE:\n    A RW transaction waits for all preceding transactions to complete before being applied. A RO transaction waits for all preceding\n    transactions to complete before being executed. This ensures that this transaction reads the latest value by only affecting the\n    latency of the transaction. This reduces the overhead of synchronization on every RW transaction, by ensuring synchronization is\n    used only on RO transactions. This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.\n- AFTER:\n    A RW transaction waits until its changes have been applied to all of the other members. This value has no effect on RO transactions.\n    This mode ensures that when a transaction is committed on the local member, any subsequent transaction reads the written value or\n    a more recent value on any group member. Use this mode with a group that is used for predominantly RO operations to ensure that\n    applied RW transactions are applied everywhere once they commit. This could be used by your application to ensure that subsequent\n    reads fetch the latest data which includes the latest writes. This reduces the overhead of synchronization on every RO transaction,\n    by ensuring synchronization is used only on RW transactions. This consistency level also includes the consistency guarantees\n    provided by BEFORE_ON_PRIMARY_FAILOVER.\n- BEFORE_AND_AFTER:\n    A RW transaction waits for 1) all preceding transactions to complete before being applied and 2) until its changes have been\n    applied on other members. A RO transaction waits for all preceding transactions to complete before execution takes place.\n    This consistency level also includes the consistency guarantees provided by BEFORE_ON_PRIMARY_FAILOVER.\n', 'default': 'BEFORE_ON_PRIMARY_FAILOVER'},
   'group_concat_max_len': {'type': 'integer', 'description': 'Specifies the maximum permitted result length in bytes for the GROUP_CONCAT() function.\n\nThis is the MySQL variable "group_concat_max_len". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_concat_max_len)\n', 'minimum': 4, 'maximum': 9223372036854775807, 'default': 1024},
   'innodb_ft_enable_stopword': {'type': 'boolean', 'description': '("innodb_ft_enable_stopword")', 'default': True},
   'innodb_log_writer_threads': {'type': 'boolean', 'description': 'Enables dedicated log writer threads for writing redo log records from the log buffer to the system buffers and flushing the system buffers to the redo log files.\n\nThis is the MySQL variable "innodb_log_writer_threads". For more information, please see the [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_writer_threads)\n', 'default': True},
   'local_infile': {'type': 'boolean', 'description': 'This variable controls server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting,\nthe server refuses or permits local data loading by clients that have LOCAL enabled on the client side. \n\nlocal_infile corresponds to the MySQL Server system variable\n[local_infile](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_local_infile)\n', 'default': False},
   'mysql_firewall_mode': {'type': 'boolean', 'description': '("mysql_firewall_mode")', 'default': True},
   'mysqlx_enable_hello_notice': {'type': 'boolean', 'description': '("mysqlx_enable_hello_notice") DEPRECATED -- variable should not be settable and will be ignored', 'default': True},
   'sql_require_primary_key': {'type': 'boolean', 'description': '("sql_require_primary_key")', 'default': False},
   'sql_warnings': {'type': 'boolean', 'description': '("sql_warnings")', 'default': False},
   'binlog_expire_logs_seconds': {'type': 'integer', 'description': 'Sets the binary log expiration period in seconds.\nbinlogExpireLogsSeconds corresponds to the MySQL binary logging system variable [binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds).\n', 'minimum': 0, 'default': 2592000},
   'binlog_row_metadata': {'type': 'string', 'enum': ['FULL', 'MINIMAL'], 'description': 'Configures the amount of table metadata added to the binary log when using row-based logging.\nbinlogRowMetadata corresponds to the MySQL binary logging system variable [binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata).\n', 'default': 'MINIMAL'},
   'binlog_row_value_options': {'type': 'string', 'description': 'When set to PARTIAL_JSON, this enables use of a space-efficient binary log format for updates that modify only a small portion of a JSON document.\nbinlogRowValueOptions corresponds to the MySQL binary logging system variable [binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options).\n', 'default': 'PARTIAL_JSON'},
   'binlog_transaction_compression': {'type': 'boolean', 'description': 'Enables compression for transactions that are written to binary log files on this server.\nbinlogTransactionCompression corresponds to the MySQL binary logging system variable [binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression).\n', 'default': True},
   'innodb_buffer_pool_size': {'type': 'integer', 'description': 'The size (in bytes) of the buffer pool, that is, the memory area where InnoDB caches table and index data.\n\ninnodbBufferPoolSize corresponds to the MySQL server system variable\n[innodb_buffer_pool_size](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_buffer_pool_size).\n\nThe default and maximum values depend on the amount of RAM provisioned by the shape.\nSee [Default User Variables](/mysql-database/doc/configuring-db-system.html#GUID-B5504C19-F6F4-4DAB-8506-189A4E8F4A6A).\n', 'minimum': 5242880, 'maximum': 9223372036854775807, 'default': 134217728},
   'innodb_ft_result_cache_limit': {'type': 'integer', 'description': '("innodb_ft_result_cache_limit")', 'minimum': 1000000, 'maximum': 4294967295, 'default': 2000000000},
   'max_binlog_cache_size': {'type': 'integer', 'description': 'Sets the size of the transaction cache.\n\nmaxBinlogCacheSize corresponds to the MySQL server system variable [max_binlog_cache_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_max_binlog_cache_size).\n', 'minimum': 4096, 'maximum': 65970697666560},
   'max_connect_errors': {'type': 'integer', 'description': '("max_connect_errors")', 'minimum': 1, 'maximum': 9223372036854775807},
   'max_heap_table_size': {'type': 'integer', 'description': 'This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.\n\nmaxHeapTableSize corresponds to the MySQL system variable\n[max_heap_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_heap_table_size)\n', 'minimum': 16384, 'maximum': 9223372036854775807, 'default': 16777216},
   'max_connections': {'type': 'integer', 'description': '("max_connections")', 'minimum': 151, 'maximum': 100000, 'default': 151},
   'max_prepared_stmt_count': {'type': 'integer', 'description': '("max_prepared_stmt_count")', 'minimum': 0, 'maximum': 4194304, 'default': 16382},
   'connect_timeout': {'type': 'integer', 'description': 'The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.\n\nconnectTimeout corresponds to the MySQL system variable\n[connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connect_timeout)\n\nIncreasing the connect_timeout value might help if clients frequently encounter errors of the form\n"Lost connection to MySQL server at \'XXX\', system error: errno".\n', 'minimum': 2, 'maximum': 31536000, 'default': 10},
   'cte_max_recursion_depth': {'type': 'integer', 'description': '("cte_max_recursion_depth")', 'minimum': 0, 'maximum': 4294967295, 'default': 1000},
   'generated_random_password_length': {'type': 'integer', 'description': '("generated_random_password_length") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 5, 'maximum': 255, 'default': 20},
   'information_schema_stats_expiry': {'type': 'integer', 'description': '("information_schema_stats_expiry")', 'minimum': 0, 'maximum': 31536000, 'default': 86400},
   'innodb_buffer_pool_dump_pct': {'type': 'integer', 'description': 'Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.\n\ninnodbBufferPoolDumpPct corresponds to the MySQL InnoDB system variable\n[innodb_buffer_pool_dump_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_dump_pct).\n\nThe range is 1 to 100. The default value is 25.\n\nFor example, if there are 4 buffer pools with 100 pages each, and innodb_buffer_pool_dump_pct is set to 25,\nthe 25 most recently used pages from each buffer pool are dumped.\n', 'minimum': 1, 'maximum': 100, 'default': 25},
   'innodb_buffer_pool_instances': {'type': 'integer', 'description': '("innodb_buffer_pool_instances")', 'minimum': 1, 'maximum': 64, 'default': 8},
   'innodb_ddl_buffer_size': {'type': 'integer', 'description': 'innodbDdlBufferSize corresponds to the MySQL system variable [innodb_ddl_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)\n', 'minimum': 65536, 'maximum': 4294967295, 'default': 1048576},
   'innodb_ddl_threads': {'type': 'integer', 'description': 'innodbDdlThreads corresponds to the MySQL system variable [innodb_ddl_threads] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)\n', 'minimum': 1, 'maximum': 64, 'default': 4},
   'innodb_ft_max_token_size': {'type': 'integer', 'description': '("innodb_ft_max_token_size")', 'minimum': 10, 'maximum': 84, 'default': 84},
   'innodb_ft_min_token_size': {'type': 'integer', 'description': '("innodb_ft_min_token_size")', 'minimum': 0, 'maximum': 16, 'default': 3},
   'innodb_ft_num_word_optimize': {'type': 'integer', 'description': '("innodb_ft_num_word_optimize")', 'default': 2000},
   'innodb_lock_wait_timeout': {'type': 'integer', 'description': '("innodb_lock_wait_timeout")', 'minimum': 1, 'maximum': 1073741824, 'default': 50},
   'innodb_max_purge_lag': {'type': 'integer', 'description': 'The desired maximum purge lag in terms of transactions.\n\nInnoDB maintains a list of transactions that have index records delete-marked by UPDATE or DELETE operations. The length of the list is the purge lag.\n\nIf this value is exceeded, a delay is imposed on INSERT, UPDATE, and DELETE operations to allow time for purge to catch up.\n\nThe default value is 0, which means there is no maximum purge lag and no delay.\n\ninnodbMaxPurgeLag corresponds to the MySQL server system variable\n[innodb_max_purge_lag](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag).\n', 'minimum': 0, 'maximum': 4294967295, 'default': 0},
   'innodb_max_purge_lag_delay': {'type': 'integer', 'description': 'The maximum delay in microseconds for the delay imposed when the innodb_max_purge_lag threshold is exceeded.\n\nThe specified innodb_max_purge_lag_delay value is an upper limit on the delay period.\n\ninnodbMaxPurgeLagDelay corresponds to the MySQL server system variable\n[innodb_max_purge_lag_delay](https://dev.mysql.com/doc/refman/en/innodb-parameters.html#sysvar_innodb_max_purge_lag_delay).\n', 'minimum': 0, 'maximum': 1000000, 'default': 0},
   'interactive_timeout': {'type': 'integer', 'description': 'The number of seconds the server waits for activity on an interactive connection before closing it.\n\ninteractiveTimeout corresponds to the MySQL system variable.\n[interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_interactive_timeout)\n', 'minimum': 1, 'maximum': 31536000, 'default': 28800},
   'innodb_stats_persistent_sample_pages': {'type': 'integer', 'description': 'The number of index pages to sample when estimating cardinality and other statistics for an indexed column,\nsuch as those calculated by ANALYZE TABLE.\n\ninnodbStatsPersistentSamplePages corresponds to the MySQL InnoDB system variable\n[innodb_stats_persistent_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_persistent_sample_pages)\n\ninnodb_stats_persistent_sample_pages only applies when innodb_stats_persistent is enabled for a table;\nwhen innodb_stats_persistent is disabled, innodb_stats_transient_sample_pages applies instead.\n', 'minimum': 1, 'maximum': 9223372036854775807, 'default': 20},
   'innodb_stats_transient_sample_pages': {'type': 'integer', 'description': 'The number of index pages to sample when estimating cardinality and other statistics for an indexed column,\nsuch as those calculated by [ANALYZE TABLE](https://dev.mysql.com/doc/refman/8.0/en/analyze-table.html).\n\ninnodbStatsTransientSamplePages corresponds to the MySQL InnoDB system variable\n[innodb_stats_transient_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_transient_sample_pages)\n\ninnodb_stats_transient_sample_pages only applies when innodb_stats_persistent is disabled for a table;\nwhen innodb_stats_persistent is enabled, innodb_stats_persistent_sample_pages applies instead.\n\ninnodb_stats_persistent is ON by default and cannot be changed. It is possible to override it using the\nSTATS_PERSISTENT clause of the [CREATE TABLE](https://dev.mysql.com/doc/refman/8.0/en/create-table.html) and\n[ALTER TABLE](https://dev.mysql.com/doc/refman/8.0/en/alter-table.html) statements.\n', 'minimum': 1, 'maximum': 9223372036854775807, 'default': 8},
   'innodb_strict_mode': {'type': 'boolean', 'description': 'When you enable innodbStrictMode, the InnoDB storage engine returns errors instead of warnings for invalid or incompatible table options.\n\ninnodbStrictMode corresponds to the MySQL InnoDB system variable\n[innodb_strict_mode](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_strict_mode)\n', 'default': True},
   'max_allowed_packet': {'type': 'integer', 'description': 'The maximum size of one packet or any generated/intermediate string.\n\nThis is the mysql variable "max_allowed_packet".\n', 'minimum': 67108864, 'maximum': 1073741824, 'default': 67108864},
   'max_execution_time': {'type': 'integer', 'description': '("max_execution_time")', 'minimum': 0, 'maximum': 9223372036854775807, 'default': 0},
   'mysqlx_connect_timeout': {'type': 'integer', 'description': '("mysqlx_connect_timeout") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 1, 'maximum': 1000000000, 'default': 30},
   'mysqlx_document_id_unique_prefix': {'type': 'integer', 'description': '("mysqlx_document_id_unique_prefix") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 0, 'maximum': 65535, 'default': 0},
   'mysqlx_idle_worker_thread_timeout': {'type': 'integer', 'description': '("mysqlx_idle_worker_thread_timeout") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 0, 'maximum': 3600, 'default': 60},
   'mysqlx_interactive_timeout': {'type': 'integer', 'description': '("mysqlx_interactive_timeout") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 1, 'maximum': 2147483, 'default': 28800},
   'mysqlx_max_allowed_packet': {'type': 'integer', 'description': 'The maximum size of network packets that can be received by X Plugin.\n\nThis is the mysql variable "mysqlx_max_allowed_packet".\n', 'minimum': 67108864, 'maximum': 1073741824, 'default': 67108864},
   'mysqlx_min_worker_threads': {'type': 'integer', 'description': '("mysqlx_min_worker_threads") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 1, 'maximum': 100, 'default': 2},
   'mysqlx_read_timeout': {'type': 'integer', 'description': '("mysqlx_read_timeout") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 30, 'maximum': 2147483, 'default': 28800},
   'mysqlx_wait_timeout': {'type': 'integer', 'description': '("mysqlx_wait_timeout") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 1, 'maximum': 2147483, 'default': 28800},
   'mysqlx_write_timeout': {'type': 'integer', 'description': '("mysqlx_write_timeout") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 1, 'maximum': 2147483, 'default': 60},
   'net_read_timeout': {'type': 'integer', 'description': 'The number of seconds to wait for more data from a connection before aborting the read.\n\nnetReadTimeout corresponds to the MySQL system variable\n[net_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_read_timeout)\n', 'minimum': 1, 'maximum': 31536000, 'default': 30},
   'net_write_timeout': {'type': 'integer', 'description': 'The number of seconds to wait for a block to be written to a connection before aborting the write.\n\nnetWriteTimeout corresponds to the MySQL system variable\n[net_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_write_timeout)\n', 'minimum': 1, 'maximum': 31536000, 'default': 60},
   'parser_max_mem_size': {'type': 'integer', 'description': '("parser_max_mem_size")', 'minimum': 10000000, 'maximum': 9223372036854775807},
   'query_alloc_block_size': {'type': 'integer', 'description': '("query_alloc_block_size") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 1024, 'maximum': 4294967295, 'default': 8192},
   'query_prealloc_size': {'type': 'integer', 'description': '("query_prealloc_size") DEPRECATED -- variable should not be settable and will be ignored', 'minimum': 8192, 'maximum': 9223372036854775807, 'default': 8192},
   'regexp_time_limit': {'type': 'integer', 'description': 'regexpTimeLimit corresponds to the MySQL system variable [regexp_time_limit] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)\n', 'minimum': 0, 'maximum': 2147483647, 'default': 32},
   'sql_mode': {'type': 'string', 'description': '("sql_mode")', 'default': 'ONLY_FULL_GROUP_BY,\nSTRICT_TRANS_TABLES,\nNO_ZERO_IN_DATE,\nNO_ZERO_DATE,\nERROR_FOR_DIVISION_BY_ZERO,\nNO_ENGINE_SUBSTITUTION\n'},
   'tmp_table_size': {'type': 'integer', 'description': 'The maximum size of internal in-memory temporary tables. This variable does not apply to user-created MEMORY tables.\n\ntmp_table_size corresponds to the MySQL system variable\n[tmp_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tmp_table_size)\n', 'minimum': 1024, 'maximum': 9223372036854775807, 'default': 16777216},
   'mysqlx_deflate_default_compression_level': {'type': 'integer', 'description': 'Set the default compression level for the deflate algorithm. ("mysqlx_deflate_default_compression_level")', 'minimum': 1, 'maximum': 9, 'default': 3},
   'mysqlx_deflate_max_client_compression_level': {'type': 'integer', 'description': 'Limit the upper bound of accepted compression levels for the deflate algorithm. ("mysqlx_deflate_max_client_compression_level")', 'minimum': 1, 'maximum': 9, 'default': 5},
   'mysqlx_lz_4_max_client_compression_level': {'type': 'integer', 'description': 'Limit the upper bound of accepted compression levels for the lz4 algorithm. ("mysqlx_lz4_max_client_compression_level")', 'minimum': 0, 'maximum': 16, 'default': 8},
   'mysqlx_lz_4_default_compression_level': {'type': 'integer', 'description': 'Set the default compression level for the lz4 algorithm. ("mysqlx_lz4_default_compression_level")', 'minimum': 0, 'maximum': 16, 'default': 2},
   'mysqlx_zstd_max_client_compression_level': {'type': 'integer', 'description': 'Limit the upper bound of accepted compression levels for the zstd algorithm. ("mysqlx_zstd_max_client_compression_level")', 'minimum': 1, 'maximum': 18, 'default': 11},
   'mysqlx_zstd_default_compression_level': {'type': 'integer', 'description': 'Set the default compression level for the zstd algorithm. ("mysqlx_zstd_default_compression_level")', 'minimum': 1, 'maximum': 18, 'default': 3},
   'mysql_zstd_default_compression_level': {'type': 'integer', 'description': 'DEPRECATED -- typo of mysqlx_zstd_default_compression_level. variable will be ignored.', 'minimum': 1, 'maximum': 18, 'default': 3},
   'sort_buffer_size': {'type': 'integer', 'description': 'Each session that must perform a sort allocates a buffer of this size.\n\nsortBufferSize corresponds to the MySQL system variable [sort_buffer_size](https://dev.mysql.com/doc/refman/en/server-system-variables.html#sysvar_sort_buffer_size)\n', 'minimum': 32768, 'maximum': 9223372036854775807, 'default': 262144},
   'wait_timeout': {'type': 'integer', 'description': 'The number of seconds the server waits for activity on a noninteractive connection before closing it.\n\nwaitTimeout corresponds to the MySQL system variable.\n[wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_wait_timeout)\n', 'minimum': 1, 'maximum': 2147483, 'default': 28800},
   'thread_pool_dedicated_listeners': {'type': 'boolean', 'description': 'Controls whether the thread pool uses dedicated listener threads. If enabled, a listener thread in each thread group is dedicated to the task of listening\nfor network events from clients, ensuring that the maximum number of query worker threads is no more than the value specified by threadPoolMaxTransactionsLimit.\nthreadPoolDedicatedListeners corresponds to the MySQL HeatWave Service-specific system variable thread_pool_dedicated_listeners.\n', 'default': False},
   'thread_pool_max_transactions_limit': {'type': 'integer', 'description': 'Limits the maximum number of open transactions to the defined value. The default value is 0, which enforces no limit.\nthreadPoolMaxTransactionsLimit corresponds to the MySQL HeatWave Service-specific system variable thread_pool_max_transactions_limit.\n', 'minimum': 0, 'maximum': 100000},
   'time_zone': {'type': 'string', 'description': 'Initializes the time zone for each client that connects.\n\nThis corresponds to the MySQL System Variable "time_zone".\n\nThe values can be given in one of the following formats, none of which are case-sensitive:\n\n- As a string indicating an offset from UTC of the form [H]H:MM, prefixed with a + or -, such as \'+10:00\', \'-6:00\', or \'+05:30\'. The permitted range is \'-13:59\' to \'+14:00\', inclusive.\n- As a named time zone, as defined by the "IANA Time Zone database", such as \'Europe/Helsinki\', \'US/Eastern\', \'MET\', or \'UTC\'.\n', 'default': 'UTC'},
   'block_encryption_mode': {'type': 'string', 'description': 'This variable controls the block encryption mode for block-based algorithms such as AES. It affects encryption for AES_ENCRYPT() and AES_DECRYPT().\n \nblock_encryption_mode takes a value in aes-keylen-mode format, where keylen is the key length in bits and mode is the encryption mode. The value is not case-sensitive.\nPermitted keylen values are 128, 192, and 256. Permitted mode values are ECB, CBC, CFB1, CFB8, CFB128, and OFB.\n\nblock_encryption_mode corresponds to the MySQL Server Administration system variable\n[block_encryption_mode](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_block_encryption_mode)\n'},
   'binlog_group_commit_sync_delay': {'type': 'integer', 'description': 'Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk.\nThere is no delay by default. Setting this variable to a microsecond delay enables more transactions to be synchronized\ntogether to disk at once, reducing the overall time to commit a group of transactions because the larger groups required\nfewer time units per group.\n\nbinlogGroupCommitSyncDelay corresponds to the MySQL Replication system variable\n[binlog_group_commit_sync_delay](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_delay)\n', 'minimum': 0, 'maximum': 1000000},
   'binlog_group_commit_sync_no_delay_count': {'type': 'integer', 'description': 'The maximum number of transactions to wait for before aborting the current delay as specified by binlog_group_commit_sync_delay.\nIf binlog_group_commit_sync_delay is set to 0, then this option has no effect.\n\nbinlogGroupCommitSyncNoDelayCount corresponds to the MySQL Replication system variable\n[binlog_group_commit_sync_no_delay_count](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_no_delay_count)\n', 'minimum': 0, 'maximum': 100000},
   'replica_net_timeout': {'type': 'integer', 'description': 'Specifies the number of seconds to wait for more data or a heartbeat signal from the source before the replica considers the connection broken,\naborts the read, and tries to reconnect. Setting this variable has no immediate effect. The state of the variable applies on all subsequent START REPLICA commands.\n\nreplicaNetTimeout corresponds to the MySQL Replica server system variable\n[replica_net_timeout](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_net_timeout)\n', 'minimum': 1, 'maximum': 31536000},
   'require_secure_transport': {'type': 'boolean', 'description': 'Whether client connections to the server are required to use some form of secure transport.\nWhen this variable is enabled, the server permits only TCP/IP connections encrypted using TLS/SSL, or connections that use a socket file or shared memory.\nThe server rejects nonsecure connection attempts, which fail with an ER_SECURE_TRANSPORT_REQUIRED error.\n\nrequire_secure_transport corresponds to the MySQL Server Administration system variable\n[require_secure_transport](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_require_secure_transport)\n'},
   'innodb_redo_log_capacity': {'type': 'integer', 'description': 'Defines the amount of disk space occupied by redo log files. innodb_redo_log_capacity supercedes the innodb_log_files_in_group and innodb_log_file_size variables,\nwhich are both ignored if innodb_redo_log_capacity is defined. If innodb_redo_log_capacity is not defined, and if neither innodb_log_file_size or innodb_log_files_in_group are defined,\nthen the default innodb_redo_log_capacity value is used.\n\ninnodbRedoLogCapacity corresponds to the InnoDB Startup Options and System Variables\n[innodb_redo_log_capacity](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_redo_log_capacity)\n', 'minimum': 8388608, 'maximum': 137438953472},
   'thread_pool_transaction_delay': {'type': 'integer', 'description': 'The delay period before executing a new transaction, in milliseconds. The maximum value is 300000 (5 minutes).\nA transaction delay can be used in cases where parallel transactions affect the performance of other operations due to resource contention.\nFor example, if parallel transactions affect index creation or an online buffer pool resizing operation,\nyou can configure a transaction delay to reduce resource contention while those operations are running. \n\nthreadPoolTransactionDelay corresponds to the MySQL Server system variable\n[thread_pool_transaction_delay](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_transaction_delay)\n', 'minimum': 0, 'maximum': 300000},
   'thread_pool_query_threads_per_group': {'type': 'integer', 'description': 'The maximum number of query threads permitted in a thread group.\nThe maximum value is 4096, but if thread_pool_max_transactions_limit is set, thread_pool_query_threads_per_group must not exceed that value.\nThe default value of 1 means there is one active query thread in each thread group, which works well for many loads.\nWhen you are using the high concurrency thread pool algorithm (thread_pool_algorithm = 1),\nconsider increasing the value if you experience slower response times due to long-running transactions. \n\nthreadPoolQueryThreadsPerGroup corresponds to the MySQL Server system variable\n[thread_pool_query_threads_per_group](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_query_threads_per_group)\n', 'minimum': 1, 'maximum': 4096},
   'explain_format': {'type': 'string', 'enum': ['TRADITIONAL', 'JSON', 'TREE'], 'description': 'This variable determines the default output format used by EXPLAIN in the absence of a FORMAT option when displaying a query execution plan.\n\nexplainFormat corresponds to the MySQL system variable\n[explain_format](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explain_format).\n'},
   'explicit_defaults_for_timestamp': {'type': 'boolean', 'description': 'This system variable determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns.\nBy default, explicit_defaults_for_timestamp is enabled, which disables the nonstandard behaviors. Disabling explicit_defaults_for_timestamp results in a warning.\n\nexplicit_defaults_for_timestamp corresponds to the MySQL Server Administration system variable\n[explicit_defaults_for_timestamp](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explicit_defaults_for_timestamp)\n'},
   'sql_generate_invisible_primary_key': {'type': 'boolean', 'description': 'Whether GIPK mode is in effect, in which case a MySQL replication source server adds a generated invisible primary key to any InnoDB table that is created without one.\n\nsqlGenerateInvisiblePrimaryKey corresponds to the MySQL system variable\n[sql_generate_invisible_primary_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_generate_invisible_primary_key).\n'},
   'temptable_max_ram': {'type': 'integer', 'description': 'Defines the maximum amount of memory that can be occupied by the TempTable storage engine before it starts storing data on disk.\nThe default value is 1073741824 bytes (1GiB). For more information, see Section 10.4.4, “Internal Temporary Table Use in MySQL”.\n\ntemptableMaxRam corresponds to the MySQL system variable\n[temptable_max_ram] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_temptable_max_ram).\n', 'minimum': 2097152, 'maximum': 9223372036854775807},
   'innodb_change_buffering': {'type': 'string', 'enum': ['NONE', 'INSERTS', 'DELETES', 'CHANGES', 'PURGES', 'ALL'], 'description': 'Whether InnoDB performs change buffering, an optimization that delays write operations to secondary indexes so that the I/O operations can be performed sequentially.\nPermitted values are described in the following table. Values may also be specified numerically.\n\ninnodbChangeBuffering corresponds to the MySQL InnoDB Startup Options and System Variables\n[innodb_change_buffering] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_change_buffering).\n'},
   'innodb_adaptive_hash_index': {'type': 'boolean', 'description': 'Whether the InnoDB adaptive hash index is enabled or disabled.\nIt may be desirable, depending on your workload, to dynamically enable or disable adaptive hash indexing to improve query performance.\nBecause the adaptive hash index may not be useful for all workloads, conduct benchmarks with it both enabled and disabled, using realistic workloads.\n\ninnodbAdaptiveHashIndex corresponds to the MySQL InnoDB Startup Options and System Variables\n[innodb_adaptive_hash_index] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_hash_index).\n'},
   'innodb_undo_log_truncate': {'type': 'boolean', 'description': 'When enabled, undo tablespaces that exceed the threshold value defined by innodb_max_undo_log_size are marked for truncation.\nOnly undo tablespaces can be truncated. Truncating undo logs that reside in the system tablespace is not supported.\nFor truncation to occur, there must be at least two undo tablespaces.\n\ninnodbUndoLogTruncate corresponds to the MySQL InnoDB Startup Options and System Variables\n[innodb_undo_log_truncate] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_undo_log_truncate).\n'},
   'table_definition_cache': {'type': 'integer', 'description': 'The number of table definitions that can be stored in the table definition cache.\nIf you use a large number of tables, you can create a large table definition cache to speed up opening of tables.\nThe table definition cache takes less space and does not use file descriptors, unlike the normal table cache.\n\ntable_definition_cache corresponds to the MySQL Server Administration system variable\n[table_definition_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_definition_cache)\n', 'minimum': 400, 'maximum': 524288},
   'table_open_cache': {'type': 'integer', 'description': 'The number of open tables for all threads. Increasing this value increases the number of file descriptors that mysqld requires.\n\ntable_open_cache corresponds to the MySQL Server Administration system variable\n[table_open_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache)\n', 'minimum': 1, 'maximum': 524288},
   'relay_log_space_limit': {'type': 'integer', 'description': 'The maximum amount of space to use for all relay logs.\n\nrelayLogSpaceLimit corresponds to the MySQL Replica Server Options variable\n[relay_log_space_limit] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_space_limit).\n', 'minimum': 0, 'maximum': 9223372036854775807},
   'optimizer_switch': {'type': 'string', 'description': 'The optimizer_switch system variable enables control over optimizer behavior.\nThe value of this variable is a set of flags, each of which has a value of on or off to indicate whether the corresponding optimizer behavior is enabled or disabled.\nThis variable has global and session values and can be changed at runtime. The global default can be set at server startup.\n\nSetting hypergraph_optimizer=on for cloud builds below 9.0.0 will fail.\n\noptimizerSwitch corresponds to the MySQL Server System variable\n[optimizer_switch] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_switch).\n'},
   'replica_type_conversions': {'type': 'string', 'description': 'From MySQL 8.0.26, use replica_type_conversions in place of slave_type_conversions, which is deprecated from that release.\nIn releases before MySQL 8.0.26, use slave_type_conversions.\n\nreplica_type_conversions controls the type conversion mode in effect on the replica when using row-based replication.\nIts value is a comma-delimited set of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY, ALL_SIGNED, ALL_UNSIGNED.\nSet this variable to an empty string to disallow type conversions between the source and the replica.\nSetting this variable takes effect for all replication channels immediately, including running channels. \n\nreplica_type_conversions corresponds to the MySQL Replica Server Options variable\n[replica_type_conversions] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_type_conversions).\n'},
   'replica_parallel_workers': {'type': 'integer', 'description': 'Beginning with MySQL 8.0.26, slave_parallel_workers is deprecated, and you should use replica_parallel_workers instead.\n(Prior to MySQL 8.0.26, you must use slave_parallel_workers to set the number of applier threads.)\n\nreplicaParallelWorkers corresponds to the MySQL Replica Server Options variable\n[replica_parallel_workers] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_parallel_workers).\n', 'minimum': 0, 'maximum': 1024},
   'skip_name_resolve': {'type': 'boolean', 'description': 'Whether to resolve host names when checking client connections. If this variable is OFF, mysqld resolves host names when checking client connections.\nIf it is ON, mysqld uses only IP numbers; in this case, all Host column values in the grant tables must be IP addresses.\nSee Section 7.1.12.3, “DNS Lookups and the Host Cache”.\n\nskipNameResolve corresponds to the MySQL Server System variable\n[skip_name_resolve] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_name_resolve).\n'},
   'max_user_connections': {'type': 'integer', 'description': 'The maximum number of simultaneous connections permitted to any given MySQL user account.\nA value of 0 (the default) means “no limit.” This variable has a global value that can be set at server startup or runtime.\nIt also has a read-only session value that indicates the effective simultaneous-connection limit that applies to the account associated with the current session.\n\nmaxUserConnections corresponds to the MySQL Server System variable\n[max_user_connections] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_user_connections).\n', 'minimum': 0, 'maximum': 4294967295},
   'join_buffer_size': {'type': 'integer', 'description': 'The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans.\nIn MySQL 8.0.18 and later, this variable also controls the amount of memory used for hash joins. Normally, the best way to get fast joins is to add indexes.\nIncrease the value of join_buffer_size to get a faster full join when adding indexes is not possible. One join buffer is allocated for each full join between two tables.\nFor a complex join between several tables for which indexes are not used, multiple join buffers might be necessary.\n\njoinBufferSize corresponds to the MySQL Server System variable\n[join_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_join_buffer_size).\n', 'minimum': 128, 'maximum': 9223372036854775807},
   'max_seeks_for_key': {'type': 'integer', 'description': 'Limit the assumed maximum number of seeks when looking up rows based on a key.\nThe MySQL optimizer assumes that no more than this number of key seeks are required when searching for matching rows in a table by scanning an index,\nregardless of the actual cardinality of the index (see Section 15.7.7.22, “SHOW INDEX Statement”).\nBy setting this to a low value (say, 100), you can force MySQL to prefer indexes instead of table scans.\n\nmaxSeeksForKey corresponds to the MySQL Server System variable\n[max_seeks_for_key] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_seeks_for_key).\n', 'minimum': 1, 'maximum': 9223372036854775807},
   'range_optimizer_max_mem_size': {'type': 'integer', 'description': 'The limit on memory consumption for the range optimizer. A value of 0 means “no limit.”\nIf an execution plan considered by the optimizer uses the range access method but the optimizer estimates that the amount of memory needed for this method would exceed the limit,\nit abandons the plan and considers other plans. \n\nrangeOptimizerMaxMemSize corresponds to the MySQL Server System variable\n[range_optimizer_max_mem_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_range_optimizer_max_mem_size).\n', 'minimum': 0, 'maximum': 9223372036854775807},
   'auto_increment_increment': {'type': 'integer', 'description': 'auto_increment_increment and auto_increment_offset are intended for use with circular (source-to-source) replication,\nand can be used to control the operation of AUTO_INCREMENT columns. Both variables have global and session values,\nand each can assume an integer value between 1 and 65,535 inclusive.\n\nautoIncrementIncrement corresponds to the MySQL Replication Source Options variable\n[auto_increment_increment] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_increment).\n', 'minimum': 1, 'maximum': 65535},
   'auto_increment_offset': {'type': 'integer', 'description': 'This variable has a default value of 1. If it is left with its default value,\nand Group Replication is started on the server in multi-primary mode, it is changed to the server ID.\n\nautoIncrementOffset corresponds to the MySQL Replication Source Options variable\n[auto_increment_offset] (https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_offset).\n', 'minimum': 1, 'maximum': 65535},
   'innodb_autoinc_lock_mode': {'type': 'integer', 'description': 'The lock mode to use for generating auto-increment values.\nPermissible values are 0, 1, or 2, for traditional, consecutive, or interleaved, respectively.\n\ninnodbAutoincLockMode corresponds to the MySQL InnoDB Startup Options and System Variables\n[innodb_autoinc_lock_mode] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_autoinc_lock_mode).\n'},
   'innodb_rollback_on_timeout': {'type': 'boolean', 'description': 'InnoDB rolls back only the last statement on a transaction timeout by default.\nIf --innodb-rollback-on-timeout is specified, a transaction timeout causes InnoDB to abort and roll back the entire transaction.\n\ninnodbRollbackOnTimeout corresponds to the MySQL InnoDB Startup Options and System Variables\n[innodb_rollback_on_timeout] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_rollback_on_timeout).\n'},
   'innodb_online_alter_log_max_size': {'type': 'integer', 'description': 'Specifies an upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.\nThere is one such log file for each index being created or table being altered.\nThis log file stores data inserted, updated, or deleted in the table during the DDL operation.\n\ninnodbOnlineAlterLogMaxSize corresponds to the MySQL InnoDB Startup Options and System Variables\n[innodb_online_alter_log_max_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_online_alter_log_max_size).\n', 'minimum': 65536, 'maximum': 9223372036854775807},
   'innodb_sort_buffer_size': {'type': 'integer', 'description': 'This variable defines:\n\n* The sort buffer size for online DDL operations that create or rebuild secondary indexes.\n  However, as of MySQL 8.0.27, this responsibility is subsumed by the innodb_ddl_buffer_size variable.\n\n* The amount by which the temporary log file is extended when recording concurrent DML during an online DDL operation,\n  and the size of the temporary log file read buffer and write buffer.\n\ninnodbSortBufferSize corresponds to the MySQL InnoDB Startup Options and System Variables\n[innodb_sort_buffer_size] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_sort_buffer_size).\n', 'minimum': 65536, 'maximum': 67108864},
   'innodb_numa_interleave': {'type': 'boolean', 'description': 'Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool.\nWhen innodb_numa_interleave is enabled, the NUMA memory policy is set to MPOL_INTERLEAVE for the mysqld process.\nAfter the InnoDB buffer pool is allocated, the NUMA memory policy is set back to MPOL_DEFAULT.\nFor the innodb_numa_interleave option to be available, MySQL must be compiled on a NUMA-enabled Linux system.\n\ninnodbNumaInterleave corresponds to the MySQL InnoDB Startup Options and System Variables\n[innodb_numa_interleave] (https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_numa_interleave).\n'},
   'thread_pool_size': {'type': 'integer', 'description': 'The number of thread groups in the thread pool. This is the most important parameter controlling thread pool performance.\nIt affects how many statements can execute simultaneously. If a value outside the range of permissible values is specified,\nthe thread pool plugin does not load and the server writes a message to the error log.\n\nthreadPoolSize corresponds to the MySQL Server System variable\n[thread_pool_size] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_size).\n', 'minimum': 1, 'maximum': 512},
   'long_query_time': {'type': 'integer', 'description': 'If a query takes longer than this many seconds, the server increments the Slow_queries status variable.\nIf the slow query log is enabled, the query is logged to the slow query log file.\nThis value is measured in real time, not CPU time,\nso a query that is under the threshold on a lightly loaded system might be above the threshold on a heavily loaded one.\n\nlongQueryTime corresponds to the MySQL Server System variable\n[long_query_time] (https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_long_query_time).\n', 'minimum': 0, 'maximum': 31536000},
}
