-- Copyright (c) 2025, Oracle and/or its affiliates.
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License, version 2.0,
-- as published by the Free Software Foundation.
--
-- This program is designed to work with certain software (including
-- but not limited to OpenSSL) that is licensed under separate terms, as
-- designated in a particular file or component or in included license
-- documentation.  The authors of MySQL hereby grant you an additional
-- permission to link the program and your derivative works with the
-- separately licensed software that they have either included with
-- the program or referenced in the documentation.
--
-- This program is distributed in the hope that it will be useful,  but
-- WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
-- the GNU General Public License, version 2.0, for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software Foundation, Inc.,
-- 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

CREATE SCHEMA `compatibility_issues`;
CREATE SCHEMA `compatibility_issues_skipped`;
USE `compatibility_issues`;

CREATE USER 'unsupported_auth_plugin'@'localhost' IDENTIFIED WITH mysql_no_login;

CREATE USER 'deprecated_auth_plugin'@'localhost' IDENTIFIED WITH sha256_password BY 'zaq12WSX';

CREATE USER 'no_password'@'localhost' IDENTIFIED WITH caching_sha2_password BY '';

CREATE USER 'restricted_grants'@'localhost' IDENTIFIED WITH caching_sha2_password BY 'zaq12WSX';
GRANT FILE ON *.* TO 'restricted_grants'@'localhost';

CREATE USER 'invalid_grants'@'localhost' IDENTIFIED WITH caching_sha2_password BY 'zaq12WSX';
CREATE TABLE `invalid_grants_t` (id INT PRIMARY KEY, data INT);
CREATE VIEW `invalid_grants_v` AS SELECT * FROM `invalid_grants_t`;
GRANT SELECT ON `compatibility_issues`.`invalid_grants_t` TO 'invalid_grants'@'localhost';
GRANT SELECT ON `compatibility_issues`.`invalid_grants_v` TO 'invalid_grants'@'localhost';
DROP VIEW `invalid_grants_v`;

CREATE USER 'wildcard_grant'@'localhost' IDENTIFIED WITH caching_sha2_password BY 'zaq12WSX';
GRANT SELECT ON `compatibility_issues%`.* TO 'wildcard_grant'@'localhost';

CREATE USER 'escaped_wildcard_grant'@'localhost' IDENTIFIED WITH caching_sha2_password BY 'zaq12WSX';
GRANT SELECT ON `compatibility_issues\%`.* TO 'escaped_wildcard_grant'@'localhost';

CREATE USER 'grant_on_missing_object'@'localhost' IDENTIFIED WITH caching_sha2_password BY 'zaq12WSX';
CREATE TABLE `compatibility_issues_skipped`.`grant_on_missing_object` (id INT PRIMARY KEY, data INT);
GRANT SELECT ON `compatibility_issues_skipped`.`grant_on_missing_object` TO 'grant_on_missing_object'@'localhost';

CREATE USER 'grant_on_missing_role'@'localhost' IDENTIFIED WITH caching_sha2_password BY 'zaq12WSX';
CREATE ROLE 'skipped_role';
GRANT 'skipped_role' TO 'grant_on_missing_role'@'localhost';

CREATE TABLE `compatibility_issues_skipped`.`invalid_reference` (id INT PRIMARY KEY, data INT);
CREATE VIEW `invalid_reference` AS SELECT * FROM `compatibility_issues_skipped`.`invalid_reference`;

CREATE TABLE `invalid_definition_t` (id INT PRIMARY KEY, data INT);
CREATE VIEW `invalid_definition_v1` AS SELECT max(data) FROM `invalid_definition_t`;
CREATE VIEW `invalid_definition_v` AS SELECT * FROM `invalid_definition_v1`;
DROP VIEW `invalid_definition_v1`;

CREATE TABLE `unsupported_engine` (id INT PRIMARY KEY, data INT) ENGINE=MyISAM;

CREATE TABLE `incompatible_with_innodb` (a INT, b INT AUTO_INCREMENT, PRIMARY KEY (a, b)) ENGINE=MyISAM;

CREATE TABLE `missing_pk` (data INT);

CREATE TABLE `missing_pk_manual_fix` (col1 INT NOT NULL, UNIQUE KEY (col1)) PARTITION BY HASH(col1) PARTITIONS 4;

CREATE TABLESPACE `t_space` ADD DATAFILE 't_s_1.ibd' ENGINE=InnoDB;
CREATE TABLE `t_space` (id INT PRIMARY KEY, data INT) TABLESPACE `t_space`;

CREATE TABLE `unsupported_row_format` (id INT PRIMARY KEY, data INT) ENGINE=MyISAM ROW_FORMAT=FIXED;

CREATE TABLE `too_many_columns` (id INT PRIMARY KEY, c0 INT, c1 INT, c2 INT, c3 INT, c4 INT, c5 INT, c6 INT, c7 INT, c8 INT, c9 INT, c10 INT, c11 INT, c12 INT, c13 INT, c14 INT, c15 INT, c16 INT, c17 INT, c18 INT, c19 INT, c20 INT, c21 INT, c22 INT, c23 INT, c24 INT, c25 INT, c26 INT, c27 INT, c28 INT, c29 INT, c30 INT, c31 INT, c32 INT, c33 INT, c34 INT, c35 INT, c36 INT, c37 INT, c38 INT, c39 INT, c40 INT, c41 INT, c42 INT, c43 INT, c44 INT, c45 INT, c46 INT, c47 INT, c48 INT, c49 INT, c50 INT, c51 INT, c52 INT, c53 INT, c54 INT, c55 INT, c56 INT, c57 INT, c58 INT, c59 INT, c60 INT, c61 INT, c62 INT, c63 INT, c64 INT, c65 INT, c66 INT, c67 INT, c68 INT, c69 INT, c70 INT, c71 INT, c72 INT, c73 INT, c74 INT, c75 INT, c76 INT, c77 INT, c78 INT, c79 INT, c80 INT, c81 INT, c82 INT, c83 INT, c84 INT, c85 INT, c86 INT, c87 INT, c88 INT, c89 INT, c90 INT, c91 INT, c92 INT, c93 INT, c94 INT, c95 INT, c96 INT, c97 INT, c98 INT, c99 INT, c100 INT, c101 INT, c102 INT, c103 INT, c104 INT, c105 INT, c106 INT, c107 INT, c108 INT, c109 INT, c110 INT, c111 INT, c112 INT, c113 INT, c114 INT, c115 INT, c116 INT, c117 INT, c118 INT, c119 INT, c120 INT, c121 INT, c122 INT, c123 INT, c124 INT, c125 INT, c126 INT, c127 INT, c128 INT, c129 INT, c130 INT, c131 INT, c132 INT, c133 INT, c134 INT, c135 INT, c136 INT, c137 INT, c138 INT, c139 INT, c140 INT, c141 INT, c142 INT, c143 INT, c144 INT, c145 INT, c146 INT, c147 INT, c148 INT, c149 INT, c150 INT, c151 INT, c152 INT, c153 INT, c154 INT, c155 INT, c156 INT, c157 INT, c158 INT, c159 INT, c160 INT, c161 INT, c162 INT, c163 INT, c164 INT, c165 INT, c166 INT, c167 INT, c168 INT, c169 INT, c170 INT, c171 INT, c172 INT, c173 INT, c174 INT, c175 INT, c176 INT, c177 INT, c178 INT, c179 INT, c180 INT, c181 INT, c182 INT, c183 INT, c184 INT, c185 INT, c186 INT, c187 INT, c188 INT, c189 INT, c190 INT, c191 INT, c192 INT, c193 INT, c194 INT, c195 INT, c196 INT, c197 INT, c198 INT, c199 INT, c200 INT, c201 INT, c202 INT, c203 INT, c204 INT, c205 INT, c206 INT, c207 INT, c208 INT, c209 INT, c210 INT, c211 INT, c212 INT, c213 INT, c214 INT, c215 INT, c216 INT, c217 INT, c218 INT, c219 INT, c220 INT, c221 INT, c222 INT, c223 INT, c224 INT, c225 INT, c226 INT, c227 INT, c228 INT, c229 INT, c230 INT, c231 INT, c232 INT, c233 INT, c234 INT, c235 INT, c236 INT, c237 INT, c238 INT, c239 INT, c240 INT, c241 INT, c242 INT, c243 INT, c244 INT, c245 INT, c246 INT, c247 INT, c248 INT, c249 INT, c250 INT, c251 INT, c252 INT, c253 INT, c254 INT, c255 INT, c256 INT, c257 INT, c258 INT, c259 INT, c260 INT, c261 INT, c262 INT, c263 INT, c264 INT, c265 INT, c266 INT, c267 INT, c268 INT, c269 INT, c270 INT, c271 INT, c272 INT, c273 INT, c274 INT, c275 INT, c276 INT, c277 INT, c278 INT, c279 INT, c280 INT, c281 INT, c282 INT, c283 INT, c284 INT, c285 INT, c286 INT, c287 INT, c288 INT, c289 INT, c290 INT, c291 INT, c292 INT, c293 INT, c294 INT, c295 INT, c296 INT, c297 INT, c298 INT, c299 INT, c300 INT, c301 INT, c302 INT, c303 INT, c304 INT, c305 INT, c306 INT, c307 INT, c308 INT, c309 INT, c310 INT, c311 INT, c312 INT, c313 INT, c314 INT, c315 INT, c316 INT, c317 INT, c318 INT, c319 INT, c320 INT, c321 INT, c322 INT, c323 INT, c324 INT, c325 INT, c326 INT, c327 INT, c328 INT, c329 INT, c330 INT, c331 INT, c332 INT, c333 INT, c334 INT, c335 INT, c336 INT, c337 INT, c338 INT, c339 INT, c340 INT, c341 INT, c342 INT, c343 INT, c344 INT, c345 INT, c346 INT, c347 INT, c348 INT, c349 INT, c350 INT, c351 INT, c352 INT, c353 INT, c354 INT, c355 INT, c356 INT, c357 INT, c358 INT, c359 INT, c360 INT, c361 INT, c362 INT, c363 INT, c364 INT, c365 INT, c366 INT, c367 INT, c368 INT, c369 INT, c370 INT, c371 INT, c372 INT, c373 INT, c374 INT, c375 INT, c376 INT, c377 INT, c378 INT, c379 INT, c380 INT, c381 INT, c382 INT, c383 INT, c384 INT, c385 INT, c386 INT, c387 INT, c388 INT, c389 INT, c390 INT, c391 INT, c392 INT, c393 INT, c394 INT, c395 INT, c396 INT, c397 INT, c398 INT, c399 INT, c400 INT, c401 INT, c402 INT, c403 INT, c404 INT, c405 INT, c406 INT, c407 INT, c408 INT, c409 INT, c410 INT, c411 INT, c412 INT, c413 INT, c414 INT, c415 INT, c416 INT, c417 INT, c418 INT, c419 INT, c420 INT, c421 INT, c422 INT, c423 INT, c424 INT, c425 INT, c426 INT, c427 INT, c428 INT, c429 INT, c430 INT, c431 INT, c432 INT, c433 INT, c434 INT, c435 INT, c436 INT, c437 INT, c438 INT, c439 INT, c440 INT, c441 INT, c442 INT, c443 INT, c444 INT, c445 INT, c446 INT, c447 INT, c448 INT, c449 INT, c450 INT, c451 INT, c452 INT, c453 INT, c454 INT, c455 INT, c456 INT, c457 INT, c458 INT, c459 INT, c460 INT, c461 INT, c462 INT, c463 INT, c464 INT, c465 INT, c466 INT, c467 INT, c468 INT, c469 INT, c470 INT, c471 INT, c472 INT, c473 INT, c474 INT, c475 INT, c476 INT, c477 INT, c478 INT, c479 INT, c480 INT, c481 INT, c482 INT, c483 INT, c484 INT, c485 INT, c486 INT, c487 INT, c488 INT, c489 INT, c490 INT, c491 INT, c492 INT, c493 INT, c494 INT, c495 INT, c496 INT, c497 INT, c498 INT, c499 INT, c500 INT, c501 INT, c502 INT, c503 INT, c504 INT, c505 INT, c506 INT, c507 INT, c508 INT, c509 INT, c510 INT, c511 INT, c512 INT, c513 INT, c514 INT, c515 INT, c516 INT, c517 INT, c518 INT, c519 INT, c520 INT, c521 INT, c522 INT, c523 INT, c524 INT, c525 INT, c526 INT, c527 INT, c528 INT, c529 INT, c530 INT, c531 INT, c532 INT, c533 INT, c534 INT, c535 INT, c536 INT, c537 INT, c538 INT, c539 INT, c540 INT, c541 INT, c542 INT, c543 INT, c544 INT, c545 INT, c546 INT, c547 INT, c548 INT, c549 INT, c550 INT, c551 INT, c552 INT, c553 INT, c554 INT, c555 INT, c556 INT, c557 INT, c558 INT, c559 INT, c560 INT, c561 INT, c562 INT, c563 INT, c564 INT, c565 INT, c566 INT, c567 INT, c568 INT, c569 INT, c570 INT, c571 INT, c572 INT, c573 INT, c574 INT, c575 INT, c576 INT, c577 INT, c578 INT, c579 INT, c580 INT, c581 INT, c582 INT, c583 INT, c584 INT, c585 INT, c586 INT, c587 INT, c588 INT, c589 INT, c590 INT, c591 INT, c592 INT, c593 INT, c594 INT, c595 INT, c596 INT, c597 INT, c598 INT, c599 INT, c600 INT, c601 INT, c602 INT, c603 INT, c604 INT, c605 INT, c606 INT, c607 INT, c608 INT, c609 INT, c610 INT, c611 INT, c612 INT, c613 INT, c614 INT, c615 INT, c616 INT, c617 INT, c618 INT, c619 INT, c620 INT, c621 INT, c622 INT, c623 INT, c624 INT, c625 INT, c626 INT, c627 INT, c628 INT, c629 INT, c630 INT, c631 INT, c632 INT, c633 INT, c634 INT, c635 INT, c636 INT, c637 INT, c638 INT, c639 INT, c640 INT, c641 INT, c642 INT, c643 INT, c644 INT, c645 INT, c646 INT, c647 INT, c648 INT, c649 INT, c650 INT, c651 INT, c652 INT, c653 INT, c654 INT, c655 INT, c656 INT, c657 INT, c658 INT, c659 INT, c660 INT, c661 INT, c662 INT, c663 INT, c664 INT, c665 INT, c666 INT, c667 INT, c668 INT, c669 INT, c670 INT, c671 INT, c672 INT, c673 INT, c674 INT, c675 INT, c676 INT, c677 INT, c678 INT, c679 INT, c680 INT, c681 INT, c682 INT, c683 INT, c684 INT, c685 INT, c686 INT, c687 INT, c688 INT, c689 INT, c690 INT, c691 INT, c692 INT, c693 INT, c694 INT, c695 INT, c696 INT, c697 INT, c698 INT, c699 INT, c700 INT, c701 INT, c702 INT, c703 INT, c704 INT, c705 INT, c706 INT, c707 INT, c708 INT, c709 INT, c710 INT, c711 INT, c712 INT, c713 INT, c714 INT, c715 INT, c716 INT, c717 INT, c718 INT, c719 INT, c720 INT, c721 INT, c722 INT, c723 INT, c724 INT, c725 INT, c726 INT, c727 INT, c728 INT, c729 INT, c730 INT, c731 INT, c732 INT, c733 INT, c734 INT, c735 INT, c736 INT, c737 INT, c738 INT, c739 INT, c740 INT, c741 INT, c742 INT, c743 INT, c744 INT, c745 INT, c746 INT, c747 INT, c748 INT, c749 INT, c750 INT, c751 INT, c752 INT, c753 INT, c754 INT, c755 INT, c756 INT, c757 INT, c758 INT, c759 INT, c760 INT, c761 INT, c762 INT, c763 INT, c764 INT, c765 INT, c766 INT, c767 INT, c768 INT, c769 INT, c770 INT, c771 INT, c772 INT, c773 INT, c774 INT, c775 INT, c776 INT, c777 INT, c778 INT, c779 INT, c780 INT, c781 INT, c782 INT, c783 INT, c784 INT, c785 INT, c786 INT, c787 INT, c788 INT, c789 INT, c790 INT, c791 INT, c792 INT, c793 INT, c794 INT, c795 INT, c796 INT, c797 INT, c798 INT, c799 INT, c800 INT, c801 INT, c802 INT, c803 INT, c804 INT, c805 INT, c806 INT, c807 INT, c808 INT, c809 INT, c810 INT, c811 INT, c812 INT, c813 INT, c814 INT, c815 INT, c816 INT, c817 INT, c818 INT, c819 INT, c820 INT, c821 INT, c822 INT, c823 INT, c824 INT, c825 INT, c826 INT, c827 INT, c828 INT, c829 INT, c830 INT, c831 INT, c832 INT, c833 INT, c834 INT, c835 INT, c836 INT, c837 INT, c838 INT, c839 INT, c840 INT, c841 INT, c842 INT, c843 INT, c844 INT, c845 INT, c846 INT, c847 INT, c848 INT, c849 INT, c850 INT, c851 INT, c852 INT, c853 INT, c854 INT, c855 INT, c856 INT, c857 INT, c858 INT, c859 INT, c860 INT, c861 INT, c862 INT, c863 INT, c864 INT, c865 INT, c866 INT, c867 INT, c868 INT, c869 INT, c870 INT, c871 INT, c872 INT, c873 INT, c874 INT, c875 INT, c876 INT, c877 INT, c878 INT, c879 INT, c880 INT, c881 INT, c882 INT, c883 INT, c884 INT, c885 INT, c886 INT, c887 INT, c888 INT, c889 INT, c890 INT, c891 INT, c892 INT, c893 INT, c894 INT, c895 INT, c896 INT, c897 INT, c898 INT, c899 INT, c900 INT, c901 INT, c902 INT, c903 INT, c904 INT, c905 INT, c906 INT, c907 INT, c908 INT, c909 INT, c910 INT, c911 INT, c912 INT, c913 INT, c914 INT, c915 INT, c916 INT, c917 INT, c918 INT, c919 INT, c920 INT, c921 INT, c922 INT, c923 INT, c924 INT, c925 INT, c926 INT, c927 INT, c928 INT, c929 INT, c930 INT, c931 INT, c932 INT, c933 INT, c934 INT, c935 INT, c936 INT, c937 INT, c938 INT, c939 INT, c940 INT, c941 INT, c942 INT, c943 INT, c944 INT, c945 INT, c946 INT, c947 INT, c948 INT, c949 INT, c950 INT, c951 INT, c952 INT, c953 INT, c954 INT, c955 INT, c956 INT, c957 INT, c958 INT, c959 INT, c960 INT, c961 INT, c962 INT, c963 INT, c964 INT, c965 INT, c966 INT, c967 INT, c968 INT, c969 INT, c970 INT, c971 INT, c972 INT, c973 INT, c974 INT, c975 INT, c976 INT, c977 INT, c978 INT, c979 INT, c980 INT, c981 INT, c982 INT, c983 INT, c984 INT, c985 INT, c986 INT, c987 INT, c988 INT, c989 INT, c990 INT, c991 INT, c992 INT, c993 INT, c994 INT, c995 INT, c996 INT, c997 INT, c998 INT, c999 INT, c1000 INT, c1001 INT, c1002 INT, c1003 INT, c1004 INT, c1005 INT, c1006 INT, c1007 INT, c1008 INT, c1009 INT, c1010 INT, c1011 INT, c1012 INT, c1013 INT, c1014 INT, c1015 INT, c1016 INT) ENGINE=MyISAM;

CREATE USER 'ociadmin'@'localhost' IDENTIFIED WITH caching_sha2_password BY 'zaq12WSX';
CREATE TABLE `restricted_definer_t` (id INT PRIMARY KEY, data INT);
CREATE DEFINER='ociadmin'@'localhost' VIEW `restricted_definer_v` AS SELECT * FROM `restricted_definer_t`;

CREATE USER 'skipped_user'@'localhost' IDENTIFIED WITH caching_sha2_password BY 'zaq12WSX';
CREATE TABLE `invalid_definer_missing_user_t` (id INT PRIMARY KEY, data INT);
CREATE DEFINER='skipped_user'@'localhost' VIEW `invalid_definer_missing_user_v` AS SELECT * FROM `invalid_definer_missing_user_t`;
CREATE DEFINER='skipped_user'@'localhost' TRIGGER `invalid_definer_missing_user_tt` AFTER DELETE ON `invalid_definer_missing_user_t` FOR EACH ROW BEGIN END;
CREATE DEFINER='skipped_user'@'localhost' FUNCTION `invalid_definer_missing_user_f`() RETURNS INT DETERMINISTIC RETURN 1;
CREATE DEFINER='skipped_user'@'localhost' PROCEDURE `invalid_definer_missing_user_p`() DETERMINISTIC BEGIN END;
CREATE DEFINER='skipped_user'@'localhost' EVENT `invalid_definer_missing_user_e` ON SCHEDULE EVERY 1 YEAR DO BEGIN END;

CREATE USER 'valid_definer'@'localhost' IDENTIFIED WITH caching_sha2_password BY 'zaq12WSX';

/*!90200 CREATE LIBRARY `missing_dependency` LANGUAGE JAVASCRIPT AS $$ export function squared(n) { return n*n; } $$ */;
/*!90200 CREATE DEFINER='valid_definer'@'localhost' FUNCTION `missing_dependency`(n INTEGER) RETURNS INTEGER DETERMINISTIC LANGUAGE JAVASCRIPT USING (`missing_dependency` AS mylib) AS $$ return mylib.squared(n); $$ */;
/*!90200 DROP LIBRARY `missing_dependency` */;
