---
title: MySQL REST Service - Reference Manual
---

This book contains the documentation for the MySQL REST Service (MRS).

__Chapter Overview__

- [MRS Introduction](#introduction-to-the-mysql-rest-service)
- [MRS Deployment Architecture](#deployment-architecture)
- [MRS Configuration](#configuring-mysql-rest-service)
- [Adding REST Services and Database Objects](#adding-rest-services-and-database-objects)
- [GUI Interfaces for REST Service Configuration](#working-interactively-with-rest-services)
- [Authentication and Authorization](#authentication-and-authorization)
- [MRS Examples](#mrs-examples)
  - [MRS Notes Example](#mrs-notes-example)
  - [MRS Scripts Example](#mrs-scripts-example)

---

Please also see

- __[MySQL REST Service - Quickstart Guide](quickstart.html)__ - This book provides a hands-on approach to learning how to use the MySQL REST service.
- __[MySQL REST Service - SQL Reference](sql.html)__ - This book discusses the MySQL REST Service SQL Extension.
- __[MySQL REST Service - Core REST APIs](restApi.html)__ - This book provides examples of using the MySQL REST Service queries and other operations against tables and views after you have REST-enabled them.
- __[MySQL REST Service - SDK Reference](sdk.html)__ - This book explains how to work with the MRS Software Development Kit and discusses the Client APIs.

---

!include sections/devGuide/Introduction.md

!include sections/devGuide/Architecture.md

!include sections/devGuide/Configuration.md

!include sections/devGuide/AddingRESTServices.md

!include sections/devGuide/WorkingInteractively.md

!include sections/devGuide/RestViews.md

!include sections/devGuide/DialogReference.md

!include sections/devGuide/Auth.md

!include ../examples/readme.md

Copyright (c) 2022, 2025, Oracle and/or its affiliates.
