---
title: MySQL REST Service - Quickstart Guide
---

This book provides a hands-on approach to learning how to use the MySQL REST service. It shows how to set up and work with REST endpoints for MySQL database objects.

__Chapter Overview__

- [What is the MySQL REST Service](#quickstart-introduction)
- [Setting up the MySQL REST Service](#setting-up-the-mysql-rest-service)
- [Defining REST Endpoints](#defining-rest-endpoints)
- [Accessing REST Endpoints](#accessing-rest-endpoints)
- [Appendix](#quickstart-appendix)

---

Please also see

- __[MySQL REST Service - Reference Manual](index.html)__ - This book contains the documentation for the MySQL REST Service (MRS).
- __[MySQL REST Service - Core REST APIs](restApi.html)__ - This book provides examples of using the MySQL REST Service queries and other operations against tables and views after you have REST-enabled them.
- __[MySQL REST Service - SQL Reference](sql.html)__ - This book discusses the MySQL REST Service SQL Extension.
- __[MySQL REST Service - SDK Reference](sdk.html)__ - This book explains how to work with the MRS Software Development Kit and discusses the Client APIs.

---

!include sections/quickStart/Introduction.md

!include sections/quickStart/Setup.md

!include sections/quickStart/DefiningRestEndpoints.md

!include sections/quickStart/AccessingRestEndpoints.md

!include sections/quickStart/Appendix.md

Copyright (c) 2025, Oracle and/or its affiliates.
