---
title: MySQL REST Service DDL - SQL Extension Reference
---

This document discusses the MySQL REST Service (MRS) DDL - SQL Extension. The MRS DDL - SQL Extension adds a set of MRS specific DDL statements to the MySQL Shell SQL handling in order to provide a familiar management interface to MySQL developers and DBAs.

__Chapter Overview__

- [Introduction to the MRS DDL Extension](#introduction)
- [MRS SQL Reference: CONFIGURE and CREATE](#configure-and-create)
- [MRS SQL Reference: ALTER](#alter)
- [MRS SQL Reference: DROP](#drop)
- [MRS SQL Reference: GRANT and REVOKE](#grant-and-revoke)
- [MRS SQL Reference: USE and SHOW](#use-and-show)

---

Please also see

- __[MySQL REST Service - Developer's Guide](index.html)__ - This book explains how to install and configure the MySQL REST Service (MRS) as well as how to access the data through REST calls.
- __[MySQL REST Service - Quickstart Guide](quickstart.html)__ - This book provides a hands-on approach to learning how to use the MySQL REST service.
- __[MySQL REST Service - Core REST APIs](restApi.html)__ - This book provides examples of using the MySQL REST Service queries and other operations against tables and views after you have REST-enabled them.
- __[MySQL REST Service - SDK Reference](sdk.html)__ - This book explains how to work with the MRS Software Development Kit and discusses the Client APIs.

---

!include sections/sql/Introduction.md

!include sections/sql/ConfigureAndCreate.md

!include sections/sql/Alter.md

!include sections/sql/Drop.md

!include sections/sql/GrantAndRevoke.md

!include sections/sql/UseAndShow.md

!include sections/sql/Dump.md

Copyright (c) 2023, 2025, Oracle and/or its affiliates.
