/* Copyright (c) 2025, Oracle and/or its affiliates.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2.0,
as published by the Free Software Foundation.

This program is designed to work with certain software (including
but not limited to OpenSSL) that is licensed under separate terms,
as designated in a particular file or component or in included license
documentation.  The authors of MySQL hereby grant you an additional
permission to link the program and your derivative works with the
separately licensed software that they have either included with
the program or referenced in the documentation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License, version 2.0, for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */

#ifndef MYSQL_SERVER_ATTRIBUTES_H
#define MYSQL_SERVER_ATTRIBUTES_H

#include <mysql/components/service.h>

/**
  @ingroup group_components_services_inventory

  This service allows to read specific server attributes such as server id value
  and other custom attributes.
*/
BEGIN_SERVICE_DEFINITION(mysql_server_attributes)

/**
  Fetch server attribute value based on specified name.

  @param name         [in]  Attribute name. Allowed values are:
                            server_version [mysql_cstring_with_length type]
                            server_id      [ulong]
                            os_version     [mysql_cstring_with_length type]
                            argc           [int]
                            argv           [char**]
  @param inout_pvalue [out] Output value.

  @return Zero value on success.
*/
DECLARE_BOOL_METHOD(get, (const char *name, void *inout_pvalue));

END_SERVICE_DEFINITION(mysql_server_attributes)

#endif /* MYSQL_SERVER_ATTRIBUTES_H */
