\page PageLibsMysql MySQL Libraries

<!---
Copyright (c) 2023, 2025, Oracle and/or its affiliates.
//
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2.0,
as published by the Free Software Foundation.
//
This program is designed to work with certain software (including
but not limited to OpenSSL) that is licensed under separate terms, as
designated in a particular file or component or in included license
documentation. The authors of MySQL hereby grant you an additional
permission to link the program and your derivative works with the
separately licensed software that they have either included with
the program or referenced in the documentation.
//
This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
the GNU General Public License, version 2.0, for more details.
//
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
-->

MySQL Libraries
===============

MySQL Libraries contain code shared between different system components:
e.g. MySQL Server, MySQL Client, MySQL Components, MySQL Plugins.

MySQL Libraries define experimental API used internally in MySQL,
which is subject to change. Use on your own responsibility.

For now, we build only the static libraries.

Libraries defined on this level:
- \subpage PageLibsMysqlAllocators
- \subpage PageLibsMysqlBinlog
- \subpage PageLibsMysqlContainers
- \subpage PageLibsMysqlDebugging
- \subpage PageLibsMysqlGtid
- \subpage PageLibsMysqlIterators
- \subpage PageLibsMysqlMath
- \subpage PageLibsMysqlMeta
- \subpage PageLibsMysqlRanges
- \subpage PageLibsMysqlSerialization
- \subpage PageLibsMysqlSets
- \subpage PageLibsMysqlStrconv
- \subpage PageLibsMysqlUtils


\defgroup GroupLibsMysql Libraries

\defgroup GroupLibsMysqlAbiHelpers Abi Helpers
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlAllocators Allocators
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlBinlogEvent Binlog Event
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlContainers Containers
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlDebugging Debugging
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlGtid GTID
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlGtids Gtids
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlIterators Iterators
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlMath Math
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlMeta Meta
\defgroup GroupLibsMysqlRanges Ranges
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlSerialization Serialization
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlSets Sets
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlStrconv Strconv
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlUtils Utils
\ingroup GroupLibsMysql
\defgroup GroupLibsMysqlUuids Uuids
\ingroup GroupLibsMysql
