/* Copyright (c) 2017, 2025, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is designed to work with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have either included with
   the program or referenced in the documentation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */

#ifndef SQL_OUTFILE_DEFAULTS_INCLUDED
#define SQL_OUTFILE_DEFAULTS_INCLUDED

#include <cstring>
#include "mysql/strings/m_ctype.h"
#include "sql_string.h"

/* Defaults for TEXT */
static const String default_field_term_text("\t", default_charset_info);
static const String default_null_value_text("NULL", default_charset_info);

/* Defaults for CSV */
static const String default_field_term_csv(",", default_charset_info);
static const String default_enclosed_csv("\"", default_charset_info);
static const String default_null_value_csv("\\N", default_charset_info);
static const String default_characterset_csv("utf8mb4", default_charset_info);

/* Common Defaults for TEXT and CSV */
static const String my_empty_string("", default_charset_info);
static const String default_escaped("\\", default_charset_info);
static const String default_line_term_text_csv("\n", default_charset_info);

/* Defaults for XML */
static const String default_xml_row_term("<row>", default_charset_info);

/* Defaults for Parquet */
static const String default_compression("uncompressed", default_charset_info);

/* Defaults for JSON */
static const String default_line_term_json("\n", default_charset_info);
static const String default_field_term_json("|", default_charset_info);
static const String default_enclosed_json("?", default_charset_info);

#endif
