/* Copyright (c) 2004, 2022, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */
/*
  Do not edit this file, it is automatically generated from:
  </var/lib/pb2/sb_1-5546793-1639761220.3/rpm/BUILD/mysql-8.0.28/mysql-8.0.28/scripts/mysql_system_users.sql>
*/
const char* mysql_system_users[]={
"-- Copyright (c) 2018, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License, version 2.0,\n"
  "-- as published by the Free Software Foundation.\n"
  "--\n"
  "-- This program is also distributed with certain software (including\n"
  "-- but not limited to OpenSSL) that is licensed under separate terms,\n"
  "-- as designated in a particular file or component or in included license\n"
  "-- documentation.  The authors of MySQL hereby grant you an additional\n"
  "-- permission to link the program and your derivative works with the\n"
  "-- separately licensed software that they have included with MySQL.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License, version 2.0, for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- Create the system users and grant them appropiate privileges.\n"
  "-- These users are used for internally.\n"
  "-- This script is called only while initializing the database.\n"
  "--\n"
  "-- Create an user that is used by plugins.\n"
  "CREATE USER 'mysql.session'@localhost IDENTIFIED WITH caching_sha2_password\n"
  " AS '$A$005$THISISACOMBINATIONOFINVALIDSALTANDPASSWORDTHATMUSTNEVERBRBEUSED'\n"
  " ACCOUNT LOCK;\n",
"REVOKE ALL PRIVILEGES, GRANT OPTION FROM 'mysql.session'@localhost;\n",
"GRANT SELECT ON mysql.user TO 'mysql.session'@localhost;\n",
"GRANT SELECT ON `performance_schema`.* TO 'mysql.session'@localhost;\n",
"GRANT SUPER ON *.* TO 'mysql.session'@localhost;\n",
"GRANT SYSTEM_VARIABLES_ADMIN ON *.* TO 'mysql.session'@localhost;\n",
"GRANT SESSION_VARIABLES_ADMIN ON *.* TO 'mysql.session'@localhost;\n",
"GRANT PERSIST_RO_VARIABLES_ADMIN ON *.* TO 'mysql.session'@localhost;\n",
"GRANT CLONE_ADMIN ON *.* TO 'mysql.session'@localhost;\n",
"GRANT BACKUP_ADMIN ON *.* TO 'mysql.session'@localhost;\n",
"GRANT SHUTDOWN ON *.* TO 'mysql.session'@localhost;\n",
"GRANT CONNECTION_ADMIN ON *.* TO 'mysql.session'@localhost;\n",
"GRANT SYSTEM_USER ON *.* TO 'mysql.session'@localhost;\n",
"-- this is a plugin priv that might not be registered\n"
  "INSERT IGNORE INTO mysql.global_grants VALUES ('mysql.session', 'localhost', 'AUDIT_ABORT_EXEMPT', 'N');\n",
"-- Create an user that is definer for information_schema view\n"
  "CREATE USER 'mysql.infoschema'@localhost IDENTIFIED WITH caching_sha2_password\n"
  " AS '$A$005$THISISACOMBINATIONOFINVALIDSALTANDPASSWORDTHATMUSTNEVERBRBEUSED'\n"
  " ACCOUNT LOCK;\n",
"REVOKE ALL PRIVILEGES, GRANT OPTION FROM 'mysql.infoschema'@localhost;\n",
"GRANT SELECT ON *.* TO 'mysql.infoschema'@localhost;\n",
"GRANT SYSTEM_USER ON *.* TO 'mysql.infoschema'@localhost;\n",
"-- this is a plugin priv that might not be registered\n"
  "INSERT IGNORE INTO mysql.global_grants VALUES ('mysql.infoschema', 'localhost', 'AUDIT_ABORT_EXEMPT', 'N');\n",
NULL
};
