/* Copyright (c) 2004, 2022, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */
/*
  Do not edit this file, it is automatically generated from:
  </var/lib/pb2/sb_1-5546793-1639761220.3/rpm/BUILD/mysql-8.0.28/mysql-8.0.28/scripts/firewall_stored_procedures.sql>
*/
const char* firewall_stored_procedures[]={
"-- Copyright (c) 2020, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License, version 2.0,\n"
  "-- as published by the Free Software Foundation.\n"
  "--\n"
  "-- This program is also distributed with certain software (including\n"
  "-- but not limited to OpenSSL) that is licensed under separate terms,\n"
  "-- as designated in a particular file or component or in included license\n"
  "-- documentation.  The authors of MySQL hereby grant you an additional\n"
  "-- permission to link the program and your derivative works with the\n"
  "-- separately licensed software that they have included with MySQL.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License, version 2.0, for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- Remove existing Firewall stored procedures\n"
  "--\n"
  "DROP PROCEDURE IF EXISTS sp_set_firewall_mode;\n",
"DROP PROCEDURE IF EXISTS sp_reload_firewall_rules;\n",
"DROP PROCEDURE IF EXISTS sp_set_firewall_group_mode;\n",
"DROP PROCEDURE IF EXISTS sp_set_firewall_group_mode_and_user;\n",
"DROP PROCEDURE IF EXISTS sp_reload_firewall_group_rules;\n",
"DROP PROCEDURE IF EXISTS sp_firewall_group_enlist;\n",
"DROP PROCEDURE IF EXISTS sp_firewall_group_delist;\n",
"--\n"
  "-- Create new variants of Firewall stored procedures\n"
  "--\n"
  "CREATE DEFINER='mysql.sys'@'localhost'\n"
  "  PROCEDURE sp_set_firewall_mode (\n"
  "    IN arg_userhost VARCHAR(288),\n"
  "    IN arg_mode VARCHAR(12))\n"
  "  SQL SECURITY INVOKER\n"
  "BEGIN\n"
  "  DECLARE result VARCHAR(160);\n"
  "  IF arg_mode = \"RECORDING\" THEN\n"
  "    SELECT read_firewall_whitelist(arg_userhost,FW.rule) FROM mysql.firewall_whitelist FW WHERE userhost = arg_userho"
  "st;\n"
  "  END IF;\n"
  "  SELECT set_firewall_mode(arg_userhost, arg_mode) INTO result;\n"
  "  IF arg_mode = \"RESET\" THEN\n"
  "    SET arg_mode = \"OFF\";\n"
  "  END IF;\n"
  "  IF result = \"OK\" THEN\n"
  "    INSERT IGNORE INTO mysql.firewall_users VALUES (arg_userhost, arg_mode);\n"
  "    UPDATE mysql.firewall_users SET mode=arg_mode WHERE userhost = arg_userhost;\n"
  "  ELSE\n"
  "    SELECT result;\n"
  "  END IF;\n"
  "  IF arg_mode = \"PROTECTING\" OR arg_mode = \"OFF\" OR arg_mode = \"DETECTING\" THEN\n"
  "    DELETE FROM mysql.firewall_whitelist WHERE USERHOST = arg_userhost;\n"
  "    INSERT INTO mysql.firewall_whitelist(USERHOST, RULE) SELECT USERHOST,RULE FROM INFORMATION_SCHEMA.mysql_firewall_"
  "whitelist WHERE USERHOST=arg_userhost;\n"
  "  END IF;\n"
  "END\n",
"CREATE DEFINER='mysql.sys'@'localhost'\n"
  "  PROCEDURE sp_reload_firewall_rules (\n"
  "    IN arg_userhost VARCHAR(288))\n"
  "  SQL SECURITY INVOKER\n"
  "BEGIN\n"
  "  DECLARE result VARCHAR(160);\n"
  "  SELECT set_firewall_mode(arg_userhost, \"RESET\") INTO result;\n"
  "  IF result = \"OK\" THEN\n"
  "    INSERT IGNORE INTO mysql.firewall_users VALUES (arg_userhost, \"OFF\");\n"
  "    UPDATE mysql.firewall_users SET mode=\"OFF\" WHERE userhost = arg_userhost;\n"
  "    SELECT read_firewall_whitelist(arg_userhost,FW.rule) FROM mysql.firewall_whitelist FW WHERE FW.userhost=arg_userh"
  "ost;\n"
  "  ELSE\n"
  "    SELECT result;\n"
  "  END IF;\n"
  "END\n",
"CREATE DEFINER='mysql.sys'@'localhost'\n"
  "  PROCEDURE sp_set_firewall_group_mode (\n"
  "    IN arg_group_name VARCHAR(288),\n"
  "    IN arg_mode VARCHAR(12))\n"
  "  SQL SECURITY INVOKER\n"
  "BEGIN\n"
  "  DECLARE result VARCHAR(160);\n"
  "  IF arg_mode = \"RECORDING\" THEN\n"
  "    SELECT read_firewall_group_allowlist(arg_group_name,FW.rule) FROM mysql.firewall_group_allowlist FW WHERE name = "
  "arg_group_name;\n"
  "  END IF;\n"
  "  SELECT set_firewall_group_mode(arg_group_name, arg_mode) INTO result;\n"
  "  IF arg_mode = \"RESET\" THEN\n"
  "    SET arg_mode = \"OFF\";\n"
  "  END IF;\n"
  "  IF result = \"OK\" THEN\n"
  "    INSERT IGNORE INTO mysql.firewall_groups VALUES (arg_group_name, arg_mode, NULL);\n"
  "    UPDATE mysql.firewall_groups SET mode=arg_mode WHERE name = arg_group_name;\n"
  "  ELSE\n"
  "    SELECT result;\n"
  "  END IF;\n"
  "  IF arg_mode = \"PROTECTING\" OR arg_mode = \"OFF\" OR arg_mode = \"DETECTING\" THEN\n"
  "    DELETE FROM mysql.firewall_group_allowlist WHERE name = arg_group_name;\n"
  "    INSERT INTO mysql.firewall_group_allowlist(name, rule)\n"
  "      SELECT name, rule FROM performance_schema.firewall_group_allowlist\n"
  "      WHERE name=arg_group_name;\n"
  "  END IF;\n"
  "END\n",
"CREATE DEFINER='mysql.sys'@'localhost'\n"
  "  PROCEDURE sp_set_firewall_group_mode_and_user(\n"
  "    IN arg_group_name VARCHAR(288),\n"
  "    IN arg_mode VARCHAR(12),\n"
  "    IN arg_userhost VARCHAR(288))\n"
  "  SQL SECURITY INVOKER\n"
  "BEGIN\n"
  "  DECLARE result VARCHAR(160);\n"
  "  IF arg_mode = \"RECORDING\" THEN\n"
  "    SELECT read_firewall_group_allowlist(arg_group_name,FW.rule) FROM mysql.firewall_group_allowlist FW WHERE name = "
  "arg_group_name;\n"
  "  END IF;\n"
  "  SELECT set_firewall_group_mode(arg_group_name, arg_mode, arg_userhost) INTO result;\n"
  "  IF arg_mode = \"RESET\" THEN\n"
  "    SET arg_mode = \"OFF\";\n"
  "  END IF;\n"
  "  IF result = \"OK\" THEN\n"
  "    INSERT IGNORE INTO mysql.firewall_groups VALUES (arg_group_name, arg_mode, arg_userhost);\n"
  "    UPDATE mysql.firewall_groups SET mode=arg_mode, userhost=arg_userhost WHERE name = arg_group_name;\n"
  "  ELSE\n"
  "    SELECT result;\n"
  "  END IF;\n"
  "  IF arg_mode = \"PROTECTING\" OR arg_mode = \"OFF\" OR arg_mode = \"DETECTING\" THEN\n"
  "    DELETE FROM mysql.firewall_group_allowlist WHERE name = arg_group_name;\n"
  "    INSERT INTO mysql.firewall_group_allowlist(name, rule)\n"
  "      SELECT name, rule FROM performance_schema.firewall_group_allowlist\n"
  "      WHERE name=arg_group_name;\n"
  "  END IF;\n"
  "END\n",
"CREATE DEFINER='mysql.sys'@'localhost'\n"
  "  PROCEDURE sp_reload_firewall_group_rules(\n"
  "    IN arg_group_name VARCHAR(288))\n"
  "  SQL SECURITY INVOKER\n"
  "BEGIN\n"
  "  DECLARE result VARCHAR(160);\n"
  "  SELECT set_firewall_group_mode(arg_group_name, \"RESET\") INTO result;\n"
  "  IF result = \"OK\" THEN\n"
  "    INSERT IGNORE INTO mysql.firewall_groups VALUES (arg_group_name, \"OFF\", NULL);\n"
  "    UPDATE mysql.firewall_groups SET mode=\"OFF\" WHERE name = arg_group_name;\n"
  "    SELECT read_firewall_group_allowlist(arg_group_name,FW.rule) FROM mysql.firewall_group_allowlist FW WHERE FW.name"
  "=arg_group_name;\n"
  "  ELSE\n"
  "    SELECT result;\n"
  "  END IF;\n"
  "END\n",
"CREATE DEFINER='mysql.sys'@'localhost'\n"
  "  PROCEDURE sp_firewall_group_enlist(\n"
  "    IN arg_group_name VARCHAR(288),\n"
  "    IN arg_userhost VARCHAR(288))\n"
  "  SQL SECURITY INVOKER\n"
  "BEGIN\n"
  "  DECLARE result VARCHAR(160);\n"
  "  SELECT firewall_group_enlist(arg_group_name, arg_userhost) INTO result;\n"
  "  IF result = \"OK\" THEN\n"
  "    INSERT IGNORE INTO mysql.firewall_membership VALUES (arg_group_name, arg_userhost);\n"
  "  ELSE\n"
  "    SELECT result;\n"
  "  END IF;\n"
  "END\n",
"CREATE DEFINER='mysql.sys'@'localhost'\n"
  "  PROCEDURE sp_firewall_group_delist(\n"
  "    IN arg_group_name VARCHAR(288),\n"
  "    IN arg_userhost VARCHAR(288))\n"
  "  SQL SECURITY INVOKER\n"
  "BEGIN\n"
  "  DECLARE result VARCHAR(160);\n"
  "  SELECT firewall_group_delist(arg_group_name, arg_userhost) INTO result;\n"
  "  IF result = \"OK\" THEN\n"
  "    DELETE IGNORE FROM mysql.firewall_membership WHERE group_id = arg_group_name AND member_id = arg_userhost;\n"
  "  ELSE\n"
  "    SELECT result;\n"
  "  END IF;\n"
  "END\n",
NULL
};
